/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.BackendEditorPatchItemHandlerKt;
import com.jetbrains.rdserver.editors.BackendEditorSynchronizer;
import com.jetbrains.rdserver.rdPatchHandlers.BackendRdPatchContext;
import com.jetbrains.rdserver.rdPatchHandlers.BackendRdPatchItemHandler;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorPatchItemHandler;", "Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchEditorVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "<init>", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchContext;", "apply", "step", "(Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;Lcom/jetbrains/rdserver/rdPatchHandlers/BackendRdPatchContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.backend.split"})
public final class BackendEditorPatchItemHandler
implements BackendRdPatchItemHandler<RdPatchEditorVersion, RdSelectionChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchEditorVersion version, @NotNull BackendRdPatchContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BackendEditorHost editorHost = BackendEditorHost.Companion.getInstance(context.getSession());
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.TextControlId");
        BackendEditorSynchronizer backendEditorSynchronizer = editorHost.tryGetSynchronizer((TextControlId)rdPatchItemId);
        if (backendEditorSynchronizer == null || (backendEditorSynchronizer = backendEditorSynchronizer.getVersion()) == null) {
            BackendEditorPatchItemHandler $this$validate_u24lambda_u240 = this;
            boolean bl = false;
            BackendEditorPatchItemHandlerKt.access$getLogger$p().warn("There is no EditorSynchronizer for " + version.getId() + " documentId");
            return false;
        }
        BackendEditorSynchronizer actualVersion = backendEditorSynchronizer;
        if (!Intrinsics.areEqual((Object)actualVersion, (Object)version.getVersion())) {
            BackendEditorPatchItemHandlerKt.access$getLogger$p().warn("Not matched versions for " + version.getId() + " editorId, actual: " + (RdEditorVersion)actualVersion + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Object apply(@NotNull RdSelectionChangeBase step2, @NotNull BackendRdPatchContext context, @NotNull Continuation<? super Boolean> $completion) {
        BackendEditorPatchItemHandlerKt.access$getLogger$p().trace("Apply editor step: " + step2);
        BackendEditorHost editorHost = BackendEditorHost.Companion.getInstance(context.getSession());
        TextControlId editorId = step2.getEditorId();
        BackendEditorSynchronizer synchronizer = editorHost.tryGetSynchronizer(editorId);
        if (synchronizer == null) {
            BackendEditorPatchItemHandlerKt.access$getLogger$p().error("cannot find synchronizers for " + editorId + " for step " + step2);
            return Boxing.boxBoolean((boolean)false);
        }
        synchronizer.receiveSelection(step2);
        return Boxing.boxBoolean((boolean)true);
    }
}

