/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.ProperTextRange;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reflection.ReflectionUtilKt;
import com.jetbrains.rdserver.editors.DocumentUtilKt;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizer;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizerKt;
import com.jetbrains.rdserver.editors.RemoteEditorDataKt;
import com.jetbrains.rdserver.editors.ScrollRequest;
import java.awt.Point;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u000212B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0012H\u0002J\u0012\u0010!\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J \u0010$\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/editor/impl/ScrollRequestListener;", "from", "Lcom/intellij/openapi/editor/Editor;", "to", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "toUpdateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer$Request;", "sync", "", "request", "(Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer$Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "install", "adviseOnRemoteScroll", "editor", "selectionChanged", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "caretPositionChanged", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "triggerUpdateCarets", "triggerUpdateVisibleArea", "scrollRequest", "Lcom/jetbrains/rdserver/editors/ScrollRequest;", "headlessVisibleAreaChanged", "startOffset", "", "endOffset", "caretAdded", "caretRemoved", "dump", "", "scrollRequested", "targetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Companion", "Request", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEditorToEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorToEditorSynchronizer.kt\ncom/jetbrains/rdserver/editors/EditorToEditorSynchronizer\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,172:1\n230#2,5:173\n230#2,5:178\n*S KotlinDebug\n*F\n+ 1 EditorToEditorSynchronizer.kt\ncom/jetbrains/rdserver/editors/EditorToEditorSynchronizer\n*L\n120#1:173,5\n126#1:178,5\n*E\n"})
public final class EditorToEditorSynchronizer
implements CaretListener,
SelectionListener,
VisibleAreaListener,
ScrollRequestListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor from;
    @NotNull
    private final Editor to;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MutableStateFlow<Request> toUpdateFlow;
    @NotNull
    private static final ReadWriteProperty<Object, Boolean> doNotUpdate$delegate = ReflectionUtilKt.threadLocal(EditorToEditorSynchronizer::doNotUpdate_delegate$lambda$0);
    @NotNull
    private static final Request emptyRequest = new Request(false, false, null, 4, null);

    public EditorToEditorSynchronizer(@NotNull Editor from, @NotNull Editor to, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.from = from;
        this.to = to;
        this.lifetime = lifetime;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.lifetime, (String)"editorToEditorLifetime");
        this.toUpdateFlow = StateFlowKt.MutableStateFlow((Object)new Request(true, true, null, 4, null));
        this.adviseOnRemoteScroll(this.from);
        CoroutineScope coroutineScope = this.lifetime.getCoroutineScope();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus((CoroutineContext)ClientIdKt.asContextElement((ClientId)DocumentUtilKt.clientId(this.to))), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EditorToEditorSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)this.this$0.toUpdateFlow), (long)100L), (Function2)((Function2)new Function2<Request, Continuation<? super Unit>, Object>((CoroutineScope)$this$launch, this.this$0, null){
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            int I$0;
                            int I$1;
                            int I$2;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ EditorToEditorSynchronizer this$0;
                            {
                                this.$$this$launch = $$this$launch;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (Request)this.L$0;
                                var11_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        $this$thisLogger$iv = this.$$this$launch;
                                        $i$f$thisLogger = false;
                                        v0 = Logger.getInstance(CoroutineScope.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                                        $this$thisLogger$iv = v0;
                                        var4_6 = this.this$0;
                                        $i$f$runAndLogException = 0;
                                        var6_9 = $this$runAndLogException$iv;
                                        $this$runAndLogException_u24lambda_u240$iv = var6_9;
                                        $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = 0;
                                        $i$a$-runAndLogException-EditorToEditorSynchronizer$1$1$1 = 0;
                                        com.jetbrains.rdserver.editors.EditorToEditorSynchronizer$Companion.access$setDoNotUpdate(EditorToEditorSynchronizer.Companion, true);
                                        this.L$0 = request;
                                        this.L$1 = $this$runAndLogException$iv;
                                        this.L$2 = var4_6;
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$runAndLogException_u24lambda_u240$iv);
                                        this.I$0 = $i$f$runAndLogException;
                                        this.I$1 = $i$a$-runCatching-LoggerKt$runAndLogException$1$iv;
                                        this.I$2 = $i$a$-runAndLogException-EditorToEditorSynchronizer$1$1$1;
                                        this.label = 1;
                                        v1 = EditorToEditorSynchronizer.access$sync(var4_6, (Request)request, (Continuation)this);
                                        ** if (v1 != var11_3) goto lbl35
lbl34:
                                        // 1 sources

                                        return var11_3;
lbl35:
                                        // 1 sources

                                        ** GOTO lbl56
                                    }
                                    case 1: {
                                        $i$a$-runAndLogException-EditorToEditorSynchronizer$1$1$1 = this.I$2;
                                        $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = this.I$1;
                                        $i$f$runAndLogException = this.I$0;
                                        $this$runAndLogException_u24lambda_u240$iv = (Logger)this.L$3;
                                        var4_6 = (EditorToEditorSynchronizer)this.L$2;
                                        $this$runAndLogException$iv = (Logger)this.L$1;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
                                            ** GOTO lbl56
                                            {
                                                catch (Throwable var10_16) {
                                                    throw var10_16;
                                                }
                                            }
                                            finally {
                                                EditorToEditorSynchronizer.access$getToUpdateFlow$p(var4_6).compareAndSet((Object)request, (Object)EditorToEditorSynchronizer.access$getEmptyRequest$cp());
                                                com.jetbrains.rdserver.editors.EditorToEditorSynchronizer$Companion.access$setDoNotUpdate(EditorToEditorSynchronizer.Companion, false);
                                            }
lbl56:
                                            // 2 sources

                                            var7_10 = Result.constructor-impl((Object)Unit.INSTANCE);
                                        }
                                        catch (Throwable var8_13) {
                                            var7_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_13));
                                        }
                                        LoggerKt.getOrLogException((Object)var7_10, (Logger)$this$runAndLogException$iv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Request p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object sync(Request request, Continuation<? super Unit> $completion) {
        if (!($completion instanceof sync.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ EditorToEditorSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EditorToEditorSynchronizer.access$sync(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!request.getCarets()) ** GOTO lbl24
                $continuation.L$0 = request;
                $continuation.label = 1;
                v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sync$lambda$0(com.jetbrains.rdserver.editors.EditorToEditorSynchronizer ), ()Lkotlin/Unit;)((EditorToEditorSynchronizer)this), (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                request = (Request)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                DocumentExKt.adjustScrollPosition((Editor)this.to);
lbl24:
                // 2 sources

                if (request.getVisibleArea()) {
                    editor = this.from;
                    otherEditor = this.to;
                    lastRequest = request.getScrollRequest();
                    v1 = editor.getScrollingModel().getVisibleArea();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getVisibleArea(...)");
                    visibleArea = v1;
                    request = lastRequest;
                    v2 = request;
                    if (v2 == null || (v2 = v2.getTargetPosition()) == null) {
                        v3 = editor.xyToLogicalPosition(new Point(0, visibleArea.y + visibleArea.height / 3));
                        v2 = v3;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"xyToLogicalPosition(...)");
                    }
                    targetPosition = v2;
                    otherEditor.getScrollingModel().disableAnimation();
                    v4 = otherEditor.getScrollingModel();
                    v5 = request;
                    if (v5 == null || (v5 = v5.getType()) == null) {
                        v5 = ScrollType.CENTER;
                    }
                    v4.scrollTo((LogicalPosition)targetPosition, (ScrollType)v5);
                    otherEditor.getScrollingModel().enableAnimation();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void install() {
        block0: {
            this.from.getSelectionModel().addSelectionListener((SelectionListener)this, this.disposable);
            this.from.getCaretModel().addCaretListener((CaretListener)this, this.disposable);
            this.from.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this, this.disposable);
            ScrollingModel scrollingModel = this.from.getScrollingModel();
            ScrollingModelImpl scrollingModelImpl = scrollingModel instanceof ScrollingModelImpl ? (ScrollingModelImpl)scrollingModel : null;
            if (scrollingModelImpl == null) break block0;
            scrollingModelImpl.addScrollRequestListener((ScrollRequestListener)this, this.disposable);
        }
    }

    private final void adviseOnRemoteScroll(Editor editor) {
        block0: {
            OptProperty<ProperTextRange> optProperty = RemoteEditorDataKt.getRemoteEditorData(editor);
            if (optProperty == null || (optProperty = optProperty.getVisibleRange()) == null) break block0;
            optProperty.advise(this.lifetime, arg_0 -> EditorToEditorSynchronizer.adviseOnRemoteScroll$lambda$0(this, editor, arg_0));
        }
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.triggerUpdateCarets();
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.triggerUpdateCarets();
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            return;
        }
        this.triggerUpdateVisibleArea(null);
    }

    private final void triggerUpdateCarets() {
        Request it;
        Request nextValue$iv;
        Object prevValue$iv;
        if (EditorToEditorSynchronizer.Companion.getDoNotUpdate()) {
            return;
        }
        MutableStateFlow<Request> $this$update$iv = this.toUpdateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Request)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Request.copy$default(it, true, false, null, 6, null))));
    }

    private final void triggerUpdateVisibleArea(ScrollRequest scrollRequest) {
        Request request;
        Request nextValue$iv;
        Object prevValue$iv;
        if (EditorToEditorSynchronizer.Companion.getDoNotUpdate()) {
            return;
        }
        MutableStateFlow<Request> $this$update$iv = this.toUpdateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            Request it = (Request)prevValue$iv;
            boolean bl = false;
            if (scrollRequest == null) {
                request = Request.copy$default(it, false, true, null, 5, null);
                continue;
            }
            request = Request.copy$default(it, false, true, scrollRequest, 1, null);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = request)));
    }

    private final void headlessVisibleAreaChanged(Editor editor, int startOffset, int endOffset) {
        int startLine = editor.offsetToLogicalPosition((int)startOffset).line;
        int endLine = editor.offsetToLogicalPosition((int)endOffset).line;
        int centerLine = (2 * startLine + endLine) / 3;
        LogicalPosition centerLogicalPosition = new LogicalPosition(centerLine, 0);
        this.triggerUpdateVisibleArea(new ScrollRequest(centerLogicalPosition, ScrollType.CENTER));
    }

    public void caretAdded(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.triggerUpdateCarets();
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.triggerUpdateCarets();
    }

    @NotNull
    public final String dump() {
        StringBuilder result = new StringBuilder();
        result.append("from Editor: " + EditorToEditorSynchronizerKt.presentableName(this.from)).append('\n');
        result.append("to Editor: " + EditorToEditorSynchronizerKt.presentableName(this.to)).append('\n');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void scrollRequested(@NotNull LogicalPosition targetPosition, @NotNull ScrollType scrollType) {
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            return;
        }
        this.triggerUpdateVisibleArea(new ScrollRequest(targetPosition, scrollType));
    }

    private static final Unit sync$lambda$0(EditorToEditorSynchronizer this$0) {
        this$0.to.getCaretModel().setCaretsAndSelections(this$0.from.getCaretModel().getCaretsAndSelections());
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnRemoteScroll$lambda$0(EditorToEditorSynchronizer this$0, Editor $editor, ProperTextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.headlessVisibleAreaChanged($editor, it.getStartOffset(), it.getEndOffset());
        return Unit.INSTANCE;
    }

    private static final boolean doNotUpdate_delegate$lambda$0() {
        return false;
    }

    public static final /* synthetic */ Object access$sync(EditorToEditorSynchronizer $this, Request request, Continuation $completion) {
        return $this.sync(request, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Request access$getEmptyRequest$cp() {
        return emptyRequest;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer$Companion;", "", "<init>", "()V", "<set-?>", "", "doNotUpdate", "getDoNotUpdate", "()Z", "setDoNotUpdate", "(Z)V", "doNotUpdate$delegate", "Lkotlin/properties/ReadWriteProperty;", "emptyRequest", "Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer$Request;", "intellij.platform.backend.split"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final boolean getDoNotUpdate() {
            return (Boolean)doNotUpdate$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setDoNotUpdate(boolean bl) {
            doNotUpdate$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        public static final /* synthetic */ void access$setDoNotUpdate(Companion $this, boolean bl) {
            $this.setDoNotUpdate(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Companion.class, "doNotUpdate", "getDoNotUpdate()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer$Request;", "", "carets", "", "visibleArea", "scrollRequest", "Lcom/jetbrains/rdserver/editors/ScrollRequest;", "<init>", "(ZZLcom/jetbrains/rdserver/editors/ScrollRequest;)V", "getCarets", "()Z", "getVisibleArea", "getScrollRequest", "()Lcom/jetbrains/rdserver/editors/ScrollRequest;", "equals", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "", "intellij.platform.backend.split"})
    public static final class Request {
        private final boolean carets;
        private final boolean visibleArea;
        @Nullable
        private final ScrollRequest scrollRequest;

        public Request(boolean carets, boolean visibleArea, @Nullable ScrollRequest scrollRequest) {
            this.carets = carets;
            this.visibleArea = visibleArea;
            this.scrollRequest = scrollRequest;
        }

        public /* synthetic */ Request(boolean bl, boolean bl2, ScrollRequest scrollRequest, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                scrollRequest = null;
            }
            this(bl, bl2, scrollRequest);
        }

        public final boolean getCarets() {
            return this.carets;
        }

        public final boolean getVisibleArea() {
            return this.visibleArea;
        }

        @Nullable
        public final ScrollRequest getScrollRequest() {
            return this.scrollRequest;
        }

        public boolean equals(@Nullable Object other) {
            return other == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public final boolean component1() {
            return this.carets;
        }

        public final boolean component2() {
            return this.visibleArea;
        }

        @Nullable
        public final ScrollRequest component3() {
            return this.scrollRequest;
        }

        @NotNull
        public final Request copy(boolean carets, boolean visibleArea, @Nullable ScrollRequest scrollRequest) {
            return new Request(carets, visibleArea, scrollRequest);
        }

        public static /* synthetic */ Request copy$default(Request request, boolean bl, boolean bl2, ScrollRequest scrollRequest, int n, Object object) {
            if ((n & 1) != 0) {
                bl = request.carets;
            }
            if ((n & 2) != 0) {
                bl2 = request.visibleArea;
            }
            if ((n & 4) != 0) {
                scrollRequest = request.scrollRequest;
            }
            return request.copy(bl, bl2, scrollRequest);
        }

        @NotNull
        public String toString() {
            return "Request(carets=" + this.carets + ", visibleArea=" + this.visibleArea + ", scrollRequest=" + this.scrollRequest + ")";
        }
    }
}

