/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors.crumbs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ApplicationKt;
import com.intellij.xml.breadcrumbs.BreadcrumbListener;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.CrumbSession;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.crumbs.CrumbExtensionProviderKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/editors/crumbs/BackendBreadcrumbListener;", "Lcom/intellij/xml/breadcrumbs/BreadcrumbListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "breadcrumbsChanged", "", "crumbs", "", "Lcom/intellij/ui/components/breadcrumbs/Crumb;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nlisteners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 listeners.kt\ncom/jetbrains/rdserver/editors/crumbs/BackendBreadcrumbListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n13#2:66\n*S KotlinDebug\n*F\n+ 1 listeners.kt\ncom/jetbrains/rdserver/editors/crumbs/BackendBreadcrumbListener\n*L\n47#1:66\n*E\n"})
public final class BackendBreadcrumbListener
implements BreadcrumbListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private static final Logger logger;

    public BackendBreadcrumbListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    public void breadcrumbsChanged(@NotNull Iterable<? extends Crumb> crumbs) {
        Intrinsics.checkNotNullParameter(crumbs, (String)"crumbs");
        ClientAppSession session = (ClientAppSession)ClientId.Companion.withClientId(ClientEditorManager.Companion.getClientId(this.editor), BackendBreadcrumbListener::breadcrumbsChanged$lambda$0);
        int offset = this.editor.getCaretModel().getOffset();
        TextControlModel textControlModel = BackendEditorHost.Companion.getTextControlModel(this.editor);
        CrumbSession crumbSession = textControlModel != null && (textControlModel = TextControlModelExKt.getCrumbsSession((TextControlModel)textControlModel)) != null ? (CrumbSession)textControlModel.getValue() : null;
        logger.trace("updating crumbs for " + BackendEditorHost.Companion.textControlIdForSession(this.editor, session) + ", offset: " + offset);
        if (!(crumbSession != null ? offset == crumbSession.getOffset() : false)) {
            CrumbSession crumbSession2 = crumbSession;
            logger.trace("offsets don't match, setting new session. current offset: " + offset + ", expected: " + (crumbSession2 != null ? Integer.valueOf(crumbSession2.getOffset()) : null));
            CrumbSession newSession = new CrumbSession(offset, 0);
            newSession.getCrumbs().set(CrumbExtensionProviderKt.toModel(crumbs, this.editor, session));
            Unit cfr_ignored_0 = (Unit)ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> BackendBreadcrumbListener.breadcrumbsChanged$lambda$1(this, newSession));
        } else {
            crumbSession.getCrumbs().set(CrumbExtensionProviderKt.toModel(crumbs, this.editor, session));
        }
    }

    private static final ClientAppSession breadcrumbsChanged$lambda$0() {
        return ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
    }

    private static final Unit breadcrumbsChanged$lambda$1(BackendBreadcrumbListener this$0, CrumbSession $newSession) {
        Unit unit;
        TextControlModel textControlModel = BackendEditorHost.Companion.getTextControlModel(this$0.editor);
        if (textControlModel != null && (textControlModel = TextControlModelExKt.getCrumbsSession((TextControlModel)textControlModel)) != null) {
            textControlModel.set((Object)$newSession);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendBreadcrumbListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendBreadcrumbListener.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/editors/crumbs/BackendBreadcrumbListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

