/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.treeStructure.SimpleNode;
import com.jetbrains.codeWithMe.model.RemoteSettingsSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.options.BackendSpotlightsManagerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/options/BackendSpotlightsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "configurables", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "settingsSession", "Lcom/jetbrains/codeWithMe/model/RemoteSettingsSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/jetbrains/codeWithMe/model/RemoteSettingsSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/CoroutineScope;)V", "spotlightPainters", "", "Lcom/intellij/openapi/options/newEditor/SpotlightPainter;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "settingsFilter", "Lcom/jetbrains/rdserver/options/BackendSpotlightsManager$SpotlightSettingsFilter;", "installSpotlightPainter", "", "component", "Ljavax/swing/JComponent;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "updateSpotlights", "now", "", "SpotlightSettingsFilter", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendSpotlightsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendSpotlightsManager.kt\ncom/jetbrains/rdserver/options/BackendSpotlightsManager\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,100:1\n194#2,9:101\n*S KotlinDebug\n*F\n+ 1 BackendSpotlightsManager.kt\ncom/jetbrains/rdserver/options/BackendSpotlightsManager\n*L\n75#1:101,9\n*E\n"})
public final class BackendSpotlightsManager {
    @NotNull
    private final List<SpotlightPainter> spotlightPainters;
    @NotNull
    private final SearchTextField searchTextField;
    @NotNull
    private final SpotlightSettingsFilter settingsFilter;

    public BackendSpotlightsManager(@Nullable Project project, @NotNull List<? extends ConfigurableGroup> configurables, @NotNull RemoteSettingsSession settingsSession, @NotNull Lifetime lifetime, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(configurables, (String)"configurables");
        Intrinsics.checkNotNullParameter((Object)settingsSession, (String)"settingsSession");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.spotlightPainters = new ArrayList();
        this.searchTextField = new SearchTextField();
        this.settingsFilter = new SpotlightSettingsFilter(project, configurables, this.searchTextField, coroutineScope);
        settingsSession.getUpdateSpotlights().advise(lifetime, arg_0 -> BackendSpotlightsManager._init_$lambda$0(this, arg_0));
    }

    public final void installSpotlightPainter(@NotNull JComponent component, @NotNull Configurable configurable, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        SpotlightPainter painter = new SpotlightPainter(component, arg_0 -> BackendSpotlightsManager.installSpotlightPainter$lambda$0(component, this, configurable, arg_0));
        painter.updateLater();
        this.spotlightPainters.add(painter);
        lifetime.onTermination(() -> BackendSpotlightsManager.installSpotlightPainter$lambda$1(this, painter));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSpotlights(boolean now) {
        void $this$forEachLoggingErrors$iv;
        Collection collection = this.spotlightPainters;
        Logger logger$iv = BackendSpotlightsManagerKt.access$getLOG$p();
        boolean $i$f$forEachLoggingErrors = false;
        for (Object it$iv : $this$forEachLoggingErrors$iv) {
            try {
                SpotlightPainter painter = (SpotlightPainter)it$iv;
                boolean bl = false;
                if (now) {
                    painter.updateNow();
                    continue;
                }
                painter.updateLater();
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
            }
        }
    }

    private static final Unit _init_$lambda$0(BackendSpotlightsManager this$0, String spotlightFilterText) {
        this$0.searchTextField.setText(spotlightFilterText);
        return Unit.INSTANCE;
    }

    private static final Unit installSpotlightPainter$lambda$0(JComponent $component, BackendSpotlightsManager this$0, Configurable $configurable, SpotlightPainter painter) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        if ($component.isVisible()) {
            painter.update((SettingsFilter)this$0.settingsFilter, $configurable, $component);
        }
        return Unit.INSTANCE;
    }

    private static final Unit installSpotlightPainter$lambda$1(BackendSpotlightsManager this$0, SpotlightPainter $painter) {
        this$0.spotlightPainters.remove($painter);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdserver/options/BackendSpotlightsManager$SpotlightSettingsFilter;", "Lcom/intellij/openapi/options/newEditor/SettingsFilter;", "project", "Lcom/intellij/openapi/project/Project;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "search", "Lcom/intellij/ui/SearchTextField;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetbrains/rdserver/options/BackendSpotlightsManager;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/ui/SearchTextField;Lkotlinx/coroutines/CoroutineScope;)V", "getConfigurable", "Lcom/intellij/openapi/options/Configurable;", "node", "Lcom/intellij/ui/treeStructure/SimpleNode;", "findNode", "configurable", "updateSpotlight", "", "now", "", "intellij.platform.backend.split"})
    private final class SpotlightSettingsFilter
    extends SettingsFilter {
        public SpotlightSettingsFilter(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @NotNull SearchTextField search, CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter(groups, (String)"groups");
            Intrinsics.checkNotNullParameter((Object)search, (String)"search");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            super(project, groups, search, coroutineScope);
        }

        @NotNull
        protected Configurable getConfigurable(@Nullable SimpleNode node) {
            Configurable configurable = SettingsTreeView.getConfigurable((SimpleNode)node);
            Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"getConfigurable(...)");
            return configurable;
        }

        @Nullable
        protected SimpleNode findNode(@Nullable Configurable configurable) {
            return null;
        }

        protected void updateSpotlight(boolean now) {
            BackendSpotlightsManager.this.updateSpotlights(now);
        }
    }
}

