/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0017\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/LinuxProcessInfoUtil;", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil;", "<init>", "()V", "get", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "pid", "", "getExecutable", "Ljava/nio/file/Path;", "getCommandLine", "", "getParentPid", "(J)Ljava/lang/Long;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLinuxProcessInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxProcessInfoUtil.kt\ncom/jetbrains/rdserver/portForwarding/utils/LinuxProcessInfoUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n23#2:58\n23#2:59\n23#2:62\n296#3,2:60\n*S KotlinDebug\n*F\n+ 1 LinuxProcessInfoUtil.kt\ncom/jetbrains/rdserver/portForwarding/utils/LinuxProcessInfoUtil\n*L\n26#1:58\n38#1:59\n53#1:62\n49#1:60,2\n*E\n"})
public final class LinuxProcessInfoUtil
implements ProcessInfoUtil {
    @NotNull
    public static final LinuxProcessInfoUtil INSTANCE = new LinuxProcessInfoUtil();

    private LinuxProcessInfoUtil() {
    }

    @Override
    @NotNull
    public ProcessInfoUtil.ProcessInfo get(long pid) {
        return new ProcessInfoUtil.ProcessInfo(pid, this.getCommandLine(pid), this.getExecutable(pid), this.getParentPid(pid));
    }

    private final Path getExecutable(long pid) {
        try {
            Path procfsExe = Path.of("/proc/" + pid + "/exe", new String[0]);
            Path target = procfsExe.toRealPath(new LinkOption[0]);
            return target;
        }
        catch (Throwable e) {
            LinuxProcessInfoUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LinuxProcessInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to read executable name from procfs for pid " + pid, e);
            Path path = null;
            return path;
        }
    }

    private final String getCommandLine(long pid) {
        Object object;
        try {
            Path path = Path.of("/proc/" + pid + "/cmdline", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            object = new char[]{'\u0000'};
            object = StringsKt.replace$default((String)StringsKt.trimEnd((String)PathsKt.readText$default((Path)path, null, (int)1, null), (char[])object), (char)'\u0000', (char)' ', (boolean)false, (int)4, null);
        }
        catch (Throwable e) {
            LinuxProcessInfoUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LinuxProcessInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get cmdline for pid " + pid + " using procfs", e);
            object = null;
        }
        char[] content = object;
        return content;
    }

    private final Long getParentPid(long pid) {
        Long l;
        try {
            String ppidLine;
            String string;
            Object v0;
            block3: {
                Path statusFile = Path.of("/proc/" + pid + "/status", new String[0]);
                Intrinsics.checkNotNull((Object)statusFile);
                List lines = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)statusFile, null, (int)1, null));
                Iterable $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"PPid:", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            l = (string = (ppidLine = (String)v0)) != null && (string = StringsKt.substringAfter$default((String)string, (String)"PPid:", null, (int)2, null)) != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null ? StringsKt.toLongOrNull((String)string) : null;
        }
        catch (Throwable e) {
            LinuxProcessInfoUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LinuxProcessInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get parent pid for pid " + pid + " using procfs", e);
            l = null;
        }
        return l;
    }
}

