/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "<init>", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)"pipePath");
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"INVALID_HANDLE_VALUE");
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        Thread currentThread = Thread.currentThread();
        if (!Intrinsics.areEqual((Object)currentThread, (Object)this.connectionThread)) {
            boolean bl = false;
            String string = "pipe: " + this.pipePath + " wrong thread; expected=" + this.connectionThread + ", actual=" + currentThread;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(this.connectionThread == null)) {
                boolean bl2 = false;
                String string = "pipe " + this.pipePath + ": state=" + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.connectionThread = Thread.currentThread();
            Unit unit = Unit.INSTANCE;
        }
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"CreateNamedPipe(...)");
        this.hPipe = hANDLE;
        if (Intrinsics.areEqual((Object)this.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
            throw new RuntimeException("pipe " + this.pipePath + ": failed to create: lastError=" + ErrorToolsKt.kernel32LastError());
        }
        this.state = NamedPipeState.Open;
        WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("pipe " + this.pipePath + ": created");
    }

    @Override
    public boolean isOpen() {
        return this.state.compareTo((Enum)NamedPipeState.Open) >= 0 && this.state.compareTo((Enum)NamedPipeState.Disconnecting) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        this.assertConnectionThread();
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-WindowsNamedPipeAgentIpc$accept$32 = false;
            if (this.state.compareTo((Enum)NamedPipeState.Closing) >= 0) {
                WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("pipe " + this.pipePath + ": named pipe is either closed or closing, cannot accept. state=" + this.state);
                throw new ClosedChannelException();
            }
            if (!(this.state == NamedPipeState.Open)) {
                boolean bl = false;
                String string = "pipe " + this.pipePath + ": state=" + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connecting;
            Unit $i$a$-synchronized-WindowsNamedPipeAgentIpc$accept$32 = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("pipe " + this.pipePath + ": connecting");
        if (!Kernel32.INSTANCE.ConnectNamedPipe(this.hPipe, null)) {
            int lastError = Kernel32.INSTANCE.GetLastError();
            if (lastError == 535) {
                WindowsNamedPipeAgentIpc $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger2 = false;
                Logger logger2 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("pipe " + this.pipePath + ": connected. Client was connected before we've called ConnectNamedPipe");
            } else {
                throw new IllegalStateException(("pipe " + this.pipePath + ": failed to connect, lastError=" + ErrorToolsKt.prettyHRESULT((int)lastError)).toString());
            }
        }
        Object $this$thisLogger$iv2 = this.lock;
        synchronized ($this$thisLogger$iv2) {
            boolean $i$a$-synchronized-WindowsNamedPipeAgentIpc$accept$42 = false;
            if (this.state.compareTo((Enum)NamedPipeState.Closing) >= 0) {
                throw new ClosedChannelException();
            }
            if (!(this.state == NamedPipeState.Connecting)) {
                boolean $i$a$-require-WindowsNamedPipeAgentIpc$accept$2$22 = false;
                String $i$a$-require-WindowsNamedPipeAgentIpc$accept$2$22 = "pipe " + this.pipePath + ": state=" + this.state;
                throw new IllegalArgumentException($i$a$-require-WindowsNamedPipeAgentIpc$accept$2$22.toString());
            }
            this.state = NamedPipeState.Connected;
            Unit $i$a$-synchronized-WindowsNamedPipeAgentIpc$accept$42 = Unit.INSTANCE;
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger3 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        logger3.info("pipe " + this.pipePath + ": connected");
        long pid = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(pid);
        PipeReadableByteChannel read = new PipeReadableByteChannel(this);
        PipeWritableByteChannel write = new PipeWritableByteChannel(this);
        return new SshAgentIpc.Streams(read, write, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                return inputStream;
            }

            public OutputStream getOutputStream() {
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }
        };
    }

    public final long getRequesterPid() {
        long l;
        WinDef.ULONGByReference clientProcessIdRef = new WinDef.ULONGByReference();
        if (Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, clientProcessIdRef)) {
            WinDef.ULONG clientProcessId = clientProcessIdRef.getValue();
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("pipe " + this.pipePath + ": client process ID: " + clientProcessId);
            l = clientProcessIdRef.getValue().longValue();
        } else {
            int getProcessIdError = Kernel32.INSTANCE.GetLastError();
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("pipe " + this.pipePath + ": failed to get client process ID, error=" + ErrorToolsKt.prettyHRESULT((int)getProcessIdError));
            l = -1L;
        }
        long pid = l;
        return pid;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Object object = process2.getExecutable();
        return object != null && (object = object.getFileName()) != null && (object = object.toString()) != null ? StringsKt.equals((String)object, (String)"ssh.exe", (boolean)true) : false;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnect() {
        this.assertConnectionThread();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.state.compareTo((Enum)NamedPipeState.Closing) >= 0) {
                throw new ClosedChannelException();
            }
            if (this.state == NamedPipeState.Open) {
                WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("pipe " + this.pipePath + " is not connected, no need to disconnect");
                return;
            }
            if (!(this.state == NamedPipeState.Connected)) {
                boolean bl2 = false;
                String string = "pipe " + this.pipePath + ": state=" + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Disconnecting;
            Unit $i$a$-synchronized-WindowsNamedPipeAgentIpc$disconnect$3 = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("pipe " + this.pipePath + ": disconnecting");
        if (!Kernel32.INSTANCE.DisconnectNamedPipe(this.hPipe)) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("pipe " + this.pipePath + ": failed to disconnect, lastError=" + ErrorToolsKt.kernel32LastError());
            return;
        }
        Object $i$f$thisLogger2 = this.lock;
        synchronized ($i$f$thisLogger2) {
            boolean bl = false;
            if (this.state.compareTo((Enum)NamedPipeState.Closing) >= 0) {
                throw new ClosedChannelException();
            }
            this.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger3 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        logger3.info("pipe " + this.pipePath + ": disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int lastError;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.state.compareTo((Enum)NamedPipeState.Closing) >= 0) {
                WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("pipe " + this.pipePath + ": close request, but state=" + this.state + ", skipping");
                return;
            }
            this.state = NamedPipeState.Closing;
            Unit $i$a$-synchronized-WindowsNamedPipeAgentIpc$close$2 = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
        WindowsNamedPipeAgentIpc $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("pipe " + this.pipePath + ": cancelling pending I/O");
        if (!Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null) && (lastError = Kernel32.INSTANCE.GetLastError()) != 1168) {
            WindowsNamedPipeAgentIpc $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("pipe " + this.pipePath + ": failed to close pending I/O, lastError=" + ErrorToolsKt.prettyHRESULT((int)lastError));
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger3 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        logger3.info("pipe " + this.pipePath + ": closing");
        if (!Kernel32.INSTANCE.CloseHandle(this.hPipe)) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger4 = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.warn("pipe " + this.pipePath + ": failed to close, lastError=" + ErrorToolsKt.kernel32LastError());
        }
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"INVALID_HANDLE_VALUE");
        this.hPipe = hANDLE;
        this.state = NamedPipeState.Closed;
    }

    @Override
    public void cleanup() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "<init>", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)"pipePath");
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            WinNT.HANDLE clientHandle = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
            if (clientHandle == null || Intrinsics.areEqual((Object)WinNT.INVALID_HANDLE_VALUE, (Object)clientHandle)) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("pipe " + pipePath + ": didn't open client handle, probably already has I/O");
            }
            Kernel32.INSTANCE.CloseHandle(clientHandle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            static {
                $$INSTANCE = new Companion();
                Library library = Native.load((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
                INSTANCE = (Kernel32Ex)library;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "<init>", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial = new NamedPipeState();
        public static final /* enum */ NamedPipeState Open = new NamedPipeState();
        public static final /* enum */ NamedPipeState Connecting = new NamedPipeState();
        public static final /* enum */ NamedPipeState Connected = new NamedPipeState();
        public static final /* enum */ NamedPipeState Disconnecting = new NamedPipeState();
        public static final /* enum */ NamedPipeState Closing = new NamedPipeState();
        public static final /* enum */ NamedPipeState Closed = new NamedPipeState();
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = namedPipeStateArray = new NamedPipeState[]{NamedPipeState.Initial, NamedPipeState.Open, NamedPipeState.Connecting, NamedPipeState.Connected, NamedPipeState.Disconnecting, NamedPipeState.Closing, NamedPipeState.Closed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "<init>", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            this.agent = agent;
        }

        @Override
        public int read(@NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (!this.agent.isOpen()) {
                throw new ClosedChannelException();
            }
            IntByReference bytesRead = new IntByReference();
            byte[] buffer = new byte[dst.remaining()];
            if (!Kernel32.INSTANCE.ReadFile(this.agent.hPipe, buffer, buffer.length, bytesRead, null)) {
                int errorCode = Kernel32.INSTANCE.GetLastError();
                switch (errorCode) {
                    case 38: {
                        throw new EOFException("pipe " + this.agent.pipePath + ": EOF reached");
                    }
                    case 109: {
                        PipeReadableByteChannel $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(PipeReadableByteChannel.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.info("pipe " + this.agent.pipePath + ": broken pipe, treating it as the end of the stream");
                        return -1;
                    }
                }
                PipeReadableByteChannel $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PipeReadableByteChannel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("pipe " + this.agent.pipePath + ": unexpected error while reading, treating it as the of the stream. hResult=" + ErrorToolsKt.prettyHRESULT((int)errorCode));
                return -1;
            }
            if (bytesRead.getValue() <= 0) {
                return -1;
            }
            dst.put(buffer, 0, bytesRead.getValue());
            return bytesRead.getValue();
        }

        @Override
        public boolean isOpen() {
            return this.agent.state == NamedPipeState.Connected;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "<init>", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            if (!this.agent.isOpen()) {
                throw new ClosedChannelException();
            }
            IntByReference bytesWritten = new IntByReference();
            byte[] buffer = new byte[src.remaining()];
            src.get(buffer);
            if (!Kernel32.INSTANCE.WriteFile(this.agent.hPipe, buffer, buffer.length, bytesWritten, null)) {
                return -1;
            }
            return bytesWritten.getValue();
        }

        @Override
        public boolean isOpen() {
            return this.agent.state == NamedPipeState.Connected;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }
    }
}

