/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.ide.model.uiautomation.BePosition;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.ide.model.uiautomation.UIElementId;
import com.jetbrains.rd.ide.model.BeComponentAnchor;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionMousePositionContext;
import com.jetbrains.rd.ide.model.BePopupRelativePoint;
import com.jetbrains.rd.ui.util.Anchor;
import com.jetbrains.rdserver.actions.ClientPoint;
import java.awt.Component;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \f2\u00020\u0001:\u0001\fJ,\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/ui/BeBackendContextProvider;", "", "tryGetContext", "Lcom/jetbrains/rd/ide/model/BePopupPositionContext;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "desiredSize", "Ljava/awt/Dimension;", "relativePosition", "Lcom/jetbrains/ide/model/uiautomation/BePosition;", "Companion", "intellij.platform.backend.split"})
public interface BeBackendContextProvider {
    @NotNull
    public static final Companion Companion = com.jetbrains.rdserver.ui.BeBackendContextProvider$Companion.$$INSTANCE;

    @Nullable
    public BePopupPositionContext tryGetContext(@NotNull ClientAppSession var1, @NotNull RelativePoint var2, @Nullable Dimension var3, @NotNull BePosition var4);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J%\u0010\u0011\u001a\u00020\u00122\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ4\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ6\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0002J8\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0018\u00010\u00182\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\b\b\u0002\u0010'\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rdserver/ui/BeBackendContextProvider$Companion;", "", "<init>", "()V", "EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rdserver/ui/BeBackendContextProvider;", "getPointContext", "Lcom/jetbrains/rd/ide/model/BePopupPositionContext;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "desiredSize", "Ljava/awt/Dimension;", "relativePosition", "Lcom/jetbrains/ide/model/uiautomation/BePosition;", "getPositionFromRelativePoint", "Lcom/jetbrains/rd/ide/model/BePopupRelativePoint;", "ownerId", "", "Lorg/jetbrains/annotations/NonNls;", "contentDesiredSize", "getPositionFromNonExistingOrNonVisibleOwner", "Lkotlin/Pair;", "Lcom/jetbrains/rd/ide/model/BeComponentAnchor;", "x", "", "y", "getPositionFromExistingVisibleOwner", "ownerDesiredSize", "getPosition", "ownerSize", "popupSize", "findAnchors", "Lcom/jetbrains/rd/ui/util/Anchor;", "popupOffset", "ownerSide", "popupSide", "tolerance", "intellij.platform.backend.split"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<BeBackendContextProvider> EP;

        private Companion() {
        }

        @Nullable
        public final BePopupPositionContext getPointContext(@NotNull ClientAppSession session, @NotNull RelativePoint point, @Nullable Dimension desiredSize, @NotNull BePosition relativePosition) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)relativePosition, (String)"relativePosition");
            if (point.getOriginalPoint() instanceof ClientPoint) {
                return (BePopupPositionContext)new BePopupPositionMousePositionContext(null, 1, null);
            }
            for (BeBackendContextProvider filter : (BeBackendContextProvider[])EP.getExtensions()) {
                BePopupPositionContext context;
                BePopupPositionContext bePopupPositionContext = context = filter.tryGetContext(session, point, desiredSize, relativePosition);
                if (bePopupPositionContext == null) continue;
                return bePopupPositionContext;
            }
            return null;
        }

        public static /* synthetic */ BePopupPositionContext getPointContext$default(Companion companion, ClientAppSession clientAppSession, RelativePoint relativePoint, Dimension dimension, BePosition bePosition, int n, Object object) {
            if ((n & 4) != 0) {
                dimension = null;
            }
            if ((n & 8) != 0) {
                bePosition = BePosition.TOP;
            }
            return companion.getPointContext(clientAppSession, relativePoint, dimension, bePosition);
        }

        @NotNull
        public final BePopupRelativePoint getPositionFromRelativePoint(@NotNull String ownerId, @NotNull RelativePoint point, @Nullable Dimension contentDesiredSize) {
            Pair<BeComponentAnchor, BeComponentAnchor> pair;
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Component component = point.getOriginalComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getOriginalComponent(...)");
            Component owner = component;
            int x = point.getOriginalPoint().x;
            int y = point.getOriginalPoint().y;
            if (owner.getSize().width > 0 && owner.getSize().height > 0) {
                Dimension dimension = owner.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                pair = this.getPositionFromExistingVisibleOwner(x, y, dimension, contentDesiredSize);
            } else {
                pair = this.getPositionFromNonExistingOrNonVisibleOwner(x, y, contentDesiredSize);
            }
            Pair<BeComponentAnchor, BeComponentAnchor> position = pair;
            return new BePopupRelativePoint((ComponentId)new UIElementId(ownerId), (BeComponentAnchor)position.getFirst(), (BeComponentAnchor)position.getSecond(), null, null, 24, null);
        }

        @NotNull
        public final Pair<BeComponentAnchor, BeComponentAnchor> getPositionFromNonExistingOrNonVisibleOwner(int x, int y, @Nullable Dimension contentDesiredSize) {
            int tolerance = 10;
            BeComponentAnchor ownerPosition = BeComponentAnchor.UNDEFINED;
            BeComponentAnchor popupPosition = BeComponentAnchor.UNDEFINED;
            if (Math.abs(x) < tolerance) {
                if (Math.abs(y) < tolerance) {
                    ownerPosition = BeComponentAnchor.TOP_LEFT;
                    popupPosition = BeComponentAnchor.TOP_LEFT;
                } else if (y < tolerance) {
                    ownerPosition = BeComponentAnchor.BOTTOM_LEFT;
                    popupPosition = BeComponentAnchor.TOP_LEFT;
                }
            } else {
                Dimension dimension = contentDesiredSize;
                if (x - (dimension != null ? dimension.width : 0) < tolerance) {
                    ownerPosition = BeComponentAnchor.BOTTOM_RIGHT;
                    popupPosition = BeComponentAnchor.TOP_RIGHT;
                }
            }
            return new Pair((Object)ownerPosition, (Object)popupPosition);
        }

        @NotNull
        public final Pair<BeComponentAnchor, BeComponentAnchor> getPositionFromExistingVisibleOwner(int x, int y, @NotNull Dimension ownerDesiredSize, @Nullable Dimension contentDesiredSize) {
            Dimension popupDesiredSize;
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)ownerDesiredSize, (String)"ownerDesiredSize");
            Dimension dimension = contentDesiredSize;
            if (dimension == null) {
                dimension = new Dimension();
            }
            if ((pair = this.getPosition(x, y, ownerDesiredSize, popupDesiredSize = dimension)) == null) {
                pair = new Pair((Object)BeComponentAnchor.UNDEFINED, (Object)BeComponentAnchor.UNDEFINED);
            }
            return pair;
        }

        private final Pair<BeComponentAnchor, BeComponentAnchor> getPosition(int x, int y, Dimension ownerSize, Dimension popupSize) {
            Pair pair = com.jetbrains.rdserver.ui.BeBackendContextProvider$Companion.findAnchors$default(this, x, ownerSize.width, popupSize.width, 0, 8, null);
            if (pair == null) {
                return null;
            }
            Pair pair2 = pair;
            Anchor xOwnerAnchor = (Anchor)pair2.component1();
            Anchor xPopupAnchor = (Anchor)pair2.component2();
            Pair pair3 = com.jetbrains.rdserver.ui.BeBackendContextProvider$Companion.findAnchors$default(this, y, ownerSize.height, popupSize.height, 0, 8, null);
            if (pair3 == null) {
                return null;
            }
            Pair pair4 = pair3;
            Anchor yOwnerAnchor = (Anchor)pair4.component1();
            Anchor yPopupAnchor = (Anchor)pair4.component2();
            BeComponentAnchor ownerPosition = Anchor.Companion.toPosition(xOwnerAnchor, yOwnerAnchor);
            BeComponentAnchor popupPosition = Anchor.Companion.toPosition(xPopupAnchor, yPopupAnchor);
            return new Pair((Object)ownerPosition, (Object)popupPosition);
        }

        private final Pair<Anchor, Anchor> findAnchors(int popupOffset, int ownerSide, int popupSide, int tolerance) {
            for (Anchor ownerAnchor : Anchor.getEntries()) {
                for (Anchor popupAnchor : Anchor.getEntries()) {
                    float popupCoordinate;
                    float ownerCoordinate = (float)ownerSide * ownerAnchor.getValue();
                    if (!(Math.abs(ownerCoordinate - (popupCoordinate = (float)popupSide * popupAnchor.getValue() + (float)popupOffset)) < (float)tolerance)) continue;
                    return new Pair((Object)ownerAnchor, (Object)popupAnchor);
                }
            }
            return null;
        }

        static /* synthetic */ Pair findAnchors$default(Companion companion, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 8) != 0) {
                n4 = 10;
            }
            return companion.findAnchors(n, n2, n3, n4);
        }

        static {
            $$INSTANCE = new Companion();
            EP = new ExtensionPointName("com.intellij.rdserver.beContextProvider");
        }
    }
}

