/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.ShowBlankDiffWindowActionKt;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diff/actions/DnDHandlerBase;", "Lcom/intellij/openapi/editor/EditorDropHandler;", "project", "Lcom/intellij/openapi/project/Project;", "helper", "Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getHelper", "()Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "canHandleDrop", "", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "([Ljava/awt/datatransfer/DataFlavor;)Z", "handleDnD2", "transferable", "Ljava/awt/datatransfer/Transferable;", "activeSide", "Lcom/intellij/diff/util/Side;", "handleDnD3", "Lcom/intellij/diff/util/ThreeSide;", "intellij.platform.diff.impl"})
abstract class DnDHandlerBase
implements EditorDropHandler {
    @Nullable
    private final Project project;
    @NotNull
    private final MutableDiffRequestChain.Helper helper;

    public DnDHandlerBase(@Nullable Project project, @NotNull MutableDiffRequestChain.Helper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.project = project;
        this.helper = helper;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MutableDiffRequestChain.Helper getHelper() {
        return this.helper;
    }

    protected final void install(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor instanceof EditorImpl) {
            ((EditorImpl)editor).setDropHandler((EditorDropHandler)this);
        }
    }

    public boolean canHandleDrop(@NotNull DataFlavor[] transferFlavors) {
        Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
        return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])transferFlavors);
    }

    protected final void handleDnD2(@NotNull Transferable transferable, @NotNull Side activeSide) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Intrinsics.checkNotNullParameter((Object)activeSide, (String)"activeSide");
        List list = FileCopyPasteUtil.getFileList((Transferable)transferable);
        if (list == null) {
            return;
        }
        List files = list;
        if (files.size() == 1) {
            Object e = files.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e);
            if (documentContent == null) {
                return;
            }
            DocumentContent newContent = documentContent;
            this.helper.setContent((DiffContent)newContent, activeSide);
            this.helper.fireRequestUpdated();
        }
        if (files.size() >= 2) {
            Object e = files.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e);
            if (documentContent == null) {
                return;
            }
            DocumentContent newContent1 = documentContent;
            Object e2 = files.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            DocumentContent documentContent2 = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e2);
            if (documentContent2 == null) {
                return;
            }
            DocumentContent newContent2 = documentContent2;
            this.helper.setContent((DiffContent)newContent1, Side.LEFT);
            this.helper.setContent((DiffContent)newContent2, Side.RIGHT);
            this.helper.fireRequestUpdated();
        }
    }

    protected final void handleDnD3(@NotNull Transferable transferable, @NotNull ThreeSide activeSide) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Intrinsics.checkNotNullParameter((Object)activeSide, (String)"activeSide");
        List list = FileCopyPasteUtil.getFileList((Transferable)transferable);
        if (list == null) {
            return;
        }
        List files = list;
        if (files.size() == 1) {
            Object e = files.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e);
            if (documentContent == null) {
                return;
            }
            DocumentContent newContent = documentContent;
            this.helper.setContent((DiffContent)newContent, activeSide);
            this.helper.fireRequestUpdated();
        }
        if (files.size() == 3) {
            Object e = files.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e);
            if (documentContent == null) {
                return;
            }
            DocumentContent newContent1 = documentContent;
            Object e2 = files.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            DocumentContent documentContent2 = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e2);
            if (documentContent2 == null) {
                return;
            }
            DocumentContent newBaseContent = documentContent2;
            Object e3 = files.get(2);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
            DocumentContent documentContent3 = ShowBlankDiffWindowActionKt.access$createFileContent(this.project, (File)e3);
            if (documentContent3 == null) {
                return;
            }
            DocumentContent newContent2 = documentContent3;
            this.helper.setContent((DiffContent)newContent1, ThreeSide.LEFT);
            this.helper.setContent((DiffContent)newBaseContent, ThreeSide.BASE);
            this.helper.setContent((DiffContent)newContent2, ThreeSide.RIGHT);
            this.helper.fireRequestUpdated();
        }
    }
}

