/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.tools.combined.BlockBounds;
import com.intellij.diff.tools.combined.BlockOrder;
import com.intellij.diff.tools.combined.CombinedBlockId;
import com.intellij.diff.tools.combined.CombinedDiffBlocksPanelKt;
import com.intellij.diff.tools.combined.Holder;
import com.intellij.diff.tools.combined.Placeholder;
import com.intellij.diff.tools.combined.RealComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001#B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0007J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eJ\"\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffBlocksPanel;", "Ljavax/swing/JPanel;", "blockOrder", "Lcom/intellij/diff/tools/combined/BlockOrder;", "lastBlockHeightLogic", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lcom/intellij/diff/tools/combined/CombinedBlockId;", "", "<init>", "(Lcom/intellij/diff/tools/combined/BlockOrder;Lkotlin/jvm/functions/Function1;)V", "blocksLayout", "Lcom/intellij/diff/tools/combined/CombinedDiffBlocksPanel$CombinedDiffBlocksLayout;", "holders", "", "Lcom/intellij/diff/tools/combined/Holder;", "setContent", "", "blockId", "component", "Ljavax/swing/JComponent;", "setPlaceholder", "height", "(Lcom/intellij/diff/tools/combined/CombinedBlockId;Ljava/lang/Integer;)V", "blockIndex", "(ILjava/lang/Integer;)V", "getHeightForBlock", "getBoundsForBlock", "Lcom/intellij/diff/tools/combined/BlockBounds;", "getBlockBounds", "", "calcHeight", "index", "holder", "defaultPlaceholderHeight", "CombinedDiffBlocksLayout", "intellij.platform.diff.impl"})
public final class CombinedDiffBlocksPanel
extends JPanel {
    @NotNull
    private final BlockOrder blockOrder;
    @NotNull
    private final Function1<Pair<? extends CombinedBlockId, Integer>, Integer> lastBlockHeightLogic;
    @NotNull
    private final CombinedDiffBlocksLayout blocksLayout;
    @NotNull
    private final List<Holder> holders;

    public CombinedDiffBlocksPanel(@NotNull BlockOrder blockOrder, @NotNull Function1<? super Pair<? extends CombinedBlockId, Integer>, Integer> lastBlockHeightLogic) {
        Intrinsics.checkNotNullParameter((Object)blockOrder, (String)"blockOrder");
        Intrinsics.checkNotNullParameter(lastBlockHeightLogic, (String)"lastBlockHeightLogic");
        super(null);
        this.blockOrder = blockOrder;
        this.lastBlockHeightLogic = lastBlockHeightLogic;
        this.blocksLayout = new CombinedDiffBlocksLayout();
        this.holders = new ArrayList();
        this.setLayout(this.blocksLayout);
        List<Object> list = Collections.nCopies(this.blockOrder.getBlocksCount(), null);
        Intrinsics.checkNotNullExpressionValue(list, (String)"nCopies(...)");
        this.holders.addAll((Collection<Holder>)list);
    }

    public final void setContent(@NotNull CombinedBlockId blockId, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        int blockIndex = this.blockOrder.indexOf(blockId);
        RealComponent newHolder = new RealComponent(component2);
        Holder oldHolder = this.holders.set(blockIndex, newHolder);
        if (oldHolder instanceof RealComponent) {
            this.remove(((RealComponent)oldHolder).getComponent());
        }
        this.add(component2);
    }

    public final void setPlaceholder(@NotNull CombinedBlockId blockId, @Nullable Integer height) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        int blockIndex = this.blockOrder.indexOf(blockId);
        this.setPlaceholder(blockIndex, height);
    }

    public static /* synthetic */ void setPlaceholder$default(CombinedDiffBlocksPanel combinedDiffBlocksPanel, CombinedBlockId combinedBlockId, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        combinedDiffBlocksPanel.setPlaceholder(combinedBlockId, n);
    }

    private final void setPlaceholder(int blockIndex, Integer height) {
        Holder oldHolder;
        Holder holder = oldHolder = height != null ? this.holders.set(blockIndex, new Placeholder(height)) : (Holder)this.holders.set(blockIndex, null);
        if (oldHolder instanceof RealComponent) {
            this.remove(((RealComponent)oldHolder).getComponent());
        }
    }

    static /* synthetic */ void setPlaceholder$default(CombinedDiffBlocksPanel combinedDiffBlocksPanel, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        combinedDiffBlocksPanel.setPlaceholder(n, n2);
    }

    public final int getHeightForBlock(@NotNull CombinedBlockId blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        int defaultPlaceholderHeight = CombinedDiffBlocksPanelKt.access$defaultPlaceholderBlockHeight();
        int blockIndex = this.blockOrder.indexOf(blockId);
        Holder holder = this.holders.get(blockIndex);
        return this.calcHeight(blockIndex, holder, defaultPlaceholderHeight);
    }

    @NotNull
    public final BlockBounds getBoundsForBlock(@NotNull CombinedBlockId blockId) {
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        int gap = CombinedDiffBlocksPanelKt.access$gap();
        int defaultPlaceholderHeight = CombinedDiffBlocksPanelKt.access$defaultPlaceholderBlockHeight();
        int blockIndex = this.blockOrder.indexOf(blockId);
        int minY = 0;
        int maxY = 0;
        Iterator<CombinedBlockId> iterator = this.blockOrder.iterateBlocks().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            iterator.next();
            Holder holder = this.holders.get(index);
            minY = maxY;
            maxY = minY + this.calcHeight(index, holder, defaultPlaceholderHeight);
            if (index == blockIndex) break;
            maxY += gap;
        }
        return new BlockBounds(blockId, minY, maxY);
    }

    @NotNull
    public final List<BlockBounds> getBlockBounds() {
        int gap = CombinedDiffBlocksPanelKt.access$gap();
        int defaultPlaceholderHeight = CombinedDiffBlocksPanelKt.access$defaultPlaceholderBlockHeight();
        int minY = 0;
        int maxY = 0;
        List bounds = new ArrayList();
        Iterator<CombinedBlockId> iterator = this.blockOrder.iterateBlocks().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            CombinedBlockId id = iterator.next();
            Holder holder = this.holders.get(index);
            minY = maxY;
            maxY = minY + this.calcHeight(index, holder, defaultPlaceholderHeight);
            bounds.add(new BlockBounds(id, minY, maxY));
            maxY += gap;
        }
        return bounds;
    }

    private final int calcHeight(int index, Holder holder, int defaultPlaceholderHeight) {
        Holder holder2 = holder;
        int height = holder2 != null ? holder2.getHeight() : defaultPlaceholderHeight;
        CombinedBlockId blockId = this.blockOrder.getOrNull(index);
        if (index == this.holders.size() - 1 && blockId != null) {
            return ((Number)this.lastBlockHeightLogic.invoke((Object)TuplesKt.to((Object)blockId, (Object)height))).intValue();
        }
        return height;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\u001c\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010\u0010\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0017\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/tools/combined/CombinedDiffBlocksPanel$CombinedDiffBlocksLayout;", "Ljava/awt/LayoutManager2;", "<init>", "(Lcom/intellij/diff/tools/combined/CombinedDiffBlocksPanel;)V", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "", "minimumLayoutSize", "maximumLayoutSize", "target", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "addLayoutComponent", "comp", "Ljava/awt/Component;", "constraints", "", "name", "", "removeLayoutComponent", "invalidateLayout", "intellij.platform.diff.impl"})
    private final class CombinedDiffBlocksLayout
    implements LayoutManager2 {
        @Override
        @NotNull
        public Dimension preferredLayoutSize(@Nullable Container parent) {
            if (parent == null) {
                return new Dimension(0, 0);
            }
            int gap = CombinedDiffBlocksPanelKt.access$gap();
            int defaultPlaceholderHeight = CombinedDiffBlocksPanelKt.access$defaultPlaceholderBlockHeight();
            int w = parent.getWidth();
            int sumH = 0;
            Iterator<CombinedBlockId> iterator = CombinedDiffBlocksPanel.this.blockOrder.iterateBlocks().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                iterator.next();
                Holder holder = (Holder)CombinedDiffBlocksPanel.this.holders.get(index);
                sumH += CombinedDiffBlocksPanel.this.calcHeight(index, holder, defaultPlaceholderHeight) + gap;
            }
            return new Dimension(w, sumH);
        }

        @Override
        public void layoutContainer(@Nullable Container parent) {
            if (parent == null) {
                return;
            }
            int gap = CombinedDiffBlocksPanelKt.access$gap();
            int defaultPlaceholderHeight = CombinedDiffBlocksPanelKt.access$defaultPlaceholderBlockHeight();
            int x = CombinedDiffBlocksPanelKt.access$left();
            int y = 0;
            int w = parent.getWidth() - CombinedDiffBlocksPanelKt.access$left() - CombinedDiffBlocksPanelKt.access$right();
            Iterator<CombinedBlockId> iterator = CombinedDiffBlocksPanel.this.blockOrder.iterateBlocks().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                iterator.next();
                Holder holder = (Holder)CombinedDiffBlocksPanel.this.holders.get(index);
                int height = CombinedDiffBlocksPanel.this.calcHeight(index, holder, defaultPlaceholderHeight);
                if (holder instanceof RealComponent) {
                    ((RealComponent)holder).getComponent().setBounds(new Rectangle(x, y, w, height));
                }
                y += height + gap;
            }
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@Nullable Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        @NotNull
        public Dimension maximumLayoutSize(@Nullable Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public float getLayoutAlignmentX(@Nullable Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(@Nullable Container target) {
            return 0.0f;
        }

        @Override
        public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints) {
        }

        @Override
        public void addLayoutComponent(@Nullable String name, @Nullable Component comp) {
        }

        @Override
        public void removeLayoutComponent(@Nullable Component comp) {
        }

        @Override
        public void invalidateLayout(@Nullable Container target) {
        }
    }
}

