/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.util.Range;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.IntUnaryOperator;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public final class LineNumberConvertor {
    @NotNull
    private final TreeMap<Integer, Data> myFragments;
    @NotNull
    private final TreeMap<Integer, Data> myInvertedFragments;
    @NotNull
    private final Corrector myCorrector;

    private LineNumberConvertor(@NotNull TreeMap<Integer, Data> fragments, @NotNull TreeMap<Integer, Data> invertedFragments) {
        if (fragments == null) {
            LineNumberConvertor.$$$reportNull$$$0(0);
        }
        if (invertedFragments == null) {
            LineNumberConvertor.$$$reportNull$$$0(1);
        }
        this.myCorrector = new Corrector();
        this.myFragments = fragments;
        this.myInvertedFragments = invertedFragments;
    }

    public int convert(int value) {
        return this.convert(value, true, false);
    }

    public int convertInv(int value) {
        return this.convert(value, false, false);
    }

    public int convertApproximate(int value) {
        return this.convert(value, true, true);
    }

    public int convertApproximateInv(int value) {
        return this.convert(value, false, true);
    }

    @NotNull
    public IntUnaryOperator createConvertor() {
        IntUnaryOperator intUnaryOperator = this::convert;
        if (intUnaryOperator == null) {
            LineNumberConvertor.$$$reportNull$$$0(2);
        }
        return intUnaryOperator;
    }

    public int convert(int value, boolean fromMaster, boolean approximate) {
        return this.myCorrector.convertCorrected(value, fromMaster, approximate);
    }

    public void handleMasterChange(int startLine, int endLine, int shift, boolean synchronous) {
        this.myCorrector.handleMasterChange(startLine, endLine, shift, synchronous);
    }

    private int convertRaw(boolean fromMaster, int value, boolean approximate) {
        TreeMap<Integer, Data> fragments;
        TreeMap<Integer, Data> treeMap = fragments = fromMaster ? this.myFragments : this.myInvertedFragments;
        if (approximate) {
            Map.Entry<Integer, Data> prevEntry = fragments.floorEntry(value);
            if (prevEntry == null) {
                return 0;
            }
            int start = prevEntry.getKey();
            Data data = prevEntry.getValue();
            return Math.min(data.otherStart - start + value, data.otherStart + data.otherLength);
        }
        Map.Entry<Integer, Data> prevEntry = fragments.floorEntry(value);
        if (prevEntry == null) {
            return -1;
        }
        int start = prevEntry.getKey();
        Data data = prevEntry.getValue();
        if (value >= start + data.length) {
            return -1;
        }
        if (data.length != data.otherLength) {
            return -1;
        }
        return data.otherStart - start + value;
    }

    @NotNull
    public static LineNumberConvertor fromIterable(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            LineNumberConvertor.$$$reportNull$$$0(3);
        }
        Builder builder = new Builder();
        for (Pair pair : DiffIterableUtil.iterateAll((DiffIterable)iterable)) {
            Range range = (Range)pair.getFirst();
            builder.put(range.start1, range.start2, range.end1 - range.start1, range.end2 - range.start2);
        }
        LineNumberConvertor lineNumberConvertor = builder.build();
        if (lineNumberConvertor == null) {
            LineNumberConvertor.$$$reportNull$$$0(4);
        }
        return lineNumberConvertor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedFragments";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/LineNumberConvertor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/LineNumberConvertor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConvertor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromIterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromIterable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private class Corrector {
        private final List<CorrectedChange> myChanges = new SmartList();

        private Corrector() {
        }

        public void handleMasterChange(int startLine, int endLine, int shift, boolean synchronous) {
            int oldLength = endLine - startLine;
            int newLength = oldLength + shift;
            if (synchronous) {
                int oldSlaveStart = LineNumberConvertor.this.convert(startLine, true, false);
                assert (oldSlaveStart != -1);
                this.myChanges.add(new CorrectedChange(startLine, oldSlaveStart, oldLength, newLength));
            } else {
                this.myChanges.add(new CorrectedChange(startLine, oldLength, newLength));
            }
        }

        public int convertCorrected(int value, boolean fromMaster, boolean approximate) {
            if (fromMaster) {
                return this.convertFromMaster(value, approximate, this.myChanges.size() - 1);
            }
            return this.convertFromSlave(value, approximate, this.myChanges.size() - 1);
        }

        private int convertFromSlave(int value, boolean approximate, int index) {
            if (index < 0) {
                return LineNumberConvertor.this.convertRaw(false, value, approximate);
            }
            CorrectedChange change = this.myChanges.get(index);
            int shift = change.newLength - change.oldLength;
            if (!change.synchronous) {
                int converted = this.convertFromSlave(value, approximate, index - 1);
                if (converted < change.startMaster) {
                    return converted;
                }
                if (converted >= change.startMaster + change.oldLength) {
                    return converted + shift;
                }
                if (!approximate) {
                    return -1;
                }
                return Corrector.append(converted, Math.min(change.newLength, converted - change.startMaster));
            }
            if (value < change.startSlave) {
                return this.convertFromSlave(value, approximate, index - 1);
            }
            if (value >= change.startSlave + change.newLength) {
                int converted = this.convertFromSlave(value - shift, approximate, index - 1);
                return Corrector.append(converted, shift);
            }
            int convertedStart = this.convertFromSlave(change.startSlave, approximate, index - 1);
            return Corrector.append(convertedStart, value - change.startSlave);
        }

        private int convertFromMaster(int value, boolean approximate, int index) {
            if (index < 0) {
                return LineNumberConvertor.this.convertRaw(true, value, approximate);
            }
            CorrectedChange change = this.myChanges.get(index);
            int shift = change.newLength - change.oldLength;
            if (value < change.startMaster) {
                return this.convertFromMaster(value, approximate, index - 1);
            }
            if (value >= change.startMaster + change.newLength) {
                int converted = this.convertFromMaster(value - shift, approximate, index - 1);
                return Corrector.append(converted, change.synchronous ? shift : 0);
            }
            if (!change.synchronous) {
                if (!approximate) {
                    return -1;
                }
                return this.convertFromMaster(change.startMaster, approximate, index - 1);
            }
            int convertedStart = this.convertFromMaster(change.startMaster, approximate, index - 1);
            return Corrector.append(convertedStart, value - change.startMaster);
        }

        private static int append(int value, int shift) {
            return value == -1 ? -1 : value + shift;
        }
    }

    private static class Data {
        public final int length;
        public final int otherStart;
        public final int otherLength;

        Data(int length, int otherStart, int otherLength) {
            this.length = length;
            this.otherStart = otherStart;
            this.otherLength = otherLength;
        }
    }

    public static class Builder {
        @NotNull
        private final TreeMap<Integer, Data> myFragments = new TreeMap();
        @NotNull
        private final TreeMap<Integer, Data> myInvertedFragments = new TreeMap();

        public void put(int masterStart, int slaveStart, int length) {
            this.put(masterStart, slaveStart, length, length);
        }

        public void put(int masterStart, int slaveStart, int masterLength, int slaveLength) {
            this.myFragments.put(masterStart, new Data(masterLength, slaveStart, slaveLength));
            this.myInvertedFragments.put(slaveStart, new Data(slaveLength, masterStart, masterLength));
        }

        @NotNull
        public LineNumberConvertor build() {
            return new LineNumberConvertor(this.myFragments, this.myInvertedFragments);
        }
    }

    private static class CorrectedChange {
        public final boolean synchronous;
        public final int startMaster;
        public final int startSlave;
        public final int oldLength;
        public final int newLength;

        CorrectedChange(int startMaster, int oldLength, int newLength) {
            this.synchronous = false;
            this.startSlave = -1;
            this.startMaster = startMaster;
            this.oldLength = oldLength;
            this.newLength = newLength;
        }

        CorrectedChange(int startMaster, int startSlave, int oldLength, int newLength) {
            this.synchronous = true;
            this.startMaster = startMaster;
            this.startSlave = startSlave;
            this.oldLength = oldLength;
            this.newLength = newLength;
        }
    }
}

