/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.AlignableChange;
import com.intellij.diff.tools.simple.AlignedDiffModelBase;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/tools/simple/SimpleAlignedDiffModel;", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase;", "viewer", "Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "<init>", "(Lcom/intellij/diff/tools/simple/SimpleDiffViewer;)V", "getViewer", "()Lcom/intellij/diff/tools/simple/SimpleDiffViewer;", "getDiffChanges", "", "Lcom/intellij/diff/tools/simple/AlignableChange;", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class SimpleAlignedDiffModel
extends AlignedDiffModelBase {
    @NotNull
    private final SimpleDiffViewer viewer;

    public SimpleAlignedDiffModel(@NotNull SimpleDiffViewer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        ContentDiffRequest contentDiffRequest = viewer.getRequest();
        Intrinsics.checkNotNullExpressionValue((Object)contentDiffRequest, (String)"getRequest(...)");
        DiffRequest diffRequest = (DiffRequest)contentDiffRequest;
        DiffContext diffContext = viewer.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)diffContext, (String)"getContext(...)");
        JComponent jComponent = viewer.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        EditorEx editorEx = viewer.getEditor1();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor1(...)");
        EditorEx editorEx2 = viewer.getEditor2();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getEditor2(...)");
        SyncScrollSupport.SyncScrollable syncScrollable = viewer.getSyncScrollable();
        Intrinsics.checkNotNullExpressionValue((Object)syncScrollable, (String)"getSyncScrollable(...)");
        super(diffRequest, diffContext, jComponent, editorEx, editorEx2, syncScrollable);
        this.viewer = viewer;
        this.getTextSettings().addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener(){

            @Override
            public void alignModeChanged() {
                this.getViewer().rediff();
            }
        }, this);
    }

    @NotNull
    public final SimpleDiffViewer getViewer() {
        return this.viewer;
    }

    @Override
    @NotNull
    public List<AlignableChange> getDiffChanges() {
        List<AlignableChange> list = this.viewer.getDiffChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDiffChanges(...)");
        return list;
    }
}

