/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.breadcrumbs.SimpleDiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends ThreesideDiffViewer<TextEditorHolder>
implements EditorDiffViewer {
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener;
    @Nullable
    protected SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollSupport;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;

    public ThreesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myVisibleAreaListener = new MyVisibleAreaListener();
        new MyFocusOppositePaneAction(true).install(this.myPanel);
        new MyFocusOppositePaneAction(false).install(this.myPanel);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        for (ThreeSide side : ThreeSide.getEntries()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side));
        }
        if (this.getProject() != null) {
            for (ThreeSide side : ThreeSide.getEntries()) {
                this.myContentPanel.setBreadcrumbs(side, new SimpleDiffBreadcrumbsPanel((Editor)this.getEditor(side), (Disposable)this), this.getTextSettings());
            }
        }
    }

    @Override
    @RequiresEdt
    protected void onInit() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(2);
        }
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i = 0; i < 3; ++i) {
            if (!forceReadOnly[i]) continue;
            holders.get(i).getEditor().setViewer(true);
        }
        ((TextEditorHolder)ThreeSide.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        for (TextEditorHolder holder : holders) {
            DiffUtil.disableBlitting(holder.getEditor());
        }
        List<TextEditorHolder> list = holders;
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list = DiffUtil.createTextTitles(this, this.myRequest, this.getEditors());
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(4);
        }
        return list;
    }

    @RequiresEdt
    protected void installEditorListeners() {
        ThreadingAssertions.assertEventDispatchThread();
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors(), this.myPanel);
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(ThreeSide.LEFT).getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.ThreesideSyncScrollSupport(this.getEditors(), scrollable1, scrollable2);
            this.myEditorSettingsAction.setSyncScrollSupport(this.mySyncScrollSupport);
        }
    }

    @RequiresEdt
    public void destroyEditorListeners() {
        ThreadingAssertions.assertEventDispatchThread();
        this.getEditor(ThreeSide.LEFT).getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaListener);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            if (disable) {
                this.mySyncScrollSupport.enterDisableScrollSection();
            } else {
                this.mySyncScrollSupport.exitDisableScrollSection();
            }
        }
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(5);
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list = TextDiffViewerUtil.createEditorPopupActions();
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(7);
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = this.getContent(this.getCurrentSide());
        if (documentContent == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(9);
        }
        return documentContent;
    }

    @NotNull
    public List<? extends DocumentContent> getContents() {
        List list = this.myRequest.getContents();
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), holder -> holder.getEditor());
        }
        List<? extends EditorEx> list = this.myEditors;
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list = this.myEditableEditors;
        if (list == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public EditorEx getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(13);
        }
        EditorEx editorEx = (EditorEx)side.select(this.getEditors());
        if (editorEx == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(15);
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(16);
        }
        return documentContent;
    }

    @Nullable
    public ThreeSide getEditorSide(@Nullable Editor editor) {
        if (this.getEditor(ThreeSide.BASE) == editor) {
            return ThreeSide.BASE;
        }
        if (this.getEditor(ThreeSide.RIGHT) == editor) {
            return ThreeSide.RIGHT;
        }
        if (this.getEditor(ThreeSide.LEFT) == editor) {
            return ThreeSide.LEFT;
        }
        return null;
    }

    @RequiresEdt
    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        if (side == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DiffUtil.scrollEditor((Editor)this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @RequiresEdt
    @NotNull
    public LogicalPosition transferPosition(@NotNull ThreeSide baseSide, @NotNull ThreeSide targetSide, @NotNull LogicalPosition position) {
        if (baseSide == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(18);
        }
        if (targetSide == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(19);
        }
        if (position == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(20);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.mySyncScrollSupport == null) {
            LogicalPosition logicalPosition = position;
            if (logicalPosition == null) {
                ThreesideTextDiffViewer.$$$reportNull$$$0(21);
            }
            return logicalPosition;
        }
        if (baseSide == targetSide) {
            LogicalPosition logicalPosition = position;
            if (logicalPosition == null) {
                ThreesideTextDiffViewer.$$$reportNull$$$0(22);
            }
            return logicalPosition;
        }
        SyncScrollSupport.SyncScrollable scrollable12 = this.mySyncScrollSupport.getScrollable12();
        SyncScrollSupport.SyncScrollable scrollable23 = this.mySyncScrollSupport.getScrollable23();
        int baseLine = baseSide == ThreeSide.LEFT ? scrollable12.transfer(Side.LEFT, position.line) : (baseSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.RIGHT, position.line) : position.line);
        int targetLine = targetSide == ThreeSide.LEFT ? scrollable12.transfer(Side.RIGHT, baseLine) : (targetSide == ThreeSide.RIGHT ? scrollable23.transfer(Side.LEFT, baseLine) : baseLine);
        return new LogicalPosition(targetLine, position.column);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return this.getCurrentContent().getNavigatable(LineCol.fromCaret((Editor)this.getCurrentEditor()));
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(23);
        }
        if (request == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(24);
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ThreesideTextDiffViewer.$$$reportNull$$$0(25);
        }
        super.uiDataSnapshot(sink);
        sink.set(DiffDataKeys.CURRENT_EDITOR, (Object)this.getCurrentEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 14, 16, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSide";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSide";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableEditors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "transferPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolders";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scrollToLine";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "transferPosition";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 14, 16, 21, 22 -> new IllegalStateException(string);
        };
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (ThreesideTextDiffViewer.this.mySyncScrollSupport != null) {
                ThreesideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            ThreesideTextDiffViewer.this.myContentPanel.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        MyFocusOppositePaneAction(boolean scrollToPosition) {
            super(scrollToPosition);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            ThreeSide currentSide = ThreesideTextDiffViewer.this.getCurrentSide();
            ThreeSide targetSide = (ThreeSide)currentSide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
            EditorEx targetEditor = ThreesideTextDiffViewer.this.getEditor(targetSide);
            if (this.myScrollToPosition) {
                LogicalPosition currentPosition = DiffUtil.getCaretPosition((Editor)ThreesideTextDiffViewer.this.getCurrentEditor());
                LogicalPosition position = ThreesideTextDiffViewer.this.transferPosition(currentSide, targetSide, currentPosition);
                targetEditor.getCaretModel().moveToLogicalPosition(position);
            }
            ThreesideTextDiffViewer.this.setCurrentSide(targetSide);
            targetEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            DiffUtil.requestFocus(ThreesideTextDiffViewer.this.getProject(), ThreesideTextDiffViewer.this.getPreferredFocusedComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            ThreeSide side;
            if (editor == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if ((side = ThreesideTextDiffViewer.this.getEditorSide(editor)) == null) {
                return null;
            }
            return ThreesideTextDiffViewer.this.getContent(side).getNavigatable(new LineCol(line));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }

    @ApiStatus.Internal
    protected class TextShowPartialDiffAction
    extends ThreesideDiffViewer.ShowPartialDiffAction {
        public TextShowPartialDiffAction(ThreesideDiffViewer.PartialDiffMode mode, boolean hasFourSides) {
            if (mode == null) {
                TextShowPartialDiffAction.$$$reportNull$$$0(0);
            }
            super(mode, hasFourSides);
        }

        @Override
        @NotNull
        protected SimpleDiffRequest createRequest() {
            SimpleDiffRequest request = super.createRequest();
            ThreeSide currentSide = ThreesideTextDiffViewer.this.getCurrentSide();
            LogicalPosition currentPosition = DiffUtil.getCaretPosition((Editor)ThreesideTextDiffViewer.this.getCurrentEditor());
            if (currentSide == this.mySide1) {
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)currentPosition.line));
            } else if (currentSide == this.mySide2) {
                request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)currentPosition.line));
            } else {
                LogicalPosition position1 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide1, currentPosition);
                LogicalPosition position2 = ThreesideTextDiffViewer.this.transferPosition(currentSide, this.mySide2, currentPosition);
                request.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)new LogicalPosition[]{position1, position2});
            }
            SimpleDiffRequest simpleDiffRequest = request;
            if (simpleDiffRequest == null) {
                TextShowPartialDiffAction.$$$reportNull$$$0(1);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$TextShowPartialDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$TextShowPartialDiffAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.ThreesideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = ThreesideTextDiffViewer.this.getEditors();
            if (list == null) {
                MyInitialScrollPositionHelper.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            ThreesideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.scrollToLine((ThreeSide)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction(ThreesideTextDiffViewer this$0) {
            super(this$0.getTextSettings());
        }
    }
}

