/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.CollapsedDumpParser;
import com.intellij.profiler.FileReader;
import com.intellij.profiler.GZIPExtractor;
import com.intellij.profiler.PlainTextFileReader;
import com.intellij.profiler.ZIPExtractor;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import java.io.File;
import java.util.Map;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0002\u001a\u00020\u0003H$J\b\u0010\u000f\u001a\u00020\u0010H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/CollapsedProfilerDumpFileParserBase;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createCollapsedParser", "Lcom/intellij/profiler/CollapsedDumpParser;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "createStackElementRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "intellij.profiler.common"})
public abstract class CollapsedProfilerDumpFileParserBase
implements ProfilerDumpFileParser {
    @NotNull
    private final Project project;

    public CollapsedProfilerDumpFileParserBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Failure error = ProfilerDumpFileParser.Companion.validate(file);
        if (error != null) {
            return error;
        }
        CollapsedDumpParser<BaseCallStackElement> parser = this.createCollapsedParser(this.project);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"zip", () -> CollapsedProfilerDumpFileParserBase.parse$lambda$0(file)), TuplesKt.to((Object)"gzip", () -> CollapsedProfilerDumpFileParserBase.parse$lambda$1(file)), TuplesKt.to((Object)"gz", () -> CollapsedProfilerDumpFileParserBase.parse$lambda$2(file))};
        Map extractors = MapsKt.mapOf((Pair[])pairArray);
        Object object = (Function0)extractors.get(FilesKt.getExtension((File)file));
        if (object == null || (object = (FileReader)object.invoke()) == null) {
            object = new PlainTextFileReader(file);
        }
        Function0 reader = object;
        reader.readFully(parser, indicator);
        return new Success(new NewCallTreeOnlyProfilerData((CallTreeBuilder<BaseCallStackElement>)parser.getDataBuilder(), this.createStackElementRenderer()));
    }

    @NotNull
    protected abstract CollapsedDumpParser<BaseCallStackElement> createCollapsedParser(@NotNull Project var1);

    @NotNull
    protected abstract BaseCallStackElementRenderer createStackElementRenderer();

    private static final ZIPExtractor parse$lambda$0(File $file) {
        return new ZIPExtractor(new ZipFile($file));
    }

    private static final GZIPExtractor parse$lambda$1(File $file) {
        return new GZIPExtractor($file);
    }

    private static final FileReader parse$lambda$2(File $file) {
        return new GZIPExtractor($file);
    }
}

