/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.CommonProfilerTabNameWithId;
import com.intellij.profiler.ui.ExpandEventContentButton;
import com.intellij.profiler.ui.IdentifiableProfilerTabComponentKt;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.flamegraph.AnchorViewScroller;
import com.intellij.profiler.ui.flamegraph.SmoothScrollPane;
import com.intellij.profiler.ui.flamegraph.ViewScroller;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.HoverHighlighter;
import com.intellij.profiler.ui.timeline.HoverHighlighterKt;
import com.intellij.profiler.ui.timeline.ScrollableMouseAdapter;
import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineColors;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineEventUIContentProvider;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.charts.ChartComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.PlainSelectionTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u00032\u00020\u0004:\nqrstuvwxyzBC\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010Q\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010S\u0018\u00010R2\u0006\u0010T\u001a\u00028\u00002\u0006\u0010U\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010VJ\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u001dJ\b\u0010Z\u001a\u00020XH\u0016J\u0010\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020\u0018H\u0002J\b\u0010_\u001a\u00020XH\u0016J,\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010S0a2\u0006\u0010U\u001a\u00020\u001d2\u0006\u0010b\u001a\u00020\u001d2\b\b\u0002\u0010c\u001a\u00020\u001dJ&\u0010d\u001a\u00020#2\f\u0010e\u001a\b\u0012\u0004\u0012\u00028\u00010S2\u0006\u0010U\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020\u001dH\u0002J\b\u0010f\u001a\u00020\u001dH\u0002J/\u0010g\u001a\u00020X2\u0006\u0010U\u001a\u00020\u001d2\b\u0010T\u001a\u0004\u0018\u00018\u00002\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010SH\u0002\u00a2\u0006\u0002\u0010hJ0\u0010i\u001a\u00020X2\u0006\u0010j\u001a\u00020k2\u0006\u0010U\u001a\u00020\u001d2\u0006\u0010b\u001a\u00020\u001d2\u0006\u0010l\u001a\u00020\u001d2\u0006\u0010m\u001a\u00020\u001dH\u0002J\u0014\u0010n\u001a\u00020X*\u00020o2\u0006\u0010p\u001a\u00020oH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00120\u0012R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001a\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003\u0018\u00010\u001bR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020#8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010(\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020#8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R$\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R+\u00100\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u000702\u00a2\u0006\u0002\b301X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R<\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001082\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010?\u001a\u00020>2\u0006\u0010\u001c\u001a\u00020>8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010D\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020#8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010%\"\u0004\bF\u0010'R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010J\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bK\u0010 \"\u0004\bL\u0010\"R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "T", "F", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "uiContentProvider", "Lcom/intellij/profiler/ui/timeline/TimelineEventUIContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;Lcom/intellij/profiler/ui/timeline/TimelineEventUIContentProvider;Lcom/intellij/openapi/project/Project;)V", "chart", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "getChart", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "tree", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTree;", "treeComponent", "Ljavax/swing/JComponent;", "getTreeComponent", "()Ljavax/swing/JComponent;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "header", "eventContentController", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyEventContentController;", "value", "", "rowHeight", "getRowHeight", "()I", "setRowHeight", "(I)V", "", "isRootVisible", "()Z", "setRootVisible", "(Z)V", "isRootHandlesVisible", "setRootHandlesVisible", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "range", "getRange", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "setRange", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;)V", "stringConverter", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getStringConverter", "()Lkotlin/jvm/functions/Function1;", "setStringConverter", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "timelineRenderer", "getTimelineRenderer", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "setTimelineRenderer", "(Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "", "zoom", "getZoom", "()D", "setZoom", "(D)V", "dragToChangeZoom", "getDragToChangeZoom", "setDragToChangeZoom", "dragPoints", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$DragPoints;", "<set-?>", "headerHeight", "getHeaderHeight", "setHeaderHeight", "headerHeight$delegate", "Lkotlin/properties/ReadWriteProperty;", "updateScaleHelper", "Lcom/intellij/util/ui/UpdateScaleHelper;", "getAnyIntervalAt", "Lkotlin/Pair;", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "node", "x", "(Ljava/lang/Object;I)Lkotlin/Pair;", "expand", "", "levels", "addNotify", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "createToolbar", "doLayout", "getIntervalsAt", "", "y", "margin", "intervalMatches", "interval", "getExpectedHeight", "fixSliderAndUpdateContent", "(ILjava/lang/Object;Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;)V", "paintSelectedArea", "g", "Ljava/awt/Graphics2D;", "width", "height", "synchronize", "Ljavax/swing/JScrollPane;", "that", "MyMouseListener", "MyTooltip", "MyTreeModelAdapter", "MyTreeCellRendererAdapter", "MyTimelineCellRendererAdapter", "MyTreeIterable", "MyChart", "MyTree", "DragPoints", "MyEventContentController", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nTimelinePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelinePanel.kt\ncom/intellij/profiler/ui/timeline/TimelinePanel\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,718:1\n33#2,3:719\n1915#3:722\n1915#3,2:723\n1916#3:725\n296#3,2:726\n777#3:729\n873#3,2:730\n1#4:728\n*S KotlinDebug\n*F\n+ 1 TimelinePanel.kt\ncom/intellij/profiler/ui/timeline/TimelinePanel\n*L\n118#1:719,3\n214#1:722\n215#1:723,2\n214#1:725\n256#1:726,2\n334#1:729\n334#1:730,2\n*E\n"})
public final class TimelinePanel<T, F>
extends BorderLayoutPanel
implements UiDataProvider {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TimelineModel<T, F> model;
    @NotNull
    private final TimelineComponent<T, F> chart;
    @NotNull
    private final MyTree tree;
    @NotNull
    private final ActionToolbar toolbar;
    @NotNull
    private final BorderLayoutPanel header;
    @Nullable
    private final MyEventContentController<T, F, ?> eventContentController;
    @NotNull
    private Function1<? super T, String> stringConverter;
    @Nullable
    private DragPoints dragPoints;
    @NotNull
    private final ReadWriteProperty headerHeight$delegate;
    @NotNull
    private final UpdateScaleHelper updateScaleHelper;

    /*
     * WARNING - void declaration
     */
    public TimelinePanel(@NotNull TimelineModel<T, F> model2, @Nullable TimelineEventUIContentProvider<T, F, ?> uiContentProvider, @Nullable Project project) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        this.model = model2;
        this.chart = new MyChart();
        this.tree = new MyTree();
        this.header = new BorderLayoutPanel();
        this.stringConverter = stringConverter.1.INSTANCE;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = JBUI.getInt((String)"TableHeader.height", (int)25);
        boolean $i$f$observable = false;
        this.headerHeight$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ TimelinePanel this$0;
            {
                this.this$0 = timelinePanel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                ((Number)oldValue).intValue();
                boolean bl = false;
                this.this$0.getChart().setHeaderHeight((int)newValue2);
                TimelinePanel.access$getHeader$p(this.this$0).setPreferredSize(new Dimension(0, (int)newValue2));
                TimelinePanel.access$getHeader$p(this.this$0).revalidate();
            }
        };
        this.updateScaleHelper = new UpdateScaleHelper(false, null, 3, null);
        this.toolbar = this.createToolbar();
        OnePixelSplitter splitter = new OnePixelSplitter(0.2f);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane treeWrapper = jScrollPane;
        treeWrapper.setBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel firstComponentPane = new BorderLayoutPanel();
        this.header.addToTop((Component)this.toolbar.getComponent());
        this.header.setBorder(JBUI.Borders.customLine((Color)NamedColorUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        firstComponentPane.addToTop((Component)this.header);
        firstComponentPane.addToCenter((Component)treeWrapper);
        splitter.setFirstComponent((JComponent)firstComponentPane);
        TimelineComponent<T, F> timelineComponent = this.chart;
        SmoothScrollPane chartWrapper2 = new SmoothScrollPane<TimelineComponent<T, F>>(this, timelineComponent){
            final /* synthetic */ TimelinePanel<T, F> this$0;
            {
                this.this$0 = $receiver;
                super((Component)$super_call_param$1);
            }

            public double getCurrentZoom() {
                return TimelinePanel.access$getZoom(this.this$0);
            }

            public void changeZoom(ViewScroller scroller, Function1<? super Double, Double> eval) {
                Intrinsics.checkNotNullParameter((Object)scroller, (String)"scroller");
                Intrinsics.checkNotNullParameter(eval, (String)"eval");
                scroller.scroll(this.getComponent(), arg_0 -> chartWrapper.1.changeZoom$lambda$0(this.this$0, eval, arg_0));
            }

            private static final Unit changeZoom$lambda$0(TimelinePanel this$0, Function1 $eval, TimelineComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TimelinePanel.access$setZoom(this$0, ((Number)$eval.invoke((Object)TimelinePanel.access$getZoom(this$0))).doubleValue());
                return Unit.INSTANCE;
            }
        };
        chartWrapper2.setBorder((Border)JBUI.Borders.empty());
        splitter.setSecondComponent((JComponent)((Object)chartWrapper2));
        this.synchronize(treeWrapper, (JScrollPane)((Object)chartWrapper2));
        MyEventContentController myEventContentController = this.eventContentController = uiContentProvider != null ? new MyEventContentController(this, uiContentProvider, project) : null;
        if (this.eventContentController != null) {
            OnePixelSplitter outerSplitter = new OnePixelSplitter(0.7f);
            outerSplitter.setFirstComponent((JComponent)splitter);
            outerSplitter.setSecondComponent(this.eventContentController.getExpandedContent());
            this.addToCenter((Component)outerSplitter);
            v2 = this.addToRight(this.eventContentController.getCollapsedContent());
        } else {
            v2 = this.addToCenter((Component)splitter);
        }
        this.tree.putClientProperty(RenderingUtil.FOCUSABLE_SIBLING, this.chart);
        this.chart.putClientProperty(RenderingUtil.FOCUSABLE_SIBLING, (Object)this.tree);
        this.tree.addTreeSelectionListener(arg_0 -> TimelinePanel._init_$lambda$0(this, arg_0));
        this.tree.setCellRenderer(new MyTreeCellRendererAdapter());
        MyMouseListener listener2 = new MyMouseListener();
        this.chart.setCellRenderer(new MyTimelineCellRendererAdapter(new DefaultTimelineCellRenderer()));
        this.chart.setMinimumSize(new Dimension(0, 0));
        this.chart.addMouseListener(listener2);
        this.chart.addMouseMotionListener(listener2);
        this.chart.addMouseWheelListener(listener2);
        this.chart.setBorder(this.tree.getBorder());
        this.chart.setFocusable(true);
        this.chart.addKeyListener(listener2);
        this.chart.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, listener2);
        List list = this.chart.getHeader().getChart().getOverlays();
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ui.charts.ChartComponent>");
        TypeIntrinsics.asMutableList((Object)list).add(new ChartComponent(){

            public void paintComponent(Graphics2D g) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    DragPoints dragPoints = dragPoints;
                    if (dragPoints == null) break block0;
                    DragPoints dragPoints2 = dragPoints;
                    TimelinePanel timelinePanel = this;
                    DragPoints dragPoints3 = dragPoints2;
                    boolean bl = false;
                    Point from = dragPoints3.component1();
                    Point to = dragPoints3.component2();
                    Rectangle visibleRect = timelinePanel.getChart().getVisibleRect();
                    int x = Math.min(from.x, to.x) - visibleRect.x;
                    int width = Math.max(from.x, to.x) - x - visibleRect.x;
                    timelinePanel.paintSelectedArea(g, x, 0, width, timelinePanel.getChart().getHeaderHeight());
                }
            }
        });
        long minTime = 0L;
        minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        HashSet cyclingDetector = new HashSet();
        Object object = JBTreeTraverser.from(arg_0 -> TimelinePanel._init_$lambda$2(arg_0 -> TimelinePanel._init_$lambda$1(cyclingDetector, this, arg_0), arg_0)).withRoot(this.model.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"withRoot(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object node = element$iv = iterator2.next();
            boolean bl = false;
            Iterable<TimelineModel.TimelineInterval<F>> $this$forEach$iv2 = this.model.getIntervals(node);
            boolean $i$f$forEach2 = false;
            Iterator<TimelineModel.TimelineInterval<F>> iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                TimelineModel.TimelineInterval<F> element$iv2;
                TimelineModel.TimelineInterval<F> interval = element$iv2 = iterator3.next();
                boolean bl2 = false;
                if (minTime > interval.getStart()) {
                    minTime = interval.getStart();
                }
                if (maxTime >= interval.getEnd()) continue;
                maxTime = interval.getEnd();
            }
        }
        if (minTime <= maxTime) {
            this.setRange(new TimelineComponent.Range(minTime, maxTime));
        }
        HoverHighlighter hoverHighlighter = new HoverHighlighter();
        HoverHighlighterKt.addHoverHighlighter((JTree)((Object)this.tree), hoverHighlighter);
        HoverHighlighterKt.addHoverHighlighter(this.chart, hoverHighlighter);
        this.chart.getHeader().getChart().getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block6: {
                    Pair nodeAndIntervalToShow;
                    Object object;
                    Pair pair;
                    Object selectedNode;
                    int x;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        x = SwingUtilities.convertPoint((Component)((Component)this.getChart().getHeader().getChart().getComponent()), (Point)e.getPoint(), (Component)((Component)this.getChart())).x;
                        TreePath treePath = tree.getSelectionPath();
                        Object object2 = treePath != null ? treePath.getLastPathComponent() : null;
                        if (object2 == null) {
                            object2 = null;
                        }
                        if ((selectedNode = object2) != null) {
                            pair = this.getAnyIntervalAt(selectedNode, x);
                        } else {
                            JBTreeTraverser jBTreeTraverser = TreeUtil.treeTraverser((JTree)((JTree)((Object)tree)));
                            Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"treeTraverser(...)");
                            Iterable iterable = (Iterable)jBTreeTraverser;
                            TimelinePanel timelinePanel = this;
                            for (Object node : iterable) {
                                boolean bl = false;
                                Pair pair2 = timelinePanel.getAnyIntervalAt(node, x);
                                if (pair2 == null) continue;
                                pair = pair2;
                                break block5;
                            }
                            pair = null;
                        }
                    }
                    if ((object = (nodeAndIntervalToShow = pair)) == null || (object = object.getFirst()) == null) {
                        object = selectedNode;
                    }
                    Pair pair3 = nodeAndIntervalToShow;
                    this.fixSliderAndUpdateContent(x, object, pair3 != null ? (TimelineModel.TimelineInterval)pair3.getSecond() : null);
                    JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)this.getChart());
                    if (jScrollPane == null) break block6;
                    jScrollPane.repaint();
                }
            }
        });
        TreeSpeedSearch.installOn((JTree)((JTree)((Object)this.tree)), (boolean)false, arg_0 -> TimelinePanel._init_$lambda$5(arg_0 -> TimelinePanel._init_$lambda$4(this, arg_0), arg_0));
    }

    public /* synthetic */ TimelinePanel(TimelineModel timelineModel, TimelineEventUIContentProvider timelineEventUIContentProvider, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timelineEventUIContentProvider = null;
        }
        if ((n & 4) != 0) {
            project = null;
        }
        this(timelineModel, timelineEventUIContentProvider, project);
    }

    @NotNull
    public final TimelineComponent<T, F> getChart() {
        return this.chart;
    }

    @NotNull
    public final JComponent getTreeComponent() {
        return (JComponent)((Object)this.tree);
    }

    public final int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public final void setRowHeight(int value) {
        this.tree.setRowHeight(value);
    }

    public final boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public final void setRootVisible(boolean value) {
        this.tree.setRootVisible(value);
    }

    public final boolean isRootHandlesVisible() {
        return this.tree.isRootHandlesVisible();
    }

    public final void setRootHandlesVisible(boolean value) {
        this.tree.setRootHandlesVisible(value);
    }

    @NotNull
    public final TimelineComponent.Range getRange() {
        return this.chart.getRange();
    }

    public final void setRange(@NotNull TimelineComponent.Range value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.chart.setRange(value);
    }

    @NotNull
    public final Function1<T, String> getStringConverter() {
        return this.stringConverter;
    }

    public final void setStringConverter(@NotNull Function1<? super T, String> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.stringConverter = function1;
    }

    @NotNull
    public final TimelineCellRenderer<T, F> getTimelineRenderer() {
        TimelineCellRenderer<T, F> timelineCellRenderer2 = this.chart.getCellRenderer();
        Intrinsics.checkNotNull(timelineCellRenderer2, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.timeline.TimelinePanel.MyTimelineCellRendererAdapter<T of com.intellij.profiler.ui.timeline.TimelinePanel, F of com.intellij.profiler.ui.timeline.TimelinePanel>");
        return ((MyTimelineCellRendererAdapter)timelineCellRenderer2).getDelegate();
    }

    public final void setTimelineRenderer(@NotNull TimelineCellRenderer<T, F> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.chart.setCellRenderer(new MyTimelineCellRendererAdapter(value));
    }

    private final double getZoom() {
        return (double)this.chart.getWidth() / (double)this.chart.getVisibleRect().width;
    }

    private final void setZoom(double value) {
        this.chart.setPreferredSize(new Dimension(MathKt.roundToInt((double)((double)this.chart.getVisibleRect().width * value)), this.tree.getHeight()));
        this.chart.setSize(this.chart.getPreferredSize());
        this.chart.repaint();
    }

    private final boolean getDragToChangeZoom() {
        return ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().getDragToChangeZoom();
    }

    private final void setDragToChangeZoom(boolean value) {
        ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTimelineState().setDragToChangeZoom(value);
    }

    private final int getHeaderHeight() {
        return ((Number)this.headerHeight$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setHeaderHeight(int n) {
        this.headerHeight$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    private final Pair<T, TimelineModel.TimelineInterval<F>> getAnyIntervalAt(T node, int x) {
        Pair pair;
        TimelineModel.TimelineInterval<F> timelineInterval;
        block3: {
            Iterable<TimelineModel.TimelineInterval<F>> $this$firstOrNull$iv = this.model.getIntervals(node);
            boolean $i$f$firstOrNull = false;
            Iterator<TimelineModel.TimelineInterval<F>> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                TimelineModel.TimelineInterval<F> element$iv;
                TimelineModel.TimelineInterval<F> ti = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.intervalMatches(ti, x, 0)) continue;
                timelineInterval = element$iv;
                break block3;
            }
            timelineInterval = null;
        }
        TimelineModel.TimelineInterval timelineInterval2 = timelineInterval;
        if (timelineInterval2 != null) {
            TimelineModel.TimelineInterval it = timelineInterval2;
            boolean bl = false;
            pair = TuplesKt.to(node, (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    public final void expand(int levels) {
        if (levels < 0) {
            TreeUtil.expandAll((JTree)((JTree)((Object)this.tree)));
        } else {
            TreeUtil.expand((JTree)((JTree)((Object)this.tree)), (int)levels);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.revalidate();
        this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)((Object)this.chart.getHeader()));
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(IdentifiableProfilerTabComponentKt.getSELECTED_TAB_COMPONENT_ID(), (Object)CommonProfilerTabNameWithId.TIMELINE);
    }

    private final ActionToolbar createToolbar() {
        ActionToolbar actionToolbar;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$createToolbar_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        String string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.zoomIn", new Object[0]);
        Icon icon = AllIcons.Graph.ZoomIn;
        $this$createToolbar_u24lambda_u240.add((AnAction)new DumbAwareAction(this, string, icon){
            final /* synthetic */ TimelinePanel<T, F> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "", $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_ZOOM_IN, e, null, 4, null);
                AnchorViewScroller scroller = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)createToolbar.group.1.1::actionPerformed$lambda$0));
                scroller.scroll((Component)this.this$0.getChart(), arg_0 -> createToolbar.group.1.1.actionPerformed$lambda$1(this.this$0, arg_0));
            }

            private static final Point actionPerformed$lambda$0(Rectangle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Point point = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return point;
            }

            private static final Unit actionPerformed$lambda$1(TimelinePanel this$0, TimelineComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TimelinePanel.access$setZoom(this$0, TimelinePanel.access$getZoom(this$0) * 1.2);
                return Unit.INSTANCE;
            }
        });
        string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.zoomOut", new Object[0]);
        icon = AllIcons.Graph.ZoomOut;
        $this$createToolbar_u24lambda_u240.add((AnAction)new DumbAwareAction(this, string, icon){
            final /* synthetic */ TimelinePanel<T, F> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "", $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_ZOOM_OUT, e, null, 4, null);
                AnchorViewScroller scroller = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)createToolbar.group.1.2::actionPerformed$lambda$0));
                scroller.scroll((Component)this.this$0.getChart(), arg_0 -> createToolbar.group.1.2.actionPerformed$lambda$1(this.this$0, arg_0));
            }

            private static final Point actionPerformed$lambda$0(Rectangle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Point point = it.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                return point;
            }

            private static final Unit actionPerformed$lambda$1(TimelinePanel this$0, TimelineComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TimelinePanel.access$setZoom(this$0, TimelinePanel.access$getZoom(this$0) / 1.2);
                return Unit.INSTANCE;
            }
        });
        string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.resetZoom", new Object[0]);
        icon = AllIcons.Graph.ActualZoom;
        $this$createToolbar_u24lambda_u240.add((AnAction)new DumbAwareAction(this, string, icon){
            final /* synthetic */ TimelinePanel<T, F> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "", $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_ZOOM_RESET, e, null, 4, null);
                TimelinePanel.access$setZoom(this.this$0, 1.0);
            }
        });
        string = CommonProfilerBundleKt.profilerMessage("checkbox.timeline.dragToZoomIn", new Object[0]);
        icon = AllIcons.Graph.SnapToGrid;
        $this$createToolbar_u24lambda_u240.add((AnAction)new DumbAwareToggleAction(this, string, icon){
            final /* synthetic */ TimelinePanel<T, F> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "", $super_call_param$2);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return TimelinePanel.access$getDragToChangeZoom(this.this$0);
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.INSTANCE.logSnapshotInteraction(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_ZOOM_BY_SELECTION, e, state);
                TimelinePanel.access$setDragToChangeZoom(this.this$0, state);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        });
        DefaultActionGroup group2 = defaultActionGroup;
        ActionToolbar it = actionToolbar = ActionManager.getInstance().createActionToolbar("TimelineChart", (ActionGroup)group2, true);
        boolean bl2 = false;
        it.setTargetComponent((JComponent)((Object)this));
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"also(...)");
        return actionToolbar2;
    }

    public void doLayout() {
        super.doLayout();
        int expectedHeight = this.getExpectedHeight();
        if (this.getHeaderHeight() != expectedHeight) {
            this.setHeaderHeight(expectedHeight);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TimelineModel.TimelineInterval<F>> getIntervalsAt(int x, int y, int margin) {
        void $this$filterTo$iv$iv;
        TreePath treePath = this.tree.getClosestPathForLocation(0, y);
        if (treePath == null) {
            return CollectionsKt.emptyList();
        }
        TreePath path = treePath;
        Rectangle bounds = this.tree.getPathBounds(path);
        if (bounds != null && (bounds.y > y || bounds.y + bounds.height < y)) {
            return CollectionsKt.emptyList();
        }
        Object object = path.getLastPathComponent();
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object node = object;
        Iterable<TimelineModel.TimelineInterval<F>> $this$filter$iv = this.model.getIntervals(node);
        boolean $i$f$filter = false;
        Iterable<TimelineModel.TimelineInterval<F>> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TimelineModel.TimelineInterval ti = (TimelineModel.TimelineInterval)element$iv$iv;
            boolean bl = false;
            if (!this.intervalMatches(ti, x, margin)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getIntervalsAt$default(TimelinePanel timelinePanel, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return timelinePanel.getIntervalsAt(n, n2, n3);
    }

    private final boolean intervalMatches(TimelineModel.TimelineInterval<F> interval, int x, int margin) {
        return this.chart.toScreenCoordinate(interval.getStart()) <= x + margin && x - margin <= this.chart.toScreenCoordinate(interval.getEnd());
    }

    private final int getExpectedHeight() {
        int multiplier = this.chart.getHeader().isDatasetVisible() ? 3 : 1;
        return multiplier * this.toolbar.getComponent().getHeight() + 1;
    }

    private final void fixSliderAndUpdateContent(int x, T node, TimelineModel.TimelineInterval<F> interval) {
        block0: {
            long time = interval == null || interval.getStart() != interval.getEnd() ? this.chart.toWorldCoordinate(x) : (interval.getStart() + interval.getEnd()) / (long)2;
            this.chart.setFixedSliderTime(time);
            MyEventContentController<T, F, ?> myEventContentController = this.eventContentController;
            if (myEventContentController == null) break block0;
            myEventContentController.updateContent(interval, time - this.getRange().getStart(), node);
        }
    }

    private final void paintSelectedArea(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(ColorUtil.withAlpha((Color)UIUtil.getTreeBackground((boolean)true, (this.tree.hasFocus() || this.chart.hasFocus() ? 1 : 0) != 0), (double)0.5));
        g.fillRect(x, y, width, height);
    }

    private final void synchronize(JScrollPane $this$synchronize, JScrollPane that) {
        $this$synchronize.setHorizontalScrollBarPolicy(32);
        that.setHorizontalScrollBarPolicy(32);
        that.setVerticalScrollBar($this$synchronize.getVerticalScrollBar());
    }

    private static final Object lambda$1$0$0(TimelinePanel this$0, Object $parent, int it) {
        return this$0.model.getChild($parent, it);
    }

    private static final Iterator lambda$1$0(TimelinePanel this$0, Object $parent) {
        return IntStream.range(0, this$0.model.getChildCount($parent)).mapToObj(arg_0 -> TimelinePanel.lambda$1$0$0(this$0, $parent, arg_0)).iterator();
    }

    private static final void _init_$lambda$0(TimelinePanel this$0, TreeSelectionEvent it) {
        block3: {
            TimelineModel.TimelineInterval timelineInterval;
            Object object;
            this$0.chart.repaint();
            Serializable serializable = it;
            if ((serializable != null && (serializable = ((TreeSelectionEvent)serializable).getPath()) != null ? ((TreePath)serializable).getLastPathComponent() : (object = null)) == null) {
                object = null;
            }
            Object selectedNode = object;
            long currentTime = this$0.chart.getFixedSliderTime();
            if (selectedNode == null || currentTime < 0L) {
                timelineInterval = null;
            } else {
                Pair pair = this$0.getAnyIntervalAt(selectedNode, this$0.chart.toScreenCoordinate(currentTime));
                timelineInterval = pair != null ? (TimelineModel.TimelineInterval)pair.getSecond() : null;
            }
            TimelineModel.TimelineInterval interval = timelineInterval;
            MyEventContentController myEventContentController = this$0.eventContentController;
            if (myEventContentController == null) break block3;
            myEventContentController.updateContent(interval, currentTime - this$0.getRange().getStart(), selectedNode);
        }
    }

    private static final Iterable _init_$lambda$1(HashSet $cyclingDetector, TimelinePanel this$0, Object parent) {
        return $cyclingDetector.add(parent) ? (Iterable)JBIterable.create(() -> TimelinePanel.lambda$1$0(this$0, parent)) : (Iterable)JBIterable.empty();
    }

    private static final Iterable _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final String _init_$lambda$4(TimelinePanel this$0, TreePath path) {
        return (String)this$0.stringConverter.invoke(path.getLastPathComponent());
    }

    private static final String _init_$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BorderLayoutPanel access$getHeader$p(TimelinePanel $this) {
        return $this.header;
    }

    public static final /* synthetic */ void access$setDragToChangeZoom(TimelinePanel $this, boolean value) {
        $this.setDragToChangeZoom(value);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelinePanel.class, "headerHeight", "getHeaderHeight()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\t\u0010\f\u001a\u00020\u0003H\u0086\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$DragPoints;", "", "startPont", "Ljava/awt/Point;", "<init>", "(Ljava/awt/Point;)V", "from", "getFrom", "()Ljava/awt/Point;", "to", "getTo", "component1", "component2", "intellij.profiler.common"})
    private static final class DragPoints {
        @NotNull
        private final Point from;
        @NotNull
        private final Point to;

        public DragPoints(@NotNull Point startPont) {
            Intrinsics.checkNotNullParameter((Object)startPont, (String)"startPont");
            this.from = new Point();
            this.to = new Point();
            this.from.x = startPont.x;
            this.from.y = startPont.y;
            this.to.x = startPont.x;
            this.to.y = startPont.y;
        }

        @NotNull
        public final Point getFrom() {
            return this.from;
        }

        @NotNull
        public final Point getTo() {
            return this.to;
        }

        @NotNull
        public final Point component1() {
            return this.from;
        }

        @NotNull
        public final Point component2() {
            return this.to;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyChart;", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "getInsets", "Ljava/awt/Insets;", "value", "", "rowHeight", "getRowHeight", "()I", "setRowHeight", "(I)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.profiler.common"})
    private final class MyChart
    extends TimelineComponent<T, F> {
        public MyChart() {
            super(TimelinePanel.this.model, new MyTreeIterable());
        }

        @Override
        @NotNull
        public Insets getInsets() {
            Insets insets = TimelinePanel.this.tree.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            return insets;
        }

        @Override
        public int getRowHeight() {
            return TimelinePanel.this.tree.getRowHeight();
        }

        @Override
        public void setRowHeight(int value) {
            TimelinePanel.this.tree.setRowHeight(value);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            DragPoints dragPoints = TimelinePanel.this.dragPoints;
            if (dragPoints != null) {
                DragPoints dragPoints2 = dragPoints;
                TimelinePanel timelinePanel = TimelinePanel.this;
                DragPoints dragPoints3 = dragPoints2;
                boolean bl = false;
                Point from = dragPoints3.component1();
                Point to = dragPoints3.component2();
                int x = Math.min(from.x, to.x);
                int width = Math.max(from.x, to.x) - x;
                timelinePanel.paintSelectedArea(g2d, x, timelinePanel.getChart().getVisibleRect().y, width, timelinePanel.getChart().getVisibleRect().height);
            }
            g2d.dispose();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u0002*\u0004\b\u0004\u0010\u00032\u00020\u0004:\u0001!B-\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00018\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyEventContentController;", "T", "F", "C", "", "uiContentProvider", "Lcom/intellij/profiler/ui/timeline/TimelineEventUIContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Lcom/intellij/profiler/ui/timeline/TimelineEventUIContentProvider;Lcom/intellij/openapi/project/Project;)V", "content", "Ljava/lang/Object;", "expandButton", "Ljavax/swing/JComponent;", "collapsedContent", "getCollapsedContent", "()Ljavax/swing/JComponent;", "expandedContent", "getExpandedContent", "headerLabel", "Lcom/intellij/ui/components/JBLabel;", "updateContent", "", "event", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "timePassedSinceStartMs", "", "treeComponent", "(Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;JLjava/lang/Object;)V", "toggleExpand", "expand", "", "MyCollapseAction", "intellij.profiler.common"})
    private final class MyEventContentController<T, F, C> {
        @NotNull
        private final TimelineEventUIContentProvider<T, F, C> uiContentProvider;
        @Nullable
        private final Project project;
        private final C content;
        @NotNull
        private final JComponent expandButton;
        @NotNull
        private final JComponent collapsedContent;
        @NotNull
        private final JComponent expandedContent;
        @NotNull
        private final JBLabel headerLabel;
        final /* synthetic */ TimelinePanel<T, F> this$0;

        /*
         * WARNING - void declaration
         */
        public MyEventContentController(@NotNull TimelinePanel this$0, @Nullable TimelineEventUIContentProvider<T, F, C> uiContentProvider, Project project) {
            void $this$lambda_u241_u240;
            JBLabel jBLabel;
            void $this$_init__u24lambda_u241;
            ExpandEventContentButton $this$_init__u24lambda_u240;
            ExpandEventContentButton expandEventContentButton;
            Intrinsics.checkNotNullParameter(uiContentProvider, (String)"uiContentProvider");
            this.this$0 = this$0;
            this.uiContentProvider = uiContentProvider;
            this.project = project;
            this.content = this.uiContentProvider.createUIContent();
            String string = this.uiContentProvider.getExpandableButtonText();
            Icon icon = AllIcons.General.ChevronLeft;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ChevronLeft");
            ExpandEventContentButton expandEventContentButton2 = expandEventContentButton = new ExpandEventContentButton(string, icon);
            MyEventContentController myEventContentController = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setBorder((Border)new SideBorder(JBColor.border(), 1));
            myEventContentController.expandButton = expandEventContentButton;
            $this$_init__u24lambda_u240 = expandEventContentButton = new BorderLayoutPanel();
            myEventContentController = this;
            boolean bl2 = false;
            $this$_init__u24lambda_u241.setVisible(false);
            $this$_init__u24lambda_u241.addToCenter((Component)this.uiContentProvider.getPanel(this.content));
            Object object = jBLabel = new JBLabel(this.uiContentProvider.getExpandableButtonText(), UIUtil.ComponentStyle.SMALL);
            MyEventContentController myEventContentController2 = this;
            boolean bl3 = false;
            $this$lambda_u241_u240.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.scale((int)10)));
            myEventContentController2.headerLabel = jBLabel;
            JBLabel $this$lambda_u241_u241 = object = new BorderLayoutPanel();
            boolean bl4 = false;
            $this$lambda_u241_u241.addToCenter((Component)this.headerLabel);
            MyCollapseAction collapseAction = new MyCollapseAction();
            AnAction[] anActionArray = new AnAction[]{collapseAction};
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TimelineEventContentPanel", (ActionGroup)new DefaultActionGroup(anActionArray), true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)$this$_init__u24lambda_u241);
            toolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
            $this$lambda_u241_u241.addToRight((Component)toolbar.getComponent());
            $this$lambda_u241_u241.setBorder((Border)new SideBorder(JBColor.border(), 8));
            $this$lambda_u241_u241.setMinimumSize(new Dimension(toolbar.getComponent().getPreferredSize().width, $this$lambda_u241_u241.getMinimumSize().height));
            JBLabel header = object;
            $this$_init__u24lambda_u241.addToTop((Component)header);
            object = this.expandButton;
            this.collapsedContent = (JComponent)new Wrapper((BorderLayoutPanel)header, (JComponent)object){
                final /* synthetic */ BorderLayoutPanel $header;
                {
                    this.$header = $header;
                    super($super_call_param$1);
                }

                public Dimension getPreferredSize() {
                    int height = super.getPreferredSize().height;
                    return new Dimension(this.$header.getPreferredSize().height, height);
                }
            };
            myEventContentController.expandedContent = expandEventContentButton;
            this.expandButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.toggleExpand(true);
                    this.getExpandedContent().requestFocus();
                }
            });
        }

        public /* synthetic */ MyEventContentController(TimelinePanel timelinePanel, TimelineEventUIContentProvider timelineEventUIContentProvider, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                project = null;
            }
            this(timelinePanel, timelineEventUIContentProvider, project);
        }

        @NotNull
        public final JComponent getCollapsedContent() {
            return this.collapsedContent;
        }

        @NotNull
        public final JComponent getExpandedContent() {
            return this.expandedContent;
        }

        public final void updateContent(@Nullable TimelineModel.TimelineInterval<F> event, long timePassedSinceStartMs, @Nullable T treeComponent) {
            ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_GET_CONTENTS, CommonProfilerTabNameWithId.TIMELINE, null, 8, null);
            this.toggleExpand(true);
            this.headerLabel.setText(this.uiContentProvider.getHeaderText(treeComponent, event, timePassedSinceStartMs));
            TimelineModel.TimelineInterval<F> timelineInterval = event;
            this.uiContentProvider.updateComponent(timelineInterval != null ? timelineInterval.getContent() : null, this.content);
        }

        private final void toggleExpand(boolean expand) {
            ProfilerUsageTriggerCollector.INSTANCE.logSnapshotInteraction(this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.TL_OPEN_CONTENTS_PANEL, CommonProfilerTabNameWithId.TIMELINE, expand);
            this.collapsedContent.setVisible(!expand);
            this.expandedContent.setVisible(expand);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyEventContentController$MyCollapseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyEventContentController;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.profiler.common"})
        private final class MyCollapseAction
        extends DumbAwareAction
        implements RightAlignedToolbarAction {
            public MyCollapseAction() {
                this.getTemplatePresentation().setText(MyEventContentController.this.uiContentProvider.getCollapseButtonTooltipText());
                this.getTemplatePresentation().setIcon(AllIcons.General.ChevronRight);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MyEventContentController.this.toggleExpand(false);
                MyEventContentController.this.this$0.getChart().requestFocus();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\b\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J,\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010&2\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010&0(2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u0014\u0018\u00010\bR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyMouseListener;", "Lcom/intellij/profiler/ui/timeline/ScrollableMouseAdapter;", "Ljava/awt/event/KeyListener;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "popupComponent", "Lcom/intellij/ui/components/JBLabel;", "lastTooltipShown", "Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "getLastTooltipShown", "()Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "setLastTooltipShown", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;)V", "mousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseReleased", "mouseClicked", "e", "convertMouseEvent", "withId", "", "magnify", "Ljava/awt/Point;", "scale", "", "at", "keyTyped", "Ljava/awt/event/KeyEvent;", "keyPressed", "keyReleased", "clearDragSelection", "mouseMoved", "mouseExited", "findNearestInterval", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "list", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nTimelinePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelinePanel.kt\ncom/intellij/profiler/ui/timeline/TimelinePanel$MyMouseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,718:1\n1#2:719\n*E\n"})
    private final class MyMouseListener
    extends ScrollableMouseAdapter
    implements KeyListener {
        @NotNull
        private final JBLabel popupComponent = new JBLabel();
        @Nullable
        private MyTooltip lastTooltipShown;

        @Nullable
        public final MyTooltip getLastTooltipShown() {
            return this.lastTooltipShown;
        }

        public final void setLastTooltipShown(@Nullable MyTooltip myTooltip) {
            this.lastTooltipShown = myTooltip;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TimelinePanel.this.getChart().requestFocus(true);
            if (event.getButton() == 1 && (ProfilerUIUtilsKt.isZoomKeyDown(event) || TimelinePanel.this.getDragToChangeZoom())) {
                Point point = event.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                TimelinePanel.this.dragPoints = new DragPoints(point);
            } else {
                super.mousePressed(event);
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (TimelinePanel.this.dragPoints != null) {
                Object object;
                Rectangle visibleRect = TimelinePanel.this.getChart().getVisibleRect();
                Object object2 = TimelinePanel.this.dragPoints;
                if (object2 != null && (object2 = ((DragPoints)object2).getTo()) != null) {
                    ((Point)object2).x = Math.min(Math.max(event.getX(), visibleRect.x), visibleRect.x + visibleRect.width);
                }
                if ((object = TimelinePanel.this.dragPoints) != null && (object = ((DragPoints)object).getTo()) != null) {
                    ((Point)object).y = event.getY();
                }
                TimelinePanel.this.repaint();
            } else {
                super.mouseDragged(event);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DragPoints dragPoints = TimelinePanel.this.dragPoints;
            if (dragPoints != null) {
                TimelinePanel.this.dragPoints = null;
                Rectangle visibleRect = TimelinePanel.this.getChart().getVisibleRect();
                int sourceWidth = TimelinePanel.this.getChart().getWidth();
                int targetWidth = Math.abs(dragPoints.getFrom().x - dragPoints.getTo().x);
                if (targetWidth < 10) {
                    TimelinePanel.this.repaint();
                    return;
                }
                double targetZoom = (double)sourceWidth / (double)targetWidth;
                long time = TimelinePanel.this.getChart().toWorldCoordinate(Math.min(dragPoints.getFrom().x, dragPoints.getTo().x));
                TimelinePanel.this.setZoom(targetZoom);
                visibleRect.x = TimelinePanel.this.getChart().toScreenCoordinate(time);
                TimelinePanel.this.getChart().scrollRectToVisible(visibleRect);
            } else {
                super.mouseReleased(event);
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreePath location = TimelinePanel.this.tree.getClosestPathForLocation(0, e.getY());
            TimelineModel.TimelineInterval interval = this.findNearestInterval(TimelinePanel.this.getIntervalsAt(e.getX(), e.getY(), TimelinePanel.this.getChart().getPinSliderRadiusPx()), e);
            TimelinePanel.this.fixSliderAndUpdateContent(e.getX(), location.getLastPathComponent(), interval);
        }

        private final MouseEvent convertMouseEvent(MouseEvent e, int withId) {
            Point p = e.getPoint();
            SwingUtilities.convertPoint(e.getComponent(), p, (Component)((Object)TimelinePanel.this.tree));
            return new MouseEvent((Component)((Object)TimelinePanel.this.tree), withId, e.getWhen(), e.getModifiers(), p.x, p.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        static /* synthetic */ MouseEvent convertMouseEvent$default(MyMouseListener myMouseListener, MouseEvent mouseEvent, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = mouseEvent.getID();
            }
            return myMouseListener.convertMouseEvent(mouseEvent, n);
        }

        @Override
        @NotNull
        public Point magnify(double scale, @NotNull Point at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            AnchorViewScroller scroller = new AnchorViewScroller((Function1<? super Rectangle, ? extends Point>)((Function1)arg_0 -> MyMouseListener.magnify$lambda$0(at, arg_0)));
            scroller.scroll((Component)TimelinePanel.this.getChart(), arg_0 -> MyMouseListener.magnify$lambda$1(TimelinePanel.this, scale, arg_0));
            return new Point(MathKt.roundToInt((double)((double)at.x * scale)), at.y);
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (TimelinePanel.this.dragPoints != null && e.getKeyCode() == 27) {
                this.clearDragSelection();
                e.consume();
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getKeyCode() == 17) {
                this.clearDragSelection();
            }
        }

        private final void clearDragSelection() {
            TimelinePanel.this.dragPoints = null;
            TimelinePanel.this.repaint();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List list = TimelinePanel.getIntervalsAt$default(TimelinePanel.this, e.getX(), e.getY(), 0, 4, null);
            TimelineModel.TimelineInterval element = this.findNearestInterval(list, e);
            if (element != null) {
                this.popupComponent.setText(TimelinePanel.this.getTimelineRenderer().getTooltipText(element));
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                this.lastTooltipShown = new MyTooltip(point, (JComponent)this.popupComponent);
                IdeTooltipManager ideTooltipManager = IdeTooltipManager.Companion.getInstance();
                MyTooltip myTooltip = this.lastTooltipShown;
                Intrinsics.checkNotNull((Object)((Object)myTooltip));
                ideTooltipManager.show((IdeTooltip)myTooltip, false, false);
            } else {
                IdeTooltipManager.Companion.getInstance().hide((IdeTooltip)this.lastTooltipShown);
                this.lastTooltipShown = null;
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MyTooltip myTooltip = this.lastTooltipShown;
            if (myTooltip != null) {
                MyTooltip myTooltip2 = myTooltip;
                IdeTooltipManager ideTooltipManager = IdeTooltipManager.Companion.getInstance();
                IdeTooltip p0 = myTooltip2;
                boolean bl = false;
                ideTooltipManager.hide(p0);
            }
            this.lastTooltipShown = null;
        }

        private final TimelineModel.TimelineInterval<F> findNearestInterval(List<? extends TimelineModel.TimelineInterval<F>> list, MouseEvent e) {
            TimelineModel.TimelineInterval timelineInterval;
            if (list.size() > 1) {
                long mouse = TimelinePanel.this.getChart().toWorldCoordinate(e.getX());
                Iterable iterable = list;
                Comparator<Object> comparator = Comparator.comparingLong(arg_0 -> MyMouseListener.findNearestInterval$lambda$1(arg_0 -> MyMouseListener.findNearestInterval$lambda$0(mouse, arg_0), arg_0)).thenComparingLong(arg_0 -> MyMouseListener.findNearestInterval$lambda$3(MyMouseListener::findNearestInterval$lambda$2, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparingLong(...)");
                timelineInterval = (TimelineModel.TimelineInterval)CollectionsKt.minWithOrNull((Iterable)iterable, comparator);
            } else {
                timelineInterval = (TimelineModel.TimelineInterval)CollectionsKt.firstOrNull(list);
            }
            TimelineModel.TimelineInterval element = timelineInterval;
            return element;
        }

        private static final Point magnify$lambda$0(Point $at, Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $at;
        }

        private static final Unit magnify$lambda$1(TimelinePanel this$0, double $scale, TimelineComponent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.setZoom(this$0.getZoom() * $scale);
            return Unit.INSTANCE;
        }

        private static final long findNearestInterval$lambda$0(long $mouse, TimelineModel.TimelineInterval it) {
            long mid = (it.getStart() + it.getEnd()) / (long)2;
            return Math.abs(mid - $mouse);
        }

        private static final long findNearestInterval$lambda$1(Function1 $tmp0, Object p0) {
            return ((Number)$tmp0.invoke(p0)).longValue();
        }

        private static final long findNearestInterval$lambda$2(TimelineModel.TimelineInterval it) {
            return Math.abs(it.getEnd() - it.getStart());
        }

        private static final long findNearestInterval$lambda$3(Function1 $tmp0, Object p0) {
            return ((Number)$tmp0.invoke(p0)).longValue();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J8\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0097\u0001J1\u0010\u001a\u001a\u00020\u001b2\u0010\u0010\u0011\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTimelineCellRendererAdapter;", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "delegate", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "getDelegate", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "isSelected", "", "row", "", "getSelectionBackground", "Ljava/awt/Color;", "isHovered", "getHoverBackground", "getNodeRendererComponent", "Ljava/awt/Component;", "panel", "Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "value", "hasFocus", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/lang/Object;ZZ)Ljava/awt/Component;", "getTooltipText", "", "node", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "paint", "", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.common"})
    private final class MyTimelineCellRendererAdapter
    implements TimelineCellRenderer<T, F> {
        @NotNull
        private final TimelineCellRenderer<T, F> delegate;

        public MyTimelineCellRendererAdapter(TimelineCellRenderer<T, F> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final TimelineCellRenderer<T, F> getDelegate() {
            return this.delegate;
        }

        @Override
        public boolean isSelected(int row) {
            return TimelinePanel.this.tree.isRowSelected(row);
        }

        @Override
        @NotNull
        public Color getSelectionBackground() {
            Color color = UIUtil.getTreeBackground((boolean)true, (TimelinePanel.this.tree.hasFocus() || TimelinePanel.this.getChart().hasFocus() ? 1 : 0) != 0);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTreeBackground(...)");
            return color;
        }

        @Override
        public boolean isHovered(int row) {
            return row == TreeHoverListener.getHoveredRow((JTree)((JTree)((Object)TimelinePanel.this.tree)));
        }

        @Override
        @NotNull
        public Color getHoverBackground() {
            Color color = RenderingUtil.getHoverBackground((JTree)((JTree)((Object)TimelinePanel.this.tree)));
            if (color == null) {
                color = TimelineColors.Timeline.INSTANCE.getHoverEventsBackground();
            }
            return color;
        }

        @Override
        @NotNull
        public Component getNodeRendererComponent(@NotNull TimelinePanel<T, ?> panel2, T value, boolean isSelected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            return this.delegate.getNodeRendererComponent(panel2, value, isSelected, hasFocus);
        }

        @Override
        public void paint(@NotNull TimelineComponent<?, F> panel2, @NotNull Graphics2D g, @NotNull TimelineModel.TimelineInterval<F> node) {
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.delegate.paint(panel2, g, node);
        }

        @Override
        @NlsSafe
        @NotNull
        public String getTooltipText(@NotNull TimelineModel.TimelineInterval<F> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            return this.delegate.getTooltipText(node);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTooltip;", "Lcom/intellij/ide/IdeTooltip;", "point", "Ljava/awt/Point;", "tipComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/awt/Point;Ljavax/swing/JComponent;)V", "getShowDelay", "", "getDismissDelay", "intellij.profiler.common"})
    private final class MyTooltip
    extends IdeTooltip {
        public MyTooltip(@NotNull Point point, JComponent tipComponent) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)tipComponent, (String)"tipComponent");
            super((Component)TimelinePanel.this.getChart(), point, tipComponent, new Object[0]);
        }

        public int getShowDelay() {
            return 500;
        }

        public int getDismissDelay() {
            return Integer.MAX_VALUE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTree;", "Lcom/intellij/ui/treeStructure/Tree;", "Lcom/intellij/ui/tree/ui/PlainSelectionTree;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "value", "", "isRootHandlesVisible", "()Z", "setRootHandlesVisible", "(Z)V", "treeDidChange", "", "repaint", "tm", "", "x", "", "y", "width", "height", "intellij.profiler.common"})
    private final class MyTree
    extends Tree
    implements PlainSelectionTree {
        public MyTree() {
            super((TreeModel)new MyTreeModelAdapter(TimelinePanel.this.model));
            int defaultRowHeight = UIManager.getInt(JBUI.CurrentTheme.Tree.rowHeightKey());
            this.rowHeight = defaultRowHeight < 1 ? JBUIScale.scale((int)20) : defaultRowHeight;
            this.setBackground(ProfilerUIUtilsKt.BACKGROUND);
        }

        public final boolean isRootHandlesVisible() {
            return this.showsRootHandles;
        }

        public final void setRootHandlesVisible(boolean value) {
            this.showsRootHandles = value;
        }

        public void treeDidChange() {
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)TimelinePanel.this.getChart());
            if (jScrollPane != null) {
                JScrollPane jScrollPane2 = jScrollPane;
                TimelinePanel timelinePanel = TimelinePanel.this;
                JScrollPane it = jScrollPane2;
                boolean bl = false;
                Rectangle bounds = timelinePanel.getChart().getBounds();
                timelinePanel.getChart().setPreferredSize(new Dimension(timelinePanel.getChart().getPreferredSize().width, this.getPreferredSize().height));
                timelinePanel.getChart().setBounds(new Rectangle(bounds.x, bounds.y, timelinePanel.getChart().getPreferredSize().width, timelinePanel.getChart().getPreferredSize().height));
                timelinePanel.getChart().revalidate();
                timelinePanel.getChart().repaint();
            }
            super.treeDidChange();
        }

        public void repaint(long tm, int x, int y, int width, int height) {
            TimelinePanel.this.repaint(tm, 0, y, TimelinePanel.this.getWidth(), height);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeCellRendererAdapter;", "Ljavax/swing/tree/TreeCellRenderer;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "renderException", "Lcom/intellij/ui/components/JBLabel;", "getRenderException$annotations", "()V", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.profiler.common"})
    private final class MyTreeCellRendererAdapter
    implements TreeCellRenderer {
        @NotNull
        private final JBLabel renderException = new JBLabel("Render exception");

        private static /* synthetic */ void getRenderException$annotations() {
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            try {
                Component result2 = TimelinePanel.this.getTimelineRenderer().getNodeRendererComponent(TimelinePanel.this, value, selected, hasFocus);
                result2.setForeground(RenderingUtil.getForeground((JTree)tree, (boolean)selected));
                result2.setBackground(RenderingUtil.getBackground((JTree)tree, (boolean)selected));
                component = result2;
            }
            catch (Exception e) {
                component = (Component)this.renderException;
            }
            return component;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006H\u0096\u0082\u0004\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeIterable;", "T", "", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;)V", "iterator", "", "intellij.profiler.common"})
    private final class MyTreeIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<T> iterator() {
            Rectangle rectangle = TimelinePanel.this.tree.getVisibleRect();
            TimelinePanel timelinePanel = TimelinePanel.this;
            Rectangle $this$iterator_u24lambda_u240 = rectangle;
            boolean bl = false;
            $this$iterator_u24lambda_u240.y += timelinePanel.tree.getInsets().top;
            Rectangle visibleRect = rectangle;
            int fromIndex = TimelinePanel.this.tree.getClosestRowForLocation(visibleRect.x, visibleRect.y);
            int toIndex = TimelinePanel.this.tree.getClosestRowForLocation(visibleRect.x, visibleRect.y + visibleRect.height);
            if (fromIndex < 0 || toIndex < 0) {
                Iterator iterator2 = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"emptyIterator(...)");
                return iterator2;
            }
            return new Iterator<T>(fromIndex, toIndex, TimelinePanel.this){
                private int cursor;
                final /* synthetic */ int $toIndex;
                final /* synthetic */ TimelinePanel<T, F> this$0;
                {
                    this.$toIndex = $toIndex;
                    this.this$0 = $receiver;
                    this.cursor = $fromIndex;
                }

                public final int getCursor() {
                    return this.cursor;
                }

                public final void setCursor(int n) {
                    this.cursor = n;
                }

                public boolean hasNext() {
                    return this.cursor <= this.$toIndex;
                }

                public T next() {
                    int n = this.cursor;
                    this.cursor = n + 1;
                    return (T)TimelinePanel.access$getTree$p(this.this$0).getPathForRow(n).getLastPathComponent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u001f\u0010\u0012\u001a\u00028\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0014R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelinePanel$MyTreeModelAdapter;", "T", "Lcom/intellij/util/ui/tree/AbstractTreeModel;", "Ljavax/swing/tree/TreeModel;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "<init>", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;)V", "getRoot", "", "isLeaf", "", "node", "getChildCount", "", "parent", "getIndexOfChild", "child", "getChild", "index", "(Ljava/lang/Object;I)Ljava/lang/Object;", "intellij.profiler.common"})
    private static final class MyTreeModelAdapter<T>
    extends AbstractTreeModel
    implements TreeModel {
        @NotNull
        private final TimelineModel<T, ?> model;

        public MyTreeModelAdapter(@NotNull TimelineModel<T, ?> model2) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            this.model = model2;
        }

        @Override
        @Nullable
        public Object getRoot() {
            return this.model.getRoot();
        }

        @Override
        public boolean isLeaf(@NotNull Object node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.model.isLeaf(node);
        }

        @Override
        public int getChildCount(@NotNull Object parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return this.model.getChildCount(parent);
        }

        @Override
        public int getIndexOfChild(@NotNull Object parent, @NotNull Object child) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return this.model.getIndexOfChild(parent, child);
        }

        public T getChild(@Nullable Object parent, int index) {
            return (T)this.model.getChild(parent, index);
        }
    }
}

