/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspections.TypeScriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowJSTypeExplicitlyIntention
extends JavaScriptIntention {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(1);
        }
        return DialectDetector.isFlow((PsiElement)element) && FlowJSTypeExplicitlyIntention.isAvailableOnElement(element);
    }

    private static boolean isAvailableOnElement(@NotNull PsiElement element) {
        JSTypeDeclarationOwner declarationOwner;
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(2);
        }
        if ((declarationOwner = FlowJSTypeExplicitlyIntention.lookupTypeDeclarationOwner(element)) != null) {
            return FlowJSTypeExplicitlyIntention.isAcceptableTypeDeclarationOwner(declarationOwner);
        }
        if (element.getParent() instanceof JSFunction) {
            return ((JSFunction)element.getParent()).getReturnTypeElement() == null;
        }
        return false;
    }

    private static boolean isAcceptableTypeDeclarationOwner(@NotNull JSTypeDeclarationOwner element) {
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(3);
        }
        if (element instanceof JSParameter && ((JSParameter)element).getDeclaringFunction() == null) {
            return false;
        }
        if (element.getTypeElement() != null) {
            return false;
        }
        if (element instanceof JSParameterListElement && ((JSParameterListElement)element).getInitializer() == null) {
            return FlowJSServerManager.getService((PsiFile)element.getContainingFile()) != null;
        }
        return true;
    }

    @Nullable
    private static JSTypeDeclarationOwner lookupTypeDeclarationOwner(@NotNull PsiElement element) {
        JSTypeDeclarationOwner declarationOwner;
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(4);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(declarationOwner = (JSTypeDeclarationOwner)FlowJSTypeExplicitlyIntention.findParentNamedElement((PsiElement)element, JSTypeDeclarationOwner.class)), JSDestructuringElement.class) != null) {
            return null;
        }
        if (declarationOwner != null) {
            return declarationOwner;
        }
        if (element.getPrevSibling() instanceof JSTypeDeclarationOwner) {
            return (JSTypeDeclarationOwner)element.getPrevSibling();
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("initialization.flow-type-explicitly.display-name", new Object[0]);
        if (string == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message("initialization.flow-type-explicitly.family-name", new Object[0]);
        if (string == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(8);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element.getContainingFile()})) {
            return;
        }
        JSTypeDeclarationOwner declarationOwner = FlowJSTypeExplicitlyIntention.lookupTypeDeclarationOwner(element);
        if (declarationOwner != null) {
            FlowJSTypeExplicitlyIntention.doSpecifyType((JSElement)declarationOwner, FlowJSTypeExplicitlyIntention.getTypeFromServer((JSElement)declarationOwner));
        } else {
            PsiElement psiElement = element.getParent();
            if (psiElement instanceof JSFunction) {
                JSFunction function = (JSFunction)psiElement;
                FlowJSTypeExplicitlyIntention.doSpecifyType((JSElement)function, FlowJSTypeExplicitlyIntention.getReturnTypeFromFunction(FlowJSTypeExplicitlyIntention.getTypeFromServer((JSElement)function)));
            }
        }
    }

    private static void doSpecifyType(JSElement declarationOwner, String newTypeDeclaration) {
        if (newTypeDeclaration == null) {
            WriteAction.run(() -> TypeScriptSpecifyTypeExplicitlyQuickFix.doSpecifyExplicitType((JSElement)declarationOwner));
        } else {
            WriteAction.run(() -> JSRefactoringUtil.setType((JSElement)declarationOwner, (String)newTypeDeclaration));
        }
    }

    @Nullable
    private static String getTypeFromServer(JSElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        FlowJSServerService service = FlowJSServerManager.getService((PsiFile)file);
        if (service == null) {
            return null;
        }
        String typeFromService = service.getTypeOfElementUnderProgress(element);
        if (StringUtil.isNotEmpty((String)typeFromService) && !typeFromService.equals("(unknown)")) {
            return typeFromService;
        }
        return null;
    }

    @Nullable
    private static String getReturnTypeFromFunction(@Nullable String serverType) {
        if (StringUtil.isEmpty((String)serverType)) {
            return null;
        }
        String[] array = serverType.split("=>");
        int numberOfOpenBracket = 0;
        StringBuilder functionType = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if ((numberOfOpenBracket = FlowJSTypeExplicitlyIntention.isCorrectBracketString(array[i], numberOfOpenBracket)) != 0) continue;
            for (int j = i + 1; j < array.length; ++j) {
                functionType.append(array[j]);
                if (j + 1 == array.length) continue;
                functionType.append("=>");
            }
            return functionType.toString();
        }
        return null;
    }

    private static int isCorrectBracketString(@NotNull String string, int numberOfOpenBracketsBefore) {
        if (string == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < string.length(); ++i) {
            char letter = string.charAt(i);
            if (letter == '(' || letter == '[' || letter == '{') {
                ++numberOfOpenBracketsBefore;
            }
            if (letter != ')' && letter != ']' && letter != '}') continue;
            --numberOfOpenBracketsBefore;
        }
        return numberOfOpenBracketsBefore;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableTypeDeclarationOwner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lookupTypeDeclarationOwner";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectBracketString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

