/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.react.ReactComponentContentUtil;
import com.intellij.react.fix.ReactUnresolvedReferenceToPropFix;
import com.intellij.react.fix.ReactUnresolvedReferenceToStateFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/react/fix/ReactUnresolvedReferenceFixProvider;", "Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater;", "<init>", "()V", "updateError", "", "info", "Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater$ErrorInfo;", "node", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "resolveResults", "", "Lcom/intellij/psi/ResolveResult;", "isTypeContext", "", "(Lcom/intellij/lang/javascript/validation/JSUnresolvedReferenceErrorUpdater$ErrorInfo;Lcom/intellij/lang/javascript/psi/JSReferenceExpression;[Lcom/intellij/psi/ResolveResult;Z)V", "canBeConvertedToStateOrProp", "ref", "intellij.react.ultimate"})
@SourceDebugExtension(value={"SMAP\nReactUnresolvedReferenceFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactUnresolvedReferenceFixProvider.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceFixProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,62:1\n18#2:63\n18#2:64\n18#2:65\n*S KotlinDebug\n*F\n+ 1 ReactUnresolvedReferenceFixProvider.kt\ncom/intellij/react/fix/ReactUnresolvedReferenceFixProvider\n*L\n22#1:63\n28#1:64\n55#1:65\n*E\n"})
public final class ReactUnresolvedReferenceFixProvider
implements JSUnresolvedReferenceErrorUpdater {
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, @NotNull ResolveResult[] resolveResults, boolean isTypeContext) {
        String componentName;
        JSPsiElementBase component;
        JSLanguageDialect jSLanguageDialect;
        Language language;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
        PsiFile $this$asSafely$iv = node.getContainingFile();
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof JSFile)) {
            psiFile = null;
        }
        JSFile jSFile = (JSFile)psiFile;
        if (jSFile == null) {
            return;
        }
        JSFile jsFile = jSFile;
        if (jsFile.getFileType() instanceof JavaScriptFileType && !jsFile.hasJSXSyntax()) {
            return;
        }
        Language language2 = jsFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Language $this$asSafely$iv2 = language = language2;
        boolean $i$f$asSafely2 = false;
        Language language3 = $this$asSafely$iv2;
        if (!(language3 instanceof JSLanguageDialect)) {
            language3 = null;
        }
        if ((jSLanguageDialect = (JSLanguageDialect)language3) == null || (jSLanguageDialect = jSLanguageDialect.getOptionHolder()) == null) {
            return;
        }
        JSLanguageDialect optionHolder = jSLanguageDialect;
        if (!optionHolder.isJSX()) {
            return;
        }
        JSPsiElementBase jSPsiElementBase = component = ReactComponentContentUtil.getContainingComponent((JSExpression)node);
        String string = componentName = jSPsiElementBase != null ? jSPsiElementBase.getName() : null;
        if (component == null || componentName == null) {
            return;
        }
        if (this.canBeConvertedToStateOrProp(node)) {
            if (optionHolder.isTSX) {
                info.add((LocalQuickFix)new ReactUnresolvedReferenceToPropFix(node, componentName));
            }
            if (!(component instanceof JSClass)) {
                info.add((LocalQuickFix)new ReactUnresolvedReferenceToStateFix(node, componentName));
            }
        }
    }

    private final boolean canBeConvertedToStateOrProp(JSReferenceExpression ref) {
        JSPrefixExpression parent;
        JSPrefixExpression jSPrefixExpression;
        if (ref.getFirstChild() instanceof JSReferenceExpression) {
            return false;
        }
        PsiElement $this$asSafely$iv = ref.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JSPrefixExpression)) {
            psiElement = null;
        }
        if ((jSPrefixExpression = (JSPrefixExpression)psiElement) == null || (jSPrefixExpression = jSPrefixExpression.getParent()) == null) {
            jSPrefixExpression = ref.getParent();
        }
        if ((parent = jSPrefixExpression) instanceof JSEmbeddedContent) {
            return true;
        }
        return parent instanceof JSBinaryExpression || parent instanceof JSConditionalExpression;
    }
}

