/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.refactoring;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.ReactUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.react.ReactBundle;
import com.intellij.react.free.ReactFilterProvider;
import com.intellij.react.refactoring.ReactClassToFunctionComponentHandler;
import com.intellij.react.refactoring.ReactFunctionToClassComponentAction;
import com.intellij.react.refactoring.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFunctionToClassComponentHandler
implements RefactoringActionHandler {
    public boolean isAvailable(@NotNull JSNamedElement element, boolean allowAnonymous) {
        JSVarStatement varStatement;
        JSFunction function;
        if (element == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(0);
        }
        if ((function = JSPsiImplUtils.getPossibleFunction((PsiElement)element)) == null) {
            return false;
        }
        if (element instanceof JSVariable && (varStatement = ((JSVariable)element).getStatement()) != null && varStatement.getDeclarations().length > 1) {
            return false;
        }
        return (JSXResolveUtil.isComponentName((String)function.getName()) || allowAnonymous && function.getName() == null) && ReactFilterProvider.isFunctionComponentBySignature((JSFunctionItem)function) && !ReactFunctionToClassComponentHandler.hasInstanceProperties(element);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, ReactFunctionToClassComponentAction.getParentDeclaration(file.findElementAt(editor.getCaretModel().getOffset())));
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable JSNamedElement namedElement) {
        if (project == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(5);
        }
        JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)namedElement);
        if (namedElement == null || function == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)ReactBundle.message("react.function.to.class.caret.at.function", new Object[0]));
            ReactFunctionToClassComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)namedElement, (Editor)editor, (String)ReactFunctionToClassComponentHandler.getRefactoringTitle())) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)namedElement, (boolean)false));
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            SearchScope useScope = (SearchScope)ReadAction.compute(() -> namedElement.getUseScope());
            ReferencesSearch.search((PsiElement)namedElement, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                PsiElement parentElement = refElement.getParent();
                if (refElement instanceof JSReferenceExpression && parentElement instanceof JSCallExpression) {
                    String message = parentElement instanceof JSNewExpression ? ReactBundle.message("refactoring.react.function.to.class.used.in.new.conflict", elementDescription) : ReactBundle.message("refactoring.react.function.to.class.used.in.call.conflict", elementDescription);
                    conflicts.putValue((Object)refElement, (Object)message);
                }
                return true;
            });
        }, JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function);
        boolean isTypedDialect = languageDialect != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        List<ReactExtractComponentHandlerBase.Prop> inferredProps = ReactFunctionToClassComponentHandler.inferPropsFromDestructuring((JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters()));
        String introducedName = namedElement.getName();
        if (!isTypedDialect && !inferredProps.isEmpty() && StringUtil.isEmpty((String)introducedName) && StringUtil.isEmpty((String)(introducedName = ReactClassToFunctionComponentHandler.showNameDialog(project, (JSNamedElement)function)))) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)ReactFunctionToClassComponentHandler.getRefactoringTitle(), null, () -> this.doRefactoringInWriteAction(finalIntroducedName, namedElement, function, editor, inferredProps), (PsiFile[])new PsiFile[0]);
    }

    @Nullable
    protected PsiElement doRefactoringInWriteAction(@Nullable String introducedName, @NotNull JSNamedElement namedElement, @NotNull JSFunction function, @NotNull Editor editor, @NotNull List<ReactExtractComponentHandlerBase.Prop> inferredProps) {
        JSSourceElement[] templateStatements;
        JSClass createdClass;
        String defaultValuesText;
        JSLanguageDialect languageDialect;
        if (namedElement == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(6);
        }
        if (function == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(8);
        }
        if (inferredProps == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(9);
        }
        boolean isTypedDialect = (languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function)) != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        JSParameterListElement propsParameter = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters());
        JSBlockStatement convertedRenderFunctionBody = ReactFunctionToClassComponentHandler.getConvertedRenderFunctionBody(function);
        if (convertedRenderFunctionBody == null) {
            return null;
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)function.getProject());
        String codeTemplateName = ReactExtractComponentHandlerBase.getCodeTemplateName(ReactExtractComponentHandlerBase.ComponentType.Class, isTypedDialect);
        JSExpression defaultPropsProperty = ReactFunctionToClassComponentHandler.findPropertyInitializerInCurrentFile(namedElement, "defaultProps");
        JSExpression propTypesProperty = ReactFunctionToClassComponentHandler.findPropertyInitializerInCurrentFile(namedElement, "propTypes");
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        properties.setProperty("HAS_PROPS", Boolean.valueOf(propsParameter != null).toString());
        String propTypesText = ReactFunctionToClassComponentHandler.getPropsText(namedElement, propsParameter, propTypesProperty, inferredProps, isTypedDialect);
        if (!StringUtil.isEmpty((String)propTypesText)) {
            properties.setProperty("PROP_TYPES", propTypesText);
        }
        if (!StringUtil.isEmpty((String)(defaultValuesText = ReactFunctionToClassComponentHandler.getDefaultPropsText(defaultPropsProperty, inferredProps)))) {
            properties.setProperty("DEFAULT_PROPS", defaultValuesText);
        }
        PsiFile createdFile = (createdClass = ReactExtractComponentHandlerBase.expandTemplate((PsiElement)namedElement, properties, codeTemplateName, JSClass.class)) != null ? createdClass.getContainingFile() : null;
        JSFunction renderMethod = createdClass != null ? createdClass.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE) : null;
        JSBlockStatement templateBody = ReactFunctionToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSSourceElement[] jSSourceElementArray = templateStatements = templateBody != null ? templateBody.getStatementListItems() : JSSourceElement.EMPTY_ARRAY;
        if (createdClass == null || templateBody == null || templateStatements.length == 0) {
            String message = ReactBundle.message("refactoring.react.could.not.find.in.template", introducedName, codeTemplateName);
            ReactFunctionToClassComponentHandler.showErrorHint(namedElement.getProject(), editor, message);
            return null;
        }
        ReactFunctionToClassComponentHandler.copyExportStatus(namedElement, (JSAttributeListOwner)createdClass);
        ReactExtractComponentHandlerBase.addRequiredImportsForClassComponent(createdClass, (PsiElement)namedElement);
        ReactFunctionToClassComponentHandler.copyReturnType((JSNamedElement)function, (JSNamedElement)renderMethod);
        JSChangeUtil.replaceStatement((JSStatement)templateBody, (JSStatement)convertedRenderFunctionBody);
        ReactFunctionToClassComponentHandler.deletePropertyIfNeeded(propTypesProperty, createdClass, "propTypes");
        ReactFunctionToClassComponentHandler.deletePropertyIfNeeded(defaultPropsProperty, createdClass, "defaultProps");
        PsiElement result = ReactClassToFunctionComponentHandler.expressionAwareReplace(namedElement, createdFile, (JSElement)createdClass, createdClass.getName());
        ReactClassToFunctionComponentHandler.moveCaretToElement(editor, result);
        FormatFixer.create((PsiElement)result, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        return result;
    }

    private static void deletePropertyIfNeeded(@Nullable JSExpression existingProperty, @NotNull JSClass createdClass, @NotNull String propName) {
        if (createdClass == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(10);
        }
        if (propName == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(11);
        }
        if (existingProperty == null) {
            return;
        }
        JSExpression createdProperty = ReactFunctionToClassComponentHandler.findPropertyInitializerInCurrentFile((JSNamedElement)createdClass, propName);
        if (createdProperty != null) {
            ReactFunctionToClassComponentHandler.deleteContainingStatement((JSElement)createdProperty);
        }
        if (createdClass.findFieldByName(propName) != null) {
            ReactFunctionToClassComponentHandler.deleteContainingStatement((JSElement)existingProperty);
        }
    }

    @NotNull
    private static List<ReactExtractComponentHandlerBase.Prop> inferPropsFromDestructuring(@Nullable JSParameterListElement propsParameter) {
        JSDestructuringContainer target;
        JSDestructuringContainer jSDestructuringContainer = target = propsParameter instanceof JSDestructuringParameter ? ((JSDestructuringParameter)propsParameter).getTarget() : null;
        if (!(target instanceof JSDestructuringObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactFunctionToClassComponentHandler.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Object[])((JSDestructuringObject)target).getProperties(), property -> {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name) || property.isRest()) {
                return null;
            }
            JSInitializerOwner initializerOwner = property.getDestructuringElement();
            JSExpression initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
            return new ReactExtractComponentHandlerBase.Prop(name, ReactExtractComponentHandlerBase.getUsableExpressionType(initializer, (PsiElement)property), initializer != null ? initializer.getText() : null);
        });
        if (list == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public static TypeScriptSingleType getSFCTypeDeclaration(@NotNull JSNamedElement namedElement) {
        String name;
        JSReferenceExpression typeReferenceExpression;
        PsiElement typeElement;
        if (namedElement == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(14);
        }
        if (namedElement instanceof JSTypeDeclarationOwner && (typeElement = ((JSTypeDeclarationOwner)namedElement).getTypeElement()) instanceof TypeScriptSingleType && (typeReferenceExpression = ((TypeScriptSingleType)typeElement).getReferenceExpression()) != null && (name = typeReferenceExpression.getReferenceName()) != null && ReactUtil.REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(name)) {
            return (TypeScriptSingleType)typeElement;
        }
        return null;
    }

    @Nullable
    private static String getPropsText(@NotNull JSNamedElement namedElement, @Nullable JSParameterListElement propsParameter, @Nullable JSExpression propTypesProperty, @NotNull List<ReactExtractComponentHandlerBase.Prop> inferredProps, boolean isTypedDialect) {
        PsiElement propsTypeElement;
        TypeScriptSingleType sfcTypeDeclaration;
        if (namedElement == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(15);
        }
        if (inferredProps == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(16);
        }
        if ((sfcTypeDeclaration = ReactFunctionToClassComponentHandler.getSFCTypeDeclaration(namedElement)) != null) {
            JSTypeDeclaration typeArg = (JSTypeDeclaration)ArrayUtil.getFirstElement((Object[])sfcTypeDeclaration.getTypeArguments());
            return typeArg != null ? typeArg.getText() : null;
        }
        PsiElement psiElement = propsTypeElement = propsParameter != null ? propsParameter.getTypeElement() : null;
        if (propsTypeElement != null) {
            return propsTypeElement.getText();
        }
        boolean isPropsTypeParameterRequired = DialectDetector.isFlow((PsiElement)namedElement);
        if (propTypesProperty != null) {
            return propTypesProperty.getText();
        }
        if (!inferredProps.isEmpty()) {
            if (isTypedDialect) {
                return ReactExtractComponentHandlerBase.buildTypedPropTypesText(inferredProps, !isPropsTypeParameterRequired);
            }
            return ReactExtractComponentHandlerBase.buildJSPropTypesText(inferredProps, (PsiElement)namedElement);
        }
        return isPropsTypeParameterRequired ? "{}" : null;
    }

    @Nullable
    private static String getDefaultPropsText(@Nullable JSExpression defaultPropsProp, @NotNull List<ReactExtractComponentHandlerBase.Prop> inferredProps) {
        if (inferredProps == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(17);
        }
        if (defaultPropsProp != null) {
            return defaultPropsProp.getText();
        }
        if ((inferredProps = ContainerUtil.filter(inferredProps, t -> t.value != null)).isEmpty()) {
            return null;
        }
        return "{" + StringUtil.join((Collection)inferredProps, t -> t.name + ": " + t.value, (String)", ") + "}";
    }

    @Nullable
    private static JSExpression findPropertyInitializerInCurrentFile(@NotNull JSNamedElement namedElement, @NotNull String propName) {
        String namespace;
        if (namedElement == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(18);
        }
        if (propName == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(19);
        }
        if ((namespace = namedElement.getName()) == null) {
            return null;
        }
        PsiFile file = namedElement.getContainingFile();
        for (PsiElement child : file.getChildren()) {
            JSExpression initializer = ReactFunctionToClassComponentHandler.getInitializerIfProperty(child, namespace, propName);
            if (initializer == null) continue;
            return initializer;
        }
        return null;
    }

    @Nullable
    private static JSExpression getInitializerIfProperty(@Nullable PsiElement candidate, @NotNull String namespace, @NotNull String propertyName) {
        if (namespace == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(20);
        }
        if (propertyName == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(21);
        }
        if (!(candidate instanceof JSExpressionStatement)) {
            return null;
        }
        JSExpression expression = ((JSExpressionStatement)candidate).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return null;
        }
        JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)expression).getDefinitionExpression();
        if (definitionExpression == null) {
            return null;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName((JSExpression)definitionExpression.getExpression(), (String[])new String[]{namespace, propertyName})) {
            return definitionExpression.getInitializer();
        }
        return null;
    }

    private static boolean hasInstanceProperties(@NotNull JSNamedElement namedElement) {
        if (namedElement == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(22);
        }
        if (namedElement.getName() == null) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)namedElement.getContainingFile());
        return !JSClassResolver.getInstance().processNamespaceMembers(namedElement.getName(), scope, element -> element.getJSContext() != JSContext.INSTANCE);
    }

    @Nullable
    private static JSBlockStatement getConvertedRenderFunctionBody(@NotNull JSFunction function) {
        JSParameterListElement[] parameters;
        if (function == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(23);
        }
        JSParameterListElement propsParameter = (parameters = function.getParameters()).length > 0 ? parameters[0] : null;
        JSParameterListElement contextParameter = parameters.length > 1 ? parameters[1] : null;
        JSBlockStatement functionBody = ReactFunctionToClassComponentHandler.findFunctionBlockBody(function);
        JSExpression arrowFunctionReturned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        JSElement toProcess = (JSElement)ObjectUtils.coalesce((Object)functionBody, (Object)arrowFunctionReturned);
        if (toProcess == null) {
            return null;
        }
        String replacementText = ReactFunctionToClassComponentHandler.replaceParameterReferences(toProcess, propsParameter, contextParameter);
        if (arrowFunctionReturned != null) {
            replacementText = String.format("{\nreturn %s%s\n}", replacementText, semicolon);
        }
        JSBlockStatement replacementStatement = (JSBlockStatement)JSPsiElementFactory.createJSStatement((String)replacementText, (PsiElement)function, JSBlockStatement.class);
        if (propsParameter instanceof JSDestructuringParameter) {
            JSDestructuringParameter parameterCopy = (JSDestructuringParameter)propsParameter.copy();
            JSDestructuringObject destructuringObject = (JSDestructuringObject)ObjectUtils.tryCast((Object)parameterCopy.getTarget(), JSDestructuringObject.class);
            if (destructuringObject != null) {
                for (JSDestructuringProperty property : destructuringObject.getProperties()) {
                    JSInitializerOwner element = property.getDestructuringElement();
                    if (element == null) continue;
                    JSRefactoringUtil.removeInitializer((JSInitializerOwner)element);
                }
            }
            JSRefactoringUtil.removeInitializer((JSInitializerOwner)parameterCopy);
            JSRefactoringUtil.setType((JSElement)parameterCopy, null);
            String text = String.format("let %s = this.%s%s", parameterCopy.getText(), "props", semicolon);
            JSStatement propsInitialization = JSPsiElementFactory.createJSStatement((String)text, (PsiElement)propsParameter);
            ReactFunctionToClassComponentHandler.addStatementAtStart(replacementStatement, propsInitialization);
        }
        if (contextParameter instanceof JSDestructuringParameter) {
            String text = String.format("let %s = this.%s%s", contextParameter.getText(), "context", semicolon);
            JSStatement contextInitialization = JSPsiElementFactory.createJSStatement((String)text, (PsiElement)propsParameter);
            ReactFunctionToClassComponentHandler.addStatementAtStart(replacementStatement, contextInitialization);
        }
        return replacementStatement;
    }

    private static void addStatementAtStart(@NotNull JSBlockStatement block, @NotNull JSStatement toAdd) {
        ASTNode lbraceNode;
        if (block == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(24);
        }
        if (toAdd == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(25);
        }
        block.addAfter((PsiElement)toAdd, (lbraceNode = block.getNode().findChildByType(JSTokenTypes.LBRACE)) != null ? lbraceNode.getPsi() : null);
    }

    private static void deleteContainingStatement(@NotNull JSElement element) {
        JSSourceElement statement;
        if (element == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(26);
        }
        if ((statement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)false)) != null) {
            statement.delete();
        }
    }

    @NotNull
    private static String replaceParameterReferences(@NotNull JSElement toProcess, @Nullable JSParameterListElement propsParameter, @Nullable JSParameterListElement contextParameter) {
        if (toProcess == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(27);
        }
        HashMap paramReferencesToReplace = new HashMap();
        PsiTreeUtil.processElements((PsiElement)toProcess, element -> {
            if (element instanceof JSReferenceExpression) {
                PsiElement resolved = ((JSReferenceExpression)element).resolve();
                if (propsParameter instanceof JSParameter && propsParameter.isEquivalentTo(resolved)) {
                    paramReferencesToReplace.put((JSReferenceExpression)element, "this.props");
                } else if (contextParameter instanceof JSParameter && contextParameter.isEquivalentTo(resolved)) {
                    paramReferencesToReplace.put((JSReferenceExpression)element, "this.context");
                }
            }
            return true;
        });
        String string = ReactExtractComponentHandlerBase.replaceOccurrences(toProcess, toProcess.getTextRange(), paramReferencesToReplace);
        if (string == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static JSBlockStatement findFunctionBlockBody(@Nullable JSFunction function) {
        return function == null ? null : function.getBlock();
    }

    public static void copyReturnType(@Nullable JSNamedElement owner, @Nullable JSNamedElement target) {
        PsiElement typeElement;
        if (owner instanceof JSFunction && target instanceof JSFunction && (typeElement = ((JSFunction)owner).getReturnTypeElement()) != null) {
            JSRefactoringUtil.setFunctionReturnType((JSFunction)((JSFunction)target), (String)typeElement.getText());
        }
    }

    public static void copyExportStatus(@NotNull JSNamedElement source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(29);
        }
        if (target == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(30);
        }
        boolean isExported = source instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)((JSAttributeListOwner)source), (JSAttributeList.ModifierType)JSAttributeList.ModifierType.EXPORT);
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(target);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, isExported);
        attributeListWrapper.applyTo(target);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(32);
        }
        if (message == null) {
            ReactFunctionToClassComponentHandler.$$$reportNull$$$0(33);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ReactFunctionToClassComponentHandler.getRefactoringTitle(), null);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringTitle() {
        return ReactBundle.message("refactoring.react.function.to.class.refactoring.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 8: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredProps";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdClass";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 12: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/refactoring/ReactFunctionToClassComponentHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/refactoring/ReactFunctionToClassComponentHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inferPropsFromDestructuring";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceParameterReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deletePropertyIfNeeded";
                break;
            }
            case 12: 
            case 13: 
            case 28: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSFCTypeDeclaration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPropsText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropsText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyInitializerInCurrentFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerIfProperty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasInstanceProperties";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedRenderFunctionBody";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addStatementAtStart";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deleteContainingStatement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceParameterReferences";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyExportStatus";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 28 -> new IllegalStateException(string);
        };
    }
}

