/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.util.Out;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranspositionAwareExtractor
extends DefaultValuesExtractor {
    protected static final GridColumn ROW_NAMES_COLUMN = new DataConsumer.Column(0, "Column", 12, "", "");

    protected TranspositionAwareExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(0);
        }
        super(converter);
    }

    @Override
    public String getValueLiteral(@NotNull String value, @Nullable GridRow row, @Nullable GridColumn column) {
        if (value == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(1);
        }
        return super.getValueLiteral(value, TranspositionAwareExtractor.getOriginalRow(row, column), TranspositionAwareExtractor.getOriginalColumn(row, column));
    }

    @Override
    protected boolean isStringLiteral(@Nullable GridRow row, @Nullable GridColumn column) {
        return false;
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode) {
        if (row == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(2);
        }
        if (column == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(4);
        }
        return super.getValueAsString(TranspositionAwareExtractor.getOriginalRow(row, column), TranspositionAwareExtractor.getOriginalColumn(row, column), mode);
    }

    @Nullable
    protected static GridColumn getOriginalColumn(@Nullable GridRow row, @Nullable GridColumn column) {
        return row instanceof TransposedRow ? ((TransposedRow)row).originalColumn : column;
    }

    @Nullable
    protected static GridRow getOriginalRow(@Nullable GridRow row, @Nullable GridColumn column) {
        return column instanceof TransposedColumn ? ((TransposedColumn)column).originalRow : row;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/TranspositionAwareExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueLiteral";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class TransposedRow
    extends DataConsumer.Row {
        public final GridColumn originalColumn;

        public TransposedRow(int rowNum, Object[] values, GridColumn originalColumn) {
            super(rowNum, values);
            this.originalColumn = originalColumn;
        }
    }

    protected static class TransposedColumn
    extends DataConsumer.Column {
        public final GridRow originalRow;

        public TransposedColumn(int columnNum, GridRow originalRow) {
            super(columnNum, "Value (" + originalRow.getRowNum() + ")", 12, "", "");
            this.originalRow = originalRow;
        }
    }

    public static abstract class TranspositionAwareExtraction
    extends DefaultValuesExtractor.DefaultExtraction {
        protected final DataExtractor myExtractor;

        public TranspositionAwareExtraction(Out out, @NotNull ExtractionConfig config, List<? extends GridColumn> allColumns, String query, int[] selectedColumnIndices, DataExtractor extractor) {
            if (config == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(0);
            }
            super(out, config, allColumns, query, selectedColumnIndices);
            this.myExtractor = extractor;
        }

        @Override
        protected final void appendHeader(boolean appendNewLine) {
            if (!this.myConfig.isTransposed()) {
                this.doAppendHeader(appendNewLine);
            }
        }

        @Override
        protected final void appendData(List<? extends GridRow> rows) {
            if (!this.myConfig.isTransposed()) {
                this.doAppendData(rows);
            } else {
                this.doTransposedExtraction(rows);
            }
        }

        @Override
        protected final void appendFooter() {
            if (!this.myConfig.isTransposed()) {
                this.doAppendFooter();
            }
        }

        @NotNull
        protected String getRowNumber(GridRow row) {
            if (!this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0)) {
                Object rowNumber = ROW_NAMES_COLUMN.getValue(row);
                return rowNumber instanceof String ? (String)rowNumber : "";
            }
            String string = String.valueOf(row.getRowNum());
            if (string == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        protected GridColumn getRowNumbersColumn() {
            GridColumn gridColumn = !this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0) ? ROW_NAMES_COLUMN : super.getRowNumbersColumn();
            if (gridColumn == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(2);
            }
            return gridColumn;
        }

        protected void doTransposedExtraction(List<? extends GridRow> rows) {
            List<GridColumn> transposedColumns = this.getTransposedColumns(rows);
            int[] selectedColumns = new int[Math.max(0, transposedColumns.size() - 1)];
            for (int i = 0; i < selectedColumns.length; ++i) {
                selectedColumns[i] = i + 1;
            }
            DataExtractor.Extraction e = this.spawnChildExtraction(this.myOut, transposedColumns, this.myQuery, this.myConfig.toBuilder().setTransposed(false).build(), this.myConfig.isTransposed(), selectedColumns);
            e.addData(this.getTransposedRows(rows));
            e.completeBatch();
        }

        protected DataExtractor.Extraction spawnChildExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, Boolean isOriginallyTransposed, int ... selectedColumns) {
            if (out == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(3);
            }
            if (allColumns == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(4);
            }
            if (query == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(5);
            }
            if (config == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(6);
            }
            return this.myExtractor.startExtraction(out, allColumns, query, config, selectedColumns);
        }

        protected abstract void doAppendHeader(boolean var1);

        protected abstract void doAppendData(List<? extends GridRow> var1);

        protected void doAppendFooter() {
            super.appendFooter();
        }

        protected List<GridRow> getTransposedRows(List<? extends GridRow> rows) {
            int[] originalSelection = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            ArrayList<GridRow> transposedRows = new ArrayList<GridRow>(originalSelection.length);
            for (int i : originalSelection) {
                GridColumn column = (GridColumn)this.myAllColumns.get(i);
                Object[] transposedRow = new Object[rows.size() + 1];
                transposedRow[0] = column.getName();
                for (int j = 0; j < rows.size(); ++j) {
                    transposedRow[j + 1] = column.getValue(rows.get(j));
                }
                transposedRows.add(new TransposedRow(i, transposedRow, column));
            }
            return transposedRows;
        }

        protected List<GridColumn> getTransposedColumns(List<? extends GridRow> rows) {
            ArrayList<GridColumn> transposedColumns = new ArrayList<GridColumn>(rows.size() + 1);
            transposedColumns.add(ROW_NAMES_COLUMN);
            for (int i = 0; i < rows.size(); ++i) {
                transposedColumns.add(new TransposedColumn(i + 1, rows.get(i)));
            }
            return transposedColumns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allColumns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumber";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumbersColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "spawnChildExtraction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

