/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.TypeDescriptor;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.database.util.RunnableWithDebounce;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TypesRegistry
implements TextDecomposition.PatternFactory {
    private static final ExtensionPointName<TypeDescriptorFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.urlParamEditorProvider");
    @Language(value="regexp")
    public static final String HOST_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    @Language(value="regexp")
    public static final String IPV6_COLON_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}";
    @Language(value="regexp")
    public static final String IPV6_DOT_QUAD_PATTERN = "(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    @Language(value="regexp")
    public static final String IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    @Language(value="regexp")
    public static final String HOST_N_IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}|[\\p{L}\\p{M}\\p{N}[-_.]]+";
    @Language(value="regexp")
    public static final String PARAMETER_PATTERN = "[^;=&]+";
    @Language(value="regexp")
    public static final String PORT_PATTERN = "[\\p{N}]{1,5}";
    @Language(value="regexp")
    public static final String DB_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    @Language(value="regexp")
    public static final String FILE_PATH_PATTERN = "(?!//)[^;?&]+?|/";
    @Language(value="regexp")
    public static final String USER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    @Language(value="regexp")
    public static final String PASSWORD_PATTERN = "[^&=;)/:@]+";
    @Language(value="regexp")
    public static final String PATH_PATTERN = "(?!//)[^;?&]+?|/";
    @Language(value="regexp")
    public static final String IDENTIFIER_PATTERN = "[^&=;)/:@]+";
    public static final String CATEGORY_LARGE_TEXT = "large_text";
    public static final String CATEGORY_MEDIUM_TEXT = "medium_text";
    public static final String CATEGORY_SMALL_TEXT = "small_text";
    private volatile Map<String, TypeDescriptor> myTypes;

    public static TypesRegistry getInstance() {
        return (TypesRegistry)ApplicationManager.getApplication().getService(TypesRegistry.class);
    }

    private TypesRegistry(@NotNull CoroutineScope cs) {
        if (cs == null) {
            TypesRegistry.$$$reportNull$$$0(0);
        }
        this.updateState();
        RunnableWithDebounce handler = new RunnableWithDebounce(cs, () -> this.updateState());
        EP_NAME.addChangeListener(cs, (Runnable)handler);
    }

    private void updateState() {
        HashMap<String, TypeDescriptor> newTypes = new HashMap<String, TypeDescriptor>();
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("identifier", "[^&=;)/:@]+", DatabaseBundle.message((String)"TypeDescriptor.param.identifier", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("param", PARAMETER_PATTERN, DatabaseBundle.message((String)"TypeDescriptor.param.param", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("user", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", DatabaseBundle.message((String)"TypeDescriptor.param.user", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("password", "[^&=;)/:@]+", DatabaseBundle.message((String)"TypeDescriptor.param.password", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("host", HOST_PATTERN, DatabaseBundle.message((String)"TypeDescriptor.param.host", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("host_ipv6", HOST_N_IPV6_PATTERN, DatabaseBundle.message((String)"TypeDescriptor.param.host_ipv6", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("ipv6", IPV6_PATTERN, DatabaseBundle.message((String)"TypeDescriptor.param.ipv6", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("port", PORT_PATTERN, DatabaseBundle.message((String)"TypeDescriptor.param.port", (Object[])new Object[0]), CATEGORY_SMALL_TEXT));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("database", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", DatabaseBundle.message((String)"TypeDescriptor.param.database", (Object[])new Object[0])));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("file", "(?!//)[^;?&]+?|/", DatabaseBundle.message((String)"TypeDescriptor.param.file", (Object[])new Object[0]), CATEGORY_LARGE_TEXT));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("path", "(?!//)[^;?&]+?|/", DatabaseBundle.message((String)"TypeDescriptor.param.path", (Object[])new Object[0]), CATEGORY_LARGE_TEXT));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("path_db", "(?!//)[^;?&]+?|/", DatabaseBundle.message((String)"TypeDescriptor.param.path_db", (Object[])new Object[0]), CATEGORY_LARGE_TEXT));
        TypesRegistry.put(newTypes, TypesRegistry.createTypeDescriptor("true_box", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", DatabaseBundle.message((String)"TypeDescriptor.param.true_box", (Object[])new Object[0]), CATEGORY_SMALL_TEXT));
        TypesRegistry.put(newTypes, TypesRegistry.createVariantTypeDescriptor("variants", DatabaseBundle.message((String)"TypeDescriptor.param.variants", (Object[])new Object[0])));
        for (TypeDescriptorFactory factory : EP_NAME.getExtensionList()) {
            factory.createTypeDescriptor((Consumer<? super TypeDescriptor>)((Consumer)desc -> TypesRegistry.put(newTypes, desc)));
        }
        this.myTypes = newTypes;
    }

    @Override
    @Nullable
    public Pattern getPattern(@NotNull String type, @Nullable String configuration, @Nullable String patternOverride) {
        TypeDescriptor descriptor;
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(1);
        }
        return (descriptor = this.get(type)) == null ? null : descriptor.getPattern(configuration, patternOverride);
    }

    private static void put(Map<String, TypeDescriptor> newTypes, @NotNull TypeDescriptor desc) {
        if (desc == null) {
            TypesRegistry.$$$reportNull$$$0(2);
        }
        TypeDescriptor prev = newTypes.put(desc.getName(), desc);
        assert (prev == null);
    }

    @Nullable
    public TypeDescriptor get(@NotNull String type) {
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(3);
        }
        return this.myTypes.get(type);
    }

    public static TypeDescriptor createTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption) {
        if (name == null) {
            TypesRegistry.$$$reportNull$$$0(4);
        }
        if (regex == null) {
            TypesRegistry.$$$reportNull$$$0(5);
        }
        if (defaultCaption == null) {
            TypesRegistry.$$$reportNull$$$0(6);
        }
        return TypesRegistry.createTypeDescriptor(name, regex, defaultCaption, CATEGORY_MEDIUM_TEXT);
    }

    public static TypeDescriptor createTypeDescriptor(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption, @NotNull String category) {
        if (name == null) {
            TypesRegistry.$$$reportNull$$$0(7);
        }
        if (regex == null) {
            TypesRegistry.$$$reportNull$$$0(8);
        }
        if (defaultCaption == null) {
            TypesRegistry.$$$reportNull$$$0(9);
        }
        if (category == null) {
            TypesRegistry.$$$reportNull$$$0(10);
        }
        return new TypeDescriptorImpl(name, regex, defaultCaption, category);
    }

    public static TypeDescriptor createVariantTypeDescriptor(@NotNull String name, @NlsContexts.Label @NotNull String defaultCaption) {
        if (name == null) {
            TypesRegistry.$$$reportNull$$$0(11);
        }
        if (defaultCaption == null) {
            TypesRegistry.$$$reportNull$$$0(12);
        }
        return new VariantTypeDescriptor(name, defaultCaption);
    }

    @NotNull
    public static String getParameterKey(@NotNull String param) {
        if (param == null) {
            TypesRegistry.$$$reportNull$$$0(13);
        }
        String string = "TypeDescriptor.param." + StringUtil.toLowerCase((String)param).replaceAll("[^\\w]", "_");
        if (string == null) {
            TypesRegistry.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static List<Pair<String, String>> parseConfiguration(@Nullable String configuration) {
        if (StringUtil.isEmpty((String)configuration)) {
            return null;
        }
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        Matcher matcher = VariantTypeDescriptor.CONFIG_PATTERN.matcher(configuration);
        int start2 = 0;
        while (matcher.find(start2)) {
            if (matcher.start() != start2) {
                return null;
            }
            start2 = matcher.end();
            res.add((Pair<String, String>)Pair.create((Object)matcher.group(1), (Object)matcher.group(2)));
        }
        if (configuration.length() != start2) {
            return null;
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCaption";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypeDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVariantTypeDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterKey";
                break;
            }
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }

    public static interface TypeDescriptorFactory {
        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptor> var1);
    }

    private static class TypeDescriptorImpl
    implements TypeDescriptor {
        private final String myRegex;
        private final String myName;
        private final @NlsContexts.Label String myDefaultCaption;
        private final String myCategory;

        protected TypeDescriptorImpl(@NotNull String name, @NotNull String regex, @NlsContexts.Label @NotNull String defaultCaption, @NotNull String category) {
            if (name == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(2);
            }
            if (category == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(3);
            }
            this.myRegex = regex;
            this.myName = name;
            this.myDefaultCaption = defaultCaption;
            this.myCategory = category;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = Pattern.compile(patternOverride != null ? patternOverride : this.myRegex);
            if (pattern == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(5);
            }
            return pattern;
        }

        @Override
        @NotNull
        public String getCategory() {
            String string = this.myCategory;
            if (string == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NlsContexts.Label
        @NotNull
        public String getDefaultCaption() {
            String string = this.myDefaultCaption;
            if (string == null) {
                TypeDescriptorImpl.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$TypeDescriptorImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$TypeDescriptorImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCaption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class VariantTypeDescriptor
    extends TypeDescriptorImpl {
        private static final Pattern CONFIG_PATTERN = Pattern.compile("(?:^|,)((?:[^=,]|\\\\=)+)=((?:[^=,]|\\\\=)*)");

        private VariantTypeDescriptor(@NotNull String name, @NlsContexts.Label @NotNull String defaultCaption) {
            if (name == null) {
                VariantTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (defaultCaption == null) {
                VariantTypeDescriptor.$$$reportNull$$$0(1);
            }
            super(name, "", defaultCaption, "text");
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = VariantTypeDescriptor.getPattern(configuration);
            Pattern pattern2 = pattern == null ? super.getPattern(configuration, patternOverride) : pattern;
            if (pattern2 == null) {
                VariantTypeDescriptor.$$$reportNull$$$0(2);
            }
            return pattern2;
        }

        @Nullable
        public static Pattern getPattern(@Nullable String configuration) {
            List<Pair<String, String>> parsed = TypesRegistry.parseConfiguration(configuration);
            if (parsed == null) {
                return null;
            }
            PatternBuilder builder = PatternBuilder.build("");
            boolean first2 = true;
            for (Pair<String, String> pair : parsed) {
                if (!first2) {
                    builder.append("|");
                }
                first2 = false;
                builder.append(Pattern.quote((String)pair.second));
            }
            return builder.compile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$VariantTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$VariantTypeDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

