/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.StringFun;
import java.io.BufferedWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u00052\n\u0010\u000e\u001a\u00060\u0006j\u0002`\u0007H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DiagnosticLogFormatVersion", "", "currTime", "", "appendShortTimeStr", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "time", "exportDateTimeStr", "", "closeSafely", "Ljava/io/BufferedWriter;", "addStackTraceInto", "b", "whetherToPutTheStackEntryIntoTheLog", "", "e", "Ljava/lang/StackTraceElement;", "filesToSkipInTrace", "", "intellij.database.core.impl"})
@JvmName(name="DiagnosticMonitorInternals")
public final class DiagnosticMonitorInternals {
    public static final int DiagnosticLogFormatVersion = 1;
    @NotNull
    private static final Set<String> filesToSkipInTrace;

    public static final long currTime() {
        return System.currentTimeMillis();
    }

    public static final void appendShortTimeStr(@NotNull StringBuilder $this$appendShortTimeStr, long time) {
        Intrinsics.checkNotNullParameter((Object)$this$appendShortTimeStr, (String)"<this>");
        Instant instant = Instant.ofEpochMilli(time);
        LocalDateTime lt = instant.atZone(ZoneOffset.UTC).toLocalDateTime();
        StringFun.appendWithLeadingZeros((StringBuilder)$this$appendShortTimeStr, (int)lt.getHour(), (int)2);
        $this$appendShortTimeStr.append(':');
        StringFun.appendWithLeadingZeros((StringBuilder)$this$appendShortTimeStr, (int)lt.getMinute(), (int)2);
        $this$appendShortTimeStr.append(':');
        StringFun.appendWithLeadingZeros((StringBuilder)$this$appendShortTimeStr, (int)lt.getSecond(), (int)2);
    }

    @NotNull
    public static final String exportDateTimeStr(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        Intrinsics.checkNotNull((Object)instant);
        return CalendarFun.export((Instant)instant, (boolean)false);
    }

    public static final void closeSafely(@NotNull BufferedWriter $this$closeSafely) {
        Intrinsics.checkNotNullParameter((Object)$this$closeSafely, (String)"<this>");
        try {
            $this$closeSafely.close();
        }
        catch (Exception e) {
            System.err.println("Cannot close file!");
            e.printStackTrace();
        }
    }

    public static final void addStackTraceInto(@NotNull StringBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        b.append("\t-------- 8< -------------------------------------------------- stack trace -----").append('\n');
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNull((Object)trace);
        for (StackTraceElement e : trace) {
            Intrinsics.checkNotNull((Object)e);
            if (!DiagnosticMonitorInternals.whetherToPutTheStackEntryIntoTheLog(e)) continue;
            b.append("\tat ").append(e.getClassName()).append('.').append(e.getMethodName()).append(" (").append(e.getFileName()).append(':').append(e.getLineNumber()).append(")\n");
        }
        b.append("\t-------- >8 --------------------------------------------------------------------").append('\n');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean whetherToPutTheStackEntryIntoTheLog(StackTraceElement e) {
        if (e.isNativeMethod()) return false;
        if (e.getClassName() == null) return false;
        String string = e.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        if (StringsKt.startsWith$default((String)string, (String)"java.", (boolean)false, (int)2, null)) return false;
        String string2 = e.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"kotlin.", (boolean)false, (int)2, null)) return false;
        if (e.getFileName() == null) return false;
        if (filesToSkipInTrace.contains(e.getFileName())) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"DiagnosticMonitor.kt", "DiagnosticMonitorInternals.kt"};
        filesToSkipInTrace = SetsKt.setOf((Object[])objectArray);
    }
}

