/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.forest;

import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvArmKt;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForest;
import com.intellij.database.explorer.forest.DvForestGartner;
import com.intellij.database.explorer.forest.DvForestGartner$exportBushes$;
import com.intellij.database.explorer.forest.DvForestGartner$exportFolders$;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\"#B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0007J$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0012J3\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0012H\u0001\u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\u00020\u000e2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0010J\u0014\u0010 \u001a\u00020\u000e2\n\u0010!\u001a\u00060\u001ej\u0002`\u001fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/explorer/forest/DvForestGartner;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "", "forest", "Lcom/intellij/database/explorer/forest/DvForest;", "<init>", "(Lcom/intellij/database/explorer/forest/DvForest;)V", "getForest", "()Lcom/intellij/database/explorer/forest/DvForest;", "indexedFolders", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/database/explorer/forest/DvNiceFolder;", "importState", "", "text", "", "bushFinder", "Lkotlin/Function1;", "", "importFolders", "importFolder", "line", "importBushes", "importBush", "Lcom/intellij/database/explorer/forest/DvForestGartner$FoundBush;", "importBush$intellij_database_core_impl", "exportState", "exportFolders", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "exportBushes", "b", "Companion", "FoundBush", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestGartner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestGartner.kt\ncom/intellij/database/explorer/forest/DvForestGartner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,169:1\n23#2:170\n479#3:171\n479#3:172\n688#3:173\n719#3,4:174\n*S KotlinDebug\n*F\n+ 1 DvForestGartner.kt\ncom/intellij/database/explorer/forest/DvForestGartner\n*L\n22#1:170\n120#1:171\n142#1:172\n70#1:173\n70#1:174,4\n*E\n"})
public final class DvForestGartner<B extends BasicUniqueBush> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DvForest<B> forest;
    @NotNull
    private final Int2ObjectOpenHashMap<DvNiceFolder> indexedFolders;
    @NotNull
    private static final Regex folderTemplate = com.intellij.database.explorer.forest.DvForestGartner$Companion.access$regexWithSpaces(Companion, "^ (\\d+) : (\\d+) : ([^\\s:]|[^\\s:][^:]*[^\\s:]) (: (.*))? $");
    @NotNull
    private static final Regex bushTemplate = com.intellij.database.explorer.forest.DvForestGartner$Companion.access$regexWithSpaces(Companion, "^ (\\d+) : (\\d+) : ([\\p{Alpha}\\d\\-]+) $");
    @NotNull
    private static final Regex separatorTemplate = com.intellij.database.explorer.forest.DvForestGartner$Companion.access$regexWithSpaces(Companion, "^ -{8,} $");

    public DvForestGartner(@NotNull DvForest<B> forest) {
        Intrinsics.checkNotNullParameter(forest, (String)"forest");
        this.forest = forest;
        this.indexedFolders = new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final DvForest<B> getForest() {
        return this.forest;
    }

    public final void importState(@NotNull CharSequence text2, @NotNull Function1<? super String, ? extends B> bushFinder) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(bushFinder, (String)"bushFinder");
        MatchResult m = Regex.find$default((Regex)separatorTemplate, (CharSequence)text2, (int)0, (int)2, null);
        if (m == null) {
            DvForestGartner $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(DvForestGartner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("The separator line is missing in the state text");
            return;
        }
        int p1 = m.getRange().getFirst();
        int p2 = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)m.getRange().getLast(), (boolean)false, (int)4, null);
        CharSequence text1 = text2.subSequence(0, p1);
        CharSequence text22 = text2.subSequence(p2 + 1, text2.length());
        DvForest.modifyTree$default(this.forest, false, () -> DvForestGartner.importState$lambda$0(this, text1, text22, bushFinder), 1, null);
    }

    public final void importFolders(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{'\n'};
        Sequence lines2 = SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Function1)importFolders.lines.1.INSTANCE);
        DvForest.modifyTree$default(this.forest, false, () -> DvForestGartner.importFolders$lambda$0(lines2, this), 1, null);
    }

    @ApiStatus.Internal
    public final void importFolder(@NotNull CharSequence line) {
        DvFolder dvFolder;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult m = StringFun.match((CharSequence)line, (Regex)folderTemplate);
        if (m == null) {
            return;
        }
        int folderId = Integer.parseInt((String)m.getGroupValues().get(1));
        int parentId = Integer.parseInt((String)m.getGroupValues().get(2));
        String folderName = (String)m.getGroupValues().get(3);
        if (parentId == 0) {
            dvFolder = this.forest.getRoot();
        } else {
            DvNiceFolder dvNiceFolder = (DvNiceFolder)this.indexedFolders.get(parentId);
            dvFolder = dvNiceFolder != null ? (DvFolder)dvNiceFolder : (DvFolder)this.forest.getRoot();
        }
        DvFolder parentFolder = dvFolder;
        DvNiceFolder folder = parentFolder.createNewInnerFolder(folderId, folderName);
        ((Map)this.indexedFolders).put(folderId, folder);
    }

    public final void importBushes(@NotNull CharSequence text2, @NotNull Function1<? super String, ? extends B> bushFinder) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(bushFinder, (String)"bushFinder");
        char[] cArray = new char[]{'\n'};
        Sequence lines2 = SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Function1)importBushes.lines.1.INSTANCE);
        DvForest.modifyTree$default(this.forest, false, () -> DvForestGartner.importBushes$lambda$0(this, lines2, bushFinder), 1, null);
    }

    @ApiStatus.Internal
    @Nullable
    public final FoundBush<B> importBush$intellij_database_core_impl(@NotNull CharSequence line, @NotNull Function1<? super String, ? extends B> bushFinder) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter(bushFinder, (String)"bushFinder");
        MatchResult m = StringFun.match((CharSequence)line, (Regex)bushTemplate);
        if (m == null) {
            return null;
        }
        int bushId = Integer.parseInt((String)m.getGroupValues().get(1));
        int parentId = Integer.parseInt((String)m.getGroupValues().get(2));
        String bushUniqueId = (String)m.getGroupValues().get(3);
        BasicUniqueBush bush = (BasicUniqueBush)bushFinder.invoke((Object)bushUniqueId);
        if (bush == null) {
            return null;
        }
        return new FoundBush<BasicUniqueBush>(bushId, parentId, bush);
    }

    @NotNull
    public final String exportState() {
        if (this.forest.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        this.exportFolders(b);
        b.append("----------------------------------------").append('\n');
        this.exportBushes(b);
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final CharSequence exportFolders() {
        StringBuilder b = new StringBuilder();
        this.forest.readTree(() -> DvForestGartner.exportFolders$lambda$0(this, b));
        return b;
    }

    private final void exportFolders(StringBuilder buf) {
        Sequence<DvArm> $this$filterIsInstance$iv = this.forest.getRoot().traversAll();
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)exportFolders$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence folders = sequence;
        for (DvNiceFolder f : folders) {
            int orderId = f.getOrderId();
            int parentId = DvArmKt.getParentOrderId(f);
            StringBuilder stringBuilder = buf.append(orderId).append(":").append(parentId).append(":").append(f.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append('\n');
        }
    }

    @NotNull
    public final CharSequence exportBushes() {
        StringBuilder b = new StringBuilder(this.forest.getBushRefCount() * 46);
        this.forest.readTree(() -> DvForestGartner.exportBushes$lambda$0(this, b));
        return b;
    }

    private final void exportBushes(StringBuilder b) {
        Sequence<DvArm> $this$filterIsInstance$iv = this.forest.getRoot().traversAll();
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)exportBushes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence bushRefs = sequence;
        for (DvBushRef br : bushRefs) {
            Object bush;
            if (br.getBush() == null) continue;
            StringBuilder stringBuilder = b.append(br.getOrderId()).append(':').append(DvArmKt.getParentOrderId(br)).append(':').append(bush.getUniqueId());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append('\n');
        }
    }

    private static final Unit importState$lambda$0(DvForestGartner this$0, CharSequence $text1, CharSequence $text2, Function1 $bushFinder) {
        this$0.forest.clearAll$intellij_database_core_impl();
        this$0.importFolders($text1);
        this$0.importBushes($text2, $bushFinder);
        return Unit.INSTANCE;
    }

    private static final Unit importFolders$lambda$0(Sequence $lines, DvForestGartner this$0) {
        for (String line : $lines) {
            this$0.importFolder(line);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit importBushes$lambda$0(DvForestGartner this$0, Sequence $lines, Function1 $bushFinder) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Sequence<DvFolder> sequence = this$0.forest.getRoot().traversFolders();
        boolean $i$f$associateBy = false;
        void var6_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            DvFolder dvFolder = (DvFolder)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(p0.getOrderId(), element$iv$iv);
        }
        Map folders = destination$iv$iv;
        for (String line : $lines) {
            FoundBush foundBush;
            if (this$0.importBush$intellij_database_core_impl(line, $bushFinder) == null || this$0.forest.isBushRegistered(foundBush.getBush())) continue;
            DvFolder dvFolder = (DvFolder)folders.get(foundBush.getParentId());
            if (dvFolder == null) {
                dvFolder = this$0.forest.getRoot();
            }
            DvFolder folder = dvFolder;
            folder.createNewInnerBush(foundBush.getOrderId(), foundBush.getBush());
        }
        return Unit.INSTANCE;
    }

    private static final Unit exportFolders$lambda$0(DvForestGartner this$0, StringBuilder $b) {
        this$0.exportFolders($b);
        return Unit.INSTANCE;
    }

    private static final Unit exportBushes$lambda$0(DvForestGartner this$0, StringBuilder $b) {
        this$0.exportBushes($b);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\u00052\b\b\u0001\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/explorer/forest/DvForestGartner$Companion;", "", "<init>", "()V", "folderTemplate", "Lkotlin/text/Regex;", "bushTemplate", "separatorTemplate", "regexWithSpaces", "pattern", "", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex regexWithSpaces(@Language(value="RegExp") String pattern) {
            return new Regex(StringsKt.replace$default((String)pattern, (String)" ", (String)"\\s*", (boolean)false, (int)4, null), RegexOption.MULTILINE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Regex access$regexWithSpaces(Companion $this, String pattern) {
            return $this.regexWithSpaces(pattern);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0007\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/explorer/forest/DvForestGartner$FoundBush;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "", "orderId", "", "parentId", "bush", "<init>", "(IILcom/intellij/database/model/basic/BasicUniqueBush;)V", "getOrderId", "()I", "getParentId", "getBush", "()Lcom/intellij/database/model/basic/BasicUniqueBush;", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "intellij.database.core.impl"})
    @ApiStatus.Internal
    public static final class FoundBush<B extends BasicUniqueBush> {
        private final int orderId;
        private final int parentId;
        @NotNull
        private final B bush;

        public FoundBush(int orderId, int parentId, @NotNull B bush) {
            Intrinsics.checkNotNullParameter(bush, (String)"bush");
            this.orderId = orderId;
            this.parentId = parentId;
            this.bush = bush;
        }

        public final int getOrderId() {
            return this.orderId;
        }

        public final int getParentId() {
            return this.parentId;
        }

        @NotNull
        public final B getBush() {
            return this.bush;
        }
    }
}

