/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.Dbms;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.structure.DvDsGroup;
import com.intellij.database.explorer.structure.DvHostNode;
import com.intellij.database.explorer.structure.DvTreeAbstractLayer;
import com.intellij.database.explorer.structure.DvTreeFilesLayer;
import com.intellij.database.explorer.structure.DvTreeInternalFunKt;
import com.intellij.database.explorer.structure.DvTreeLayer;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001FB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J\r\u0010'\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0010\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0010\u00a2\u0006\u0002\b.J)\u0010/\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101H\u0010\u00a2\u0006\u0002\b3J!\u00104\u001a\u00020\u0010*\u00020\u000b2\b\u00105\u001a\u0004\u0018\u0001012\b\u00106\u001a\u0004\u0018\u000101H\u0082\bJ\u0015\u00107\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0010\u00a2\u0006\u0002\b8J\u001d\u00109\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u00020;H\u0010\u00a2\u0006\u0002\b<J\u001b\u0010=\u001a\u00020\u00162\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0010\u00a2\u0006\u0002\bAJ\r\u0010B\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020\u0016H\u0002J\b\u0010E\u001a\u00020\u0016H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeCacheLayer;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/explorer/structure/DvTreeCacheLayer$NodeStuff;", "specialCountCache", "", "cacheEnabled", "", "alwaysInvalidateAll", "skipDataSources", "knownModificationCount", "", "setup", "", "base", "Lcom/intellij/database/explorer/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "getStuff", "node", "peekStuff", "obtainStuff", "parentOf", "childrenOf", "Lkotlin/sequences/Sequence;", "countRealChildrenOf", "isAlwaysLeaf", "presentableNameOf", "skip", "toCacheCountSpecially", "checkOptionsModification", "onFoldersChanged", "onFoldersChanged$intellij_database_core_impl", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "inModel", "model1", "model2", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "onFileChanged", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileChanged$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "clearCache", "clearAll", "NodeStuff", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeCacheLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeCacheLayer.kt\ncom/intellij/database/explorer/structure/DvTreeCacheLayer\n*L\n1#1,218:1\n163#1,2:219\n163#1,2:221\n*S KotlinDebug\n*F\n+ 1 DvTreeCacheLayer.kt\ncom/intellij/database/explorer/structure/DvTreeCacheLayer\n*L\n151#1:219,2\n157#1:221,2\n*E\n"})
public final class DvTreeCacheLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final Cache<BasicNode, NodeStuff> cache;
    @NotNull
    private final Cache<BasicNode, Integer> specialCountCache;
    private final boolean cacheEnabled;
    private final boolean alwaysInvalidateAll;
    private final boolean skipDataSources;
    private volatile long knownModificationCount;

    public DvTreeCacheLayer() {
        Cache cache2 = Caffeine.newBuilder().initialCapacity(256).expireAfterAccess(60L, TimeUnit.SECONDS).maximumSize(256L).weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.cache = cache2;
        Cache cache3 = Caffeine.newBuilder().initialCapacity(1024).weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.specialCountCache = cache3;
        this.cacheEnabled = Registry.Companion.is("database.view.layers.cache.enable");
        this.alwaysInvalidateAll = Registry.Companion.is("database.view.layers.cache.alwaysInvalidateAll");
        this.skipDataSources = Registry.Companion.is("database.view.layers.cache.skipDataSources");
    }

    @Override
    @NotNull
    protected String getName() {
        return "Cache";
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.knownModificationCount = this.getVo().getModificationCount();
        this.clearCache();
    }

    private final NodeStuff getStuff(BasicNode node) {
        this.checkOptionsModification();
        Object object = this.cache.get((Object)node, arg_0 -> DvTreeCacheLayer.getStuff$lambda$0((Function1)new Function1<BasicNode, NodeStuff>((Object)this){

            public final NodeStuff invoke(BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DvTreeCacheLayer.access$obtainStuff((DvTreeCacheLayer)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        NodeStuff stuff2 = (NodeStuff)object;
        return stuff2;
    }

    private final NodeStuff peekStuff(BasicNode node) {
        this.checkOptionsModification();
        NodeStuff stuff2 = (NodeStuff)this.cache.getIfPresent((Object)node);
        return stuff2;
    }

    private final NodeStuff obtainStuff(BasicNode node) {
        BasicNode parent = this.getBase().parentOf(node);
        boolean alwaysLeaf = this.getBase().isAlwaysLeaf(node);
        List children = !alwaysLeaf ? SequencesKt.toList(this.getBase().childrenOf(node)) : CollectionsKt.emptyList();
        String presentableName = this.getBase().presentableNameOf(node);
        return new NodeStuff(parent, children, alwaysLeaf, presentableName);
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.skip(node) ? this.getBase().parentOf(node) : this.getStuff(node).getParent();
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.skip(node) ? this.getBase().childrenOf(node) : (Sequence)SequenceFun.asSequence((Collection)this.getStuff(node).getChildren());
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.skip(node)) {
            return this.getBase().countRealChildrenOf(node);
        }
        NodeStuff alreadyCachedStuff = this.peekStuff(node);
        NodeStuff nodeStuff = alreadyCachedStuff;
        if (nodeStuff != null) {
            return ((Collection)nodeStuff.getChildren()).size();
        }
        if (this.toCacheCountSpecially(node)) {
            Object object = this.specialCountCache.get((Object)node, arg_0 -> DvTreeCacheLayer.countRealChildrenOf$lambda$0((Function1)new Function1<BasicNode, Integer>((Object)this.getBase()){

                public final Integer invoke(BasicNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DvTreeLayer)this.receiver).countRealChildrenOf(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }
        return this.getBase().countRealChildrenOf(node);
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.skip(node) ? this.getBase().isAlwaysLeaf(node) : this.getStuff(node).getAlwaysLeaf();
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.skip(node)) {
            return this.getBase().presentableNameOf(node);
        }
        NodeStuff cachedStuff = this.peekStuff(node);
        if (cachedStuff != null) {
            return cachedStuff.getPresentableName();
        }
        return this.getBase().presentableNameOf(node);
    }

    private final boolean skip(BasicNode node) {
        return !this.cacheEnabled || this.skipDataSources && node instanceof DataSourceNode;
    }

    private final boolean toCacheCountSpecially(BasicNode node) {
        return node instanceof DataSourceNode || node instanceof BasicNamespace || node instanceof HostFamily && ((HostFamily)node).getHost() instanceof BasicSchema || node instanceof DvHostNode && ((DvHostNode)node).host instanceof BasicSchema;
    }

    private final void checkOptionsModification() {
        long mc = this.getVo().getModificationCount();
        if (mc != this.knownModificationCount) {
            this.clearCache();
            this.knownModificationCount = mc;
        }
    }

    @Override
    public void onFoldersChanged$intellij_database_core_impl() {
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, DvTreeCacheLayer::onFoldersChanged$lambda$0);
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, DvTreeCacheLayer::onDataSourceAdded$lambda$0);
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, DvTreeCacheLayer::onDataSourcePathChanged$lambda$0);
    }

    @Override
    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, arg_0 -> DvTreeCacheLayer.onDataSourceModelReplaced$lambda$0(dataSource, this, oldModel, newModel, arg_0));
        DvTreeInternalFunKt.invalidateThat(this.specialCountCache, arg_0 -> DvTreeCacheLayer.onDataSourceModelReplaced$lambda$1(dataSource, this, oldModel, newModel, arg_0));
    }

    private final boolean inModel(BasicNode $this$inModel, BasicModel model1, BasicModel model2) {
        boolean $i$f$inModel = false;
        BasicModel m = $this$inModel.getModel();
        return Intrinsics.areEqual((Object)m, (Object)model1) || Intrinsics.areEqual((Object)m, (Object)model2);
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        BasicModel model;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DasModel dasModel = dataSource.getModel();
        BasicModel basicModel = model = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (model != null) {
            DvTreeInternalFunKt.invalidateThat(this.cache, arg_0 -> DvTreeCacheLayer.onDataSourceChanged$lambda$0(dataSource, model, arg_0));
            DvTreeInternalFunKt.invalidateThat(this.specialCountCache, arg_0 -> DvTreeCacheLayer.onDataSourceChanged$lambda$1(dataSource, model, arg_0));
        } else {
            DvTreeInternalFunKt.invalidateThat(this.cache, arg_0 -> DvTreeCacheLayer.onDataSourceChanged$lambda$2(dataSource, arg_0));
            DvTreeInternalFunKt.invalidateThat(this.specialCountCache, arg_0 -> DvTreeCacheLayer.onDataSourceChanged$lambda$3(dataSource, arg_0));
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.clearCache();
    }

    @Override
    public void onFileChanged$intellij_database_core_impl(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        if (this.alwaysInvalidateAll) {
            this.clearCache();
            return;
        }
        DvTreeInternalFunKt.invalidateThat(this.cache, arg_0 -> DvTreeCacheLayer.onFileChanged$lambda$0(virtualFiles, arg_0));
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        this.clearCache();
    }

    private final void clearCache() {
        this.cache.invalidateAll();
        this.specialCountCache.invalidateAll();
    }

    @Override
    public void clearAll() {
        this.clearCache();
    }

    private static final NodeStuff getStuff$lambda$0(Function1 $tmp0, Object p0) {
        return (NodeStuff)$tmp0.invoke(p0);
    }

    private static final Integer countRealChildrenOf$lambda$0(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final boolean onFoldersChanged$lambda$0(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DvFolder || it instanceof DvDsGroup || it instanceof DataSourceNode;
    }

    private static final boolean onDataSourceAdded$lambda$0(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DvFolder || it instanceof DvDsGroup;
    }

    private static final boolean onDataSourcePathChanged$lambda$0(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DvFolder || it instanceof DvDsGroup;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean onDataSourceModelReplaced$lambda$0(RawDataSource $dataSource, DvTreeCacheLayer this$0, BasicModel $oldModel, BasicModel $newModel, BasicNode it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof DataSourceNode) {
            bl = Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource);
        } else {
            void model1$iv;
            void $this$inModel$iv;
            DvTreeCacheLayer dvTreeCacheLayer = this$0;
            BasicNode basicNode = it;
            BasicModel basicModel = $oldModel;
            BasicModel model2$iv = $newModel;
            boolean $i$f$inModel = false;
            BasicModel m$iv = $this$inModel$iv.getModel();
            bl = Intrinsics.areEqual((Object)m$iv, (Object)model1$iv) || Intrinsics.areEqual((Object)m$iv, (Object)model2$iv);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean onDataSourceModelReplaced$lambda$1(RawDataSource $dataSource, DvTreeCacheLayer this$0, BasicModel $oldModel, BasicModel $newModel, BasicNode it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof DataSourceNode) {
            bl = Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource);
        } else {
            void model1$iv;
            void $this$inModel$iv;
            DvTreeCacheLayer dvTreeCacheLayer = this$0;
            BasicNode basicNode = it;
            BasicModel basicModel = $oldModel;
            BasicModel model2$iv = $newModel;
            boolean $i$f$inModel = false;
            BasicModel m$iv = $this$inModel$iv.getModel();
            bl = Intrinsics.areEqual((Object)m$iv, (Object)model1$iv) || Intrinsics.areEqual((Object)m$iv, (Object)model2$iv);
        }
        return bl;
    }

    private static final boolean onDataSourceChanged$lambda$0(RawDataSource $dataSource, BasicModel $model, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DataSourceNode ? Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource) : Intrinsics.areEqual((Object)it.getModel(), (Object)$model);
    }

    private static final boolean onDataSourceChanged$lambda$1(RawDataSource $dataSource, BasicModel $model, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DataSourceNode ? Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource) : Intrinsics.areEqual((Object)it.getModel(), (Object)$model);
    }

    private static final boolean onDataSourceChanged$lambda$2(RawDataSource $dataSource, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DataSourceNode && Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource);
    }

    private static final boolean onDataSourceChanged$lambda$3(RawDataSource $dataSource, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DataSourceNode && Intrinsics.areEqual((Object)((DataSourceNode)it).dataSource, (Object)$dataSource);
    }

    private static final boolean onFileChanged$lambda$0(Collection $virtualFiles, BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvTreeFilesLayer.QueryFile ? $virtualFiles.contains(((DvTreeFilesLayer.QueryFile)node).getVirtualFile()) : false;
    }

    public static final /* synthetic */ NodeStuff access$obtainStuff(DvTreeCacheLayer $this, BasicNode node) {
        return $this.obtainStuff(node);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeCacheLayer$NodeStuff;", "", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "children", "", "alwaysLeaf", "", "presentableName", "", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/util/List;ZLjava/lang/String;)V", "getParent", "()Lcom/intellij/database/model/basic/BasicNode;", "getChildren", "()Ljava/util/List;", "getAlwaysLeaf", "()Z", "getPresentableName", "()Ljava/lang/String;", "intellij.database.core.impl"})
    private static final class NodeStuff {
        @Nullable
        private final BasicNode parent;
        @NotNull
        private final List<BasicNode> children;
        private final boolean alwaysLeaf;
        @NotNull
        private final String presentableName;

        public NodeStuff(@Nullable BasicNode parent, @NotNull List<? extends BasicNode> children, boolean alwaysLeaf, @NotNull String presentableName) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
            this.parent = parent;
            this.children = children;
            this.alwaysLeaf = alwaysLeaf;
            this.presentableName = presentableName;
        }

        @Nullable
        public final BasicNode getParent() {
            return this.parent;
        }

        @NotNull
        public final List<BasicNode> getChildren() {
            return this.children;
        }

        public final boolean getAlwaysLeaf() {
            return this.alwaysLeaf;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }
    }
}

