/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.database.settings.DatabaseSettings;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016J\r\u0010 \u001a\u00070\u0019\u00a2\u0006\u0002\b!H\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/database/extractors/GeoWrapperFormatter;", "Lcom/intellij/database/run/ui/grid/editors/FormatterImpl;", "myDbms", "Lcom/intellij/database/Dbms;", "column", "Lcom/intellij/database/datagrid/GridColumn;", "objectFormatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "<init>", "(Lcom/intellij/database/Dbms;Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/database/extractors/ObjectFormatter;)V", "getMyDbms", "()Lcom/intellij/database/Dbms;", "setMyDbms", "(Lcom/intellij/database/Dbms;)V", "getColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "setColumn", "(Lcom/intellij/database/datagrid/GridColumn;)V", "getObjectFormatter", "()Lcom/intellij/database/extractors/ObjectFormatter;", "setObjectFormatter", "(Lcom/intellij/database/extractors/ObjectFormatter;)V", "parse", "", "value", "", "position", "Ljava/text/ParsePosition;", "parseHexString", "", "hex", "format", "getErrorMessage", "Lorg/jetbrains/annotations/Nls;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nGeoWrapperFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoWrapperFormatter.kt\ncom/intellij/database/extractors/GeoWrapperFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1586#2:54\n1661#2,3:55\n*S KotlinDebug\n*F\n+ 1 GeoWrapperFormatter.kt\ncom/intellij/database/extractors/GeoWrapperFormatter\n*L\n38#1:54\n38#1:55,3\n*E\n"})
public final class GeoWrapperFormatter
extends FormatterImpl {
    @NotNull
    private Dbms myDbms;
    @NotNull
    private GridColumn column;
    @NotNull
    private ObjectFormatter objectFormatter;

    public GeoWrapperFormatter(@NotNull Dbms myDbms, @NotNull GridColumn column, @NotNull ObjectFormatter objectFormatter) {
        Intrinsics.checkNotNullParameter((Object)myDbms, (String)"myDbms");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)objectFormatter, (String)"objectFormatter");
        this.myDbms = myDbms;
        this.column = column;
        this.objectFormatter = objectFormatter;
    }

    @NotNull
    public final Dbms getMyDbms() {
        return this.myDbms;
    }

    public final void setMyDbms(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"<set-?>");
        this.myDbms = dbms;
    }

    @NotNull
    public final GridColumn getColumn() {
        return this.column;
    }

    public final void setColumn(@NotNull GridColumn gridColumn) {
        Intrinsics.checkNotNullParameter((Object)gridColumn, (String)"<set-?>");
        this.column = gridColumn;
    }

    @NotNull
    public final ObjectFormatter getObjectFormatter() {
        return this.objectFormatter;
    }

    public final void setObjectFormatter(@NotNull ObjectFormatter objectFormatter) {
        Intrinsics.checkNotNullParameter((Object)objectFormatter, (String)"<set-?>");
        this.objectFormatter = objectFormatter;
    }

    @NotNull
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        GeoHelper geoHelper = (GeoHelper)GeoHelper.EP.forDbms(this.myDbms);
        boolean isShowGeoAsBinary = DatabaseSettings.getSettings().isShowGeoAsBinary();
        position.setIndex(value.length());
        if (isShowGeoAsBinary) {
            byte[] byArray;
            try {
                byArray = this.parseHexString(value);
            }
            catch (Exception e) {
                byArray = geoHelper.extractBinaryFromWkt(value, 0);
            }
            serializable = (Serializable)byArray;
        } else {
            byte[] binary = geoHelper.extractBinaryFromWkt(value, 0);
            serializable = (Serializable)new GeoWrapper(binary, value);
        }
        Serializable serializable2 = serializable;
        Intrinsics.checkNotNull((Object)serializable2);
        return serializable2;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] parseHexString(String hex) {
        void $this$mapTo$iv$iv;
        Regex regex = new Regex("\\s");
        CharSequence charSequence = hex;
        Object object = "";
        String cleanHex = StringsKt.removePrefix((String)StringsKt.removePrefix((String)regex.replace(charSequence, (String)object), (CharSequence)"0x"), (CharSequence)"\\x");
        if (cleanHex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have even length");
        }
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)cleanHex, (int)2);
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    @Nullable
    public String format(@Nullable Object value) {
        if (value instanceof GeoWrapper) {
            return this.objectFormatter.objectToString(value, this.column, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.DISPLAY));
        }
        return value instanceof ReservedCellValue ? "" : String.valueOf(value);
    }

    @NotNull
    protected String getErrorMessage() {
        String string = DataGridBundle.message((String)"unexpected.data.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

