/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicAuxiliaryElement;
import com.intellij.database.model.basic.BasicDetailElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicMultiLevelDatabase;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.util.common.MapFun;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0002JH\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0$0$2\u0006\u0010&\u001a\u00020\u001cH\u0014J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0019H\u0016J\b\u0010+\u001a\u00020\u0019H\u0014J\b\u0010,\u001a\u00020\u0019H\u0014J\b\u0010-\u001a\u00020\u0019H\u0014J\b\u0010.\u001a\u00020\u0019H\u0014J\b\u0010/\u001a\u00020\u0019H\u0014J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u001eH\u0014J\b\u00102\u001a\u00020\u0019H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/model/BaseLevelAnalyzer;", "Lcom/intellij/database/model/LevelAnalyzer;", "dsId", "", "<init>", "(Ljava/lang/String;)V", "levelObjects", "Ljava/util/HashSet;", "Lcom/intellij/database/model/basic/BasicMultiLevelObject;", "Lkotlin/collections/HashSet;", "explicitSchemas", "Lcom/intellij/database/model/basic/BasicSchema;", "addElementsToAnalysis", "", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "addElementToAnalysis", "element", "appendElementToAnalysis", "requestedElement", "appendLevelObject", "levelObject", "handleUnexpectedElement", "analyzeContent", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "checker", "Lkotlin/Function1;", "Lcom/intellij/database/model/properties/Level;", "decideWhetherToElevateWholeSchema", "", "schema", "schemaLevelChildrenCount", "", "poorObjectCount", "groups", "", "Lcom/intellij/database/model/ObjectKind;", "maxRequiredLevel", "analyzeForScripting", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "analyzeForAllDetailsAccessing", "analyzeForExecuting", "analyzeForScriptingNativeDefinitions", "analyzeForScriptingEnableDisable", "analyzeForScriptingRecompile", "analyzeForScriptingRefresh", "analyzeForScriptingDeleteAllData", "truncate", "analyzeForScriptingDrop", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nBaseLevelAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseLevelAnalyzer.kt\ncom/intellij/database/model/BaseLevelAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,214:1\n1#2:215\n1512#3:216\n1538#3,3:217\n1541#3,3:227\n812#3,12:230\n2829#3,7:242\n1586#3:249\n1661#3,3:250\n383#4,7:220\n*S KotlinDebug\n*F\n+ 1 BaseLevelAnalyzer.kt\ncom/intellij/database/model/BaseLevelAnalyzer\n*L\n84#1:216\n84#1:217,3\n84#1:227,3\n95#1:230,12\n120#1:242,7\n141#1:249\n141#1:250,3\n84#1:220,7\n*E\n"})
public class BaseLevelAnalyzer
implements LevelAnalyzer {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final String dsId;
    @NotNull
    private final HashSet<BasicMultiLevelObject> levelObjects;
    @NotNull
    private final HashSet<BasicSchema> explicitSchemas;

    public BaseLevelAnalyzer(@NotNull String dsId) {
        Intrinsics.checkNotNullParameter((Object)dsId, (String)"dsId");
        this.dsId = dsId;
        this.levelObjects = new HashSet();
        this.explicitSchemas = new HashSet();
    }

    @Override
    public void addElementsToAnalysis(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (BasicElement basicElement : elements) {
            this.addElementToAnalysis(basicElement);
        }
    }

    @Override
    public void addElementToAnalysis(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.appendElementToAnalysis(element, element);
    }

    public void appendElementToAnalysis(@NotNull BasicElement requestedElement, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)requestedElement, (String)"requestedElement");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicMultiLevelObject) {
            this.appendLevelObject((BasicMultiLevelObject)element);
        } else if (basicElement instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)element).getMajorObject();
            if (basicMajorObject != null) {
                BasicMajorObject it = basicMajorObject;
                boolean bl = false;
                this.appendElementToAnalysis(requestedElement, it);
            } else {
                this.handleUnexpectedElement(requestedElement, element);
            }
        } else if (basicElement instanceof BasicDetailElement) {
            BasicMajorObject basicMajorObject = ((BasicDetailElement)element).getMajorObject();
            if (basicMajorObject != null) {
                BasicMajorObject it = basicMajorObject;
                boolean bl = false;
                this.appendElementToAnalysis(requestedElement, it);
            } else {
                this.handleUnexpectedElement(requestedElement, element);
            }
        } else if (!(basicElement instanceof BasicMultiLevelDatabase)) {
            if (basicElement instanceof BasicSchema) {
                ((Collection)this.explicitSchemas).add(element);
            } else if (!(basicElement instanceof BasicAuxiliaryElement) && basicElement instanceof BasicNamespaceOwner) {
                this.handleUnexpectedElement(requestedElement, element);
            }
        }
    }

    private final void appendLevelObject(BasicMultiLevelObject levelObject) {
        boolean bl;
        boolean bl2 = bl = levelObject.getSchema() != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Every level object must be attached to a schema, but this one is not: " + levelObject;
            throw new AssertionError((Object)string);
        }
        ((Collection)this.levelObjects).add(levelObject);
    }

    private final void handleUnexpectedElement(BasicElement requestedElement, BasicElement element) {
        String msg = "Analyzing of this element (" + requestedElement + ") is not supported";
        if (!Intrinsics.areEqual((Object)requestedElement, (Object)element)) {
            msg = msg + " (checked element was " + element + ")";
        }
        throw new IllegalArgumentException(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final LevelAnalyzer.Recommendation analyzeContent(Function1<? super BasicMultiLevelObject, ? extends Level> checker) {
        Object poorObjects;
        Iterable key$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.levelObjects;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            BasicMultiLevelObject it = (BasicMultiLevelObject)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getSchema());
            Object object2 = destination$iv$iv;
            BasicSchema key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object v = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (v == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = v;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map schemaLevelObjects = destination$iv$iv;
        Set involvedSchemas = new HashSet(this.explicitSchemas);
        involvedSchemas.addAll(schemaLevelObjects.keySet());
        HashMap schemasToElevate = new HashMap();
        ArrayList fragmentTasks = new ArrayList(2);
        for (BasicSchema schema : involvedSchemas) {
            List exactlyRequestedObjects;
            void $this$filterIsInstanceTo$iv$iv;
            poorObjects = new HashMap();
            JBIterable jBIterable = schema.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getChildren(...)");
            Iterable $this$filterIsInstance$iv = (Iterable)jBIterable;
            boolean $i$f$filterIsInstance = false;
            key$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object t : $this$filterIsInstanceTo$iv$iv) {
                if (!(t instanceof BasicMultiLevelObject)) continue;
                destination$iv$iv2.add(t);
            }
            List children = (List)destination$iv$iv2;
            int childrenCount = ((Collection)children).size();
            if (childrenCount == 0) continue;
            if (this.explicitSchemas.contains(schema)) {
                for (Object c2 : children) {
                    Level req = (Level)((Object)checker.invoke(c2));
                    if (req == null || req.compareTo((Enum)Level.L2) < 0) continue;
                    ((Map)poorObjects).put(c2, req);
                }
            }
            if ((exactlyRequestedObjects = (List)schemaLevelObjects.get(schema)) != null) {
                Object c2;
                c2 = exactlyRequestedObjects.iterator();
                while (c2.hasNext()) {
                    BasicMultiLevelObject o = (BasicMultiLevelObject)c2.next();
                    Level req = (Level)((Object)checker.invoke((Object)o));
                    if (req == null || req.compareTo((Enum)Level.L2) < 0) continue;
                    ((HashMap)poorObjects).merge(o, req, (arg_0, arg_1) -> BaseLevelAnalyzer.analyzeContent$lambda$2(BaseLevelAnalyzer::analyzeContent$lambda$1, arg_0, arg_1));
                }
            }
            if (((HashMap)poorObjects).isEmpty()) continue;
            Map groups = MapFun.groupKeysBy((Map)((Map)poorObjects), BaseLevelAnalyzer::analyzeContent$lambda$3);
            Collection collection = ((HashMap)poorObjects).values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$reduce$iv = collection;
            boolean bl = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void lvB;
                Level level = (Level)((Object)iterator$iv.next());
                Level lvA = (Level)((Object)accumulator$iv);
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)((Object)lvA));
                Intrinsics.checkNotNull((Object)lvB);
                accumulator$iv = Companion.greater(lvA, (Level)lvB);
            }
            Object t = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"reduce(...)");
            Level maxLevel = (Level)((Object)t);
            boolean whole = this.decideWhetherToElevateWholeSchema(schema, childrenCount, ((HashMap)poorObjects).size(), groups, maxLevel);
            if (whole) {
                ((Map)schemasToElevate).put(schema, maxLevel);
                continue;
            }
            for (Map.Entry entry : groups.entrySet()) {
                ObjectKind kind = (ObjectKind)entry.getKey();
                Map objects = (Map)entry.getValue();
                SortedSet names = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)objects.keySet()), BaseLevelAnalyzer::analyzeContent$lambda$5));
                Collection collection2 = fragmentTasks;
                String string = IntrospectionTasks.getDatabaseScopeName(schema);
                String string2 = schema.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                collection2.add(IntrospectionTasks.prepareSchemaFragmentTask(this.dsId, string, string2, kind, names, false, true));
            }
        }
        ArrayList tasks = new ArrayList();
        if (!((Map)schemasToElevate).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            poorObjects = MapFun.groupKeysBy((Map)schemasToElevate, BaseLevelAnalyzer::analyzeContent$lambda$6).entrySet();
            boolean $i$f$map = false;
            void childrenCount = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry $this$reduce$iv = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(IntrospectionTasks.prepareElevationTask(this.dsId, (String)it.getKey(), (Map)it.getValue()));
            }
            List elevationTasks = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)tasks, (Iterable)elevationTasks);
        }
        if (!((Collection)fragmentTasks).isEmpty()) {
            CollectionsKt.addAll((Collection)tasks, (Iterable)fragmentTasks);
        }
        return !((Collection)tasks).isEmpty() ? new LevelAnalyzer.Recommendation(tasks) : LevelAnalyzer.Recommendation.nothing;
    }

    protected boolean decideWhetherToElevateWholeSchema(@NotNull BasicSchema schema, int schemaLevelChildrenCount, int poorObjectCount, @NotNull Map<ObjectKind, ? extends Map<BasicMultiLevelObject, ? extends Level>> groups, @NotNull Level maxRequiredLevel) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)((Object)maxRequiredLevel), (String)"maxRequiredLevel");
        return switch (WhenMappings.$EnumSwitchMapping$0[maxRequiredLevel.ordinal()]) {
            case 1 -> {
                if (groups.size() > 4 || poorObjectCount * 5 > schemaLevelChildrenCount) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (groups.size() > 6 || poorObjectCount * 3 > schemaLevelChildrenCount) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    @NotNull
    public LevelAnalyzer.Recommendation analyzeForScripting(@NotNull ScriptCategory category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        return switch (WhenMappings.$EnumSwitchMapping$1[category.ordinal()]) {
            case 1, 2, 3, 4 -> this.analyzeForAllDetailsAccessing();
            case 5 -> this.analyzeForScriptingNativeDefinitions();
            case 6 -> this.analyzeForAllDetailsAccessing();
            case 7, 8 -> this.analyzeForScriptingEnableDisable();
            case 9 -> this.analyzeForScriptingRecompile();
            case 10 -> this.analyzeForScriptingRefresh();
            case 11 -> this.analyzeForExecuting();
            case 12 -> this.analyzeForScriptingDeleteAllData(false);
            case 13 -> this.analyzeForScriptingDeleteAllData(true);
            case 14 -> this.analyzeForScriptingDrop();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public LevelAnalyzer.Recommendation analyzeForAllDetailsAccessing() {
        return this.analyzeContent((Function1<? super BasicMultiLevelObject, ? extends Level>)((Function1)BaseLevelAnalyzer::analyzeForAllDetailsAccessing$lambda$0));
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForExecuting() {
        return this.analyzeContent((Function1<? super BasicMultiLevelObject, ? extends Level>)((Function1)BaseLevelAnalyzer::analyzeForExecuting$lambda$0));
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingNativeDefinitions() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingEnableDisable() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingRecompile() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingRefresh() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingDeleteAllData(boolean truncate) {
        return LevelAnalyzer.Recommendation.nothing;
    }

    @NotNull
    protected LevelAnalyzer.Recommendation analyzeForScriptingDrop() {
        return LevelAnalyzer.Recommendation.nothing;
    }

    private static final Level analyzeContent$lambda$1(Level lv1, Level lv2) {
        Intrinsics.checkNotNullParameter((Object)((Object)lv1), (String)"lv1");
        Intrinsics.checkNotNullParameter((Object)((Object)lv2), (String)"lv2");
        return Companion.greater(lv1, lv2);
    }

    private static final Level analyzeContent$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Level)((Object)$tmp0.invoke(p0, p1));
    }

    private static final ObjectKind analyzeContent$lambda$3(BasicMultiLevelObject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        ObjectKind objectKind = o.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        return objectKind;
    }

    private static final String analyzeContent$lambda$5(BasicMultiLevelObject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return o.getName();
    }

    private static final String analyzeContent$lambda$6(BasicSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return IntrospectionTasks.getDatabaseScopeName(schema);
    }

    private static final Level analyzeForAllDetailsAccessing$lambda$0(BasicMultiLevelObject o) {
        Level level;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Level it = level = o.getMaxDetailsLevel();
        boolean bl = false;
        Level level2 = o.getDetailsLevel();
        if (level2 == null) {
            level2 = Level.L1;
        }
        return level2.compareTo((Enum)it) < 0 ? level : null;
    }

    private static final Level analyzeForExecuting$lambda$0(BasicMultiLevelObject o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Level level = o.getDetailsLevel();
        if (level == null) {
            level = Level.L1;
        }
        return level.compareTo((Enum)Level.L2) < 0 && o.getMaxDetailsLevel().compareTo((Enum)Level.L2) >= 0 ? Level.L2 : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0086\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0084\u0004J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0084\u0004\u00a8\u0006\n"}, d2={"Lcom/intellij/database/model/BaseLevelAnalyzer$Companion;", "", "<init>", "()V", "greater", "Lcom/intellij/database/model/properties/Level;", "that", "require", "Lcom/intellij/database/model/basic/BasicElement;", "reqLevel", "intellij.database.core.impl"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Level greater(@NotNull Level $this$greater, @NotNull Level that) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$greater), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)that), (String)"that");
            return that.level > $this$greater.level ? that : $this$greater;
        }

        @Nullable
        protected final Level require(@NotNull BasicElement $this$require, @NotNull Level reqLevel) {
            Intrinsics.checkNotNullParameter((Object)$this$require, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)reqLevel), (String)"reqLevel");
            return this.require(ModelFun.getDetailsLevel($this$require), reqLevel);
        }

        @Nullable
        protected final Level require(@Nullable Level $this$require, @NotNull Level reqLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)reqLevel), (String)"reqLevel");
            return $this$require != null && $this$require.compareTo((Enum)reqLevel) >= 0 ? null : reqLevel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.L2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.L3.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.CREATE_COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_BEFORE_IMPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_AFTER_IMPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.CREATE_DEFINITION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.NATIVE_DEFINITION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ALTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.ENABLE_CONSTRAINTS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DISABLE_CONSTRAINTS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.RECOMPILE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.REFRESH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.EXECUTE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DELETE_DATA.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptCategory.DROP_COMPLETE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

