/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/script/generator/ScriptingAlterTaskBuilder;", "Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "sourceModel", "Lcom/intellij/database/model/basic/BasicModel;", "targetModel", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicModel;)V", "getTargetModel", "()Lcom/intellij/database/model/basic/BasicModel;", "correspondence", "", "Lcom/intellij/database/model/ElementDelta;", "getCorrespondence", "()Ljava/util/Collection;", "setCorrespondence", "(Ljava/util/Collection;)V", "build", "Lcom/intellij/database/script/generator/ScriptingAlterTask;", "intellij.database.core.impl"})
public final class ScriptingAlterTaskBuilder
extends ScriptingTaskBuilder {
    @NotNull
    private final BasicModel targetModel;
    @NotNull
    private Collection<ElementDelta<?>> correspondence;

    public ScriptingAlterTaskBuilder(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel) {
        Intrinsics.checkNotNullParameter((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkNotNullParameter((Object)targetModel, (String)"targetModel");
        super(sourceModel, null);
        this.targetModel = targetModel;
        this.correspondence = new ArrayList();
    }

    @NotNull
    public final BasicModel getTargetModel() {
        return this.targetModel;
    }

    @NotNull
    public final Collection<ElementDelta<?>> getCorrespondence() {
        return this.correspondence;
    }

    public final void setCorrespondence(@NotNull Collection<ElementDelta<?>> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.correspondence = collection;
    }

    @Override
    @NotNull
    public ScriptingAlterTask build() {
        return new ScriptingAlterTask(this.getModel(), this.targetModel, this.correspondence, this.getCurrentDatabase(), this.getCurrentSchema(), this.getOptions(), this.getVersion(), this.getConsumer());
    }
}

