/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u00a2\u0006\u0004\b\b\u0010\u0012J\n\u0010\u0015\u001a\u00020\u0011H\u0096\u0080\u0004J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey;", "Lnet/schmizz/sshj/userauth/method/AuthPublickey;", "privateKey", "Ljava/nio/file/Path;", "emptyPassword", "Ljava/util/concurrent/atomic/AtomicBoolean;", "kProv", "Lnet/schmizz/sshj/userauth/keyprovider/KeyProvider;", "PlatformAuthPublickey", "(Ljava/nio/file/Path;Ljava/util/concurrent/atomic/AtomicBoolean;Lnet/schmizz/sshj/userauth/keyprovider/KeyProvider;)V", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "passwordFinder", "Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey$PasswordFinderWithEmptinessFlag;", "(Lnet/schmizz/sshj/SSHClient;Ljava/nio/file/Path;Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey$PasswordFinderWithEmptinessFlag;)V", "passwordSupplier", "Lkotlin/Function0;", "", "(Lnet/schmizz/sshj/SSHClient;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "getPrivateKey", "()Ljava/nio/file/Path;", "toString", "checkValidity", "Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey$ValidationResult;", "ValidationResult", "PasswordFinderWithEmptinessFlag", "intellij.platform.ssh"})
public final class PlatformAuthPublickey
extends AuthPublickey {
    @NotNull
    private final Path privateKey;
    @NotNull
    private final AtomicBoolean emptyPassword;

    private PlatformAuthPublickey(Path privateKey, AtomicBoolean emptyPassword, KeyProvider kProv) {
        super(kProv);
        this.privateKey = privateKey;
        this.emptyPassword = emptyPassword;
    }

    @NotNull
    public final Path getPrivateKey() {
        return this.privateKey;
    }

    private PlatformAuthPublickey(SSHClient sshClient, Path privateKey, PasswordFinderWithEmptinessFlag passwordFinder) {
        AtomicBoolean atomicBoolean = passwordFinder.getEmptyPassword();
        KeyProvider keyProvider2 = sshClient.loadKeys(((Object)privateKey.toAbsolutePath()).toString(), (PasswordFinder)passwordFinder);
        Intrinsics.checkNotNullExpressionValue((Object)keyProvider2, (String)"loadKeys(...)");
        this(privateKey, atomicBoolean, keyProvider2);
    }

    public PlatformAuthPublickey(@NotNull SSHClient sshClient, @NotNull Path privateKey, @NotNull Function0<String> passwordSupplier) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter(passwordSupplier, (String)"passwordSupplier");
        this(sshClient, privateKey, new PasswordFinderWithEmptinessFlag(passwordSupplier));
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(path=" + this.privateKey + "}";
    }

    @NotNull
    public final ValidationResult checkValidity() {
        Object object;
        Object object2;
        Object object3;
        try {
            boolean bl = false;
            this.kProv.getPrivate();
            object3 = Result.constructor-impl((Object)((Object)ValidationResult.OK));
        }
        catch (Throwable throwable) {
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object2 = object3;
        } else {
            Object object4;
            Object object5 = object3;
            try {
                object4 = throwable;
                boolean bl = false;
                File file = this.privateKey.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                object4 = Result.constructor-impl((Object)((Object)(UtilKt.analyzeKeyPairSshj(file) instanceof InvalidKeyPair ? ValidationResult.CORRUPTED : (this.emptyPassword.get() ? ValidationResult.EMPTY_PASSWORD : ValidationResult.WRONG_PASSPHRASE))));
            }
            catch (Throwable throwable2) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            object2 = object4;
        }
        object3 = object2;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object3);
        if (throwable3 == null) {
            object = object3;
        } else {
            throwable = throwable3;
            boolean bl = false;
            if (!(throwable instanceof IOException) && !(throwable instanceof UnsupportedOperationException)) {
                UtilKt.getSSHJ_LOG().error("Unexpected error was thrown during decoding a private key", throwable);
            }
            object = ValidationResult.CORRUPTED;
        }
        return (ValidationResult)((Object)object);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey$PasswordFinderWithEmptinessFlag;", "Lnet/schmizz/sshj/userauth/password/PasswordFinder;", "passwordSupplier", "Lkotlin/Function0;", "", "PlatformAuthPublickey$PasswordFinderWithEmptinessFlag", "(Lkotlin/jvm/functions/Function0;)V", "emptyPassword", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getEmptyPassword", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "reqPassword", "", "resource", "Lnet/schmizz/sshj/userauth/password/Resource;", "shouldRetry", "", "intellij.platform.ssh"})
    private static final class PasswordFinderWithEmptinessFlag
    implements PasswordFinder {
        @NotNull
        private final Function0<String> passwordSupplier;
        @NotNull
        private final AtomicBoolean emptyPassword;

        public PasswordFinderWithEmptinessFlag(@NotNull Function0<String> passwordSupplier) {
            Intrinsics.checkNotNullParameter(passwordSupplier, (String)"passwordSupplier");
            this.passwordSupplier = passwordSupplier;
            this.emptyPassword = new AtomicBoolean();
        }

        @NotNull
        public final AtomicBoolean getEmptyPassword() {
            return this.emptyPassword;
        }

        @NotNull
        public char[] reqPassword(@Nullable Resource<?> resource) {
            String string = (String)this.passwordSupplier.invoke();
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] cArray2 = cArray;
            this.emptyPassword.set(cArray2.length == 0);
            return cArray2;
        }

        public boolean shouldRetry(@Nullable Resource<?> resource) {
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ssh/impl/sshj/PlatformAuthPublickey$ValidationResult;", "", "description", "", "PlatformAuthPublickey$ValidationResult", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "CORRUPTED", "EMPTY_PASSWORD", "OK", "WRONG_PASSPHRASE", "intellij.platform.ssh"})
    public static final class ValidationResult
    extends Enum<ValidationResult> {
        @NotNull
        private final String description;
        public static final /* enum */ ValidationResult CORRUPTED = new ValidationResult("the key is definitely corrupted");
        public static final /* enum */ ValidationResult EMPTY_PASSWORD = new ValidationResult("empty password, the key was dismissed by the user");
        public static final /* enum */ ValidationResult OK = new ValidationResult("ok");
        public static final /* enum */ ValidationResult WRONG_PASSPHRASE = new ValidationResult("wrong passphrase or the key is corrupted");
        private static final /* synthetic */ ValidationResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ValidationResult(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static ValidationResult[] values() {
            return (ValidationResult[])$VALUES.clone();
        }

        public static ValidationResult valueOf(String value) {
            return Enum.valueOf(ValidationResult.class, value);
        }

        @NotNull
        public static EnumEntries<ValidationResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = validationResultArray = new ValidationResult[]{ValidationResult.CORRUPTED, ValidationResult.EMPTY_PASSWORD, ValidationResult.OK, ValidationResult.WRONG_PASSPHRASE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

