/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataInputStream;
import com.intellij.util.io.DigestUtil;
import java.security.Key;
import java.security.MessageDigest;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"AES_CIPHER", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "FILE_VERSION_CRITICAL_MASK", "", "SIG1", "SIG2", "FILE_VERSION_32", "readSignature", "", "input", "Lcom/google/common/io/LittleEndianDataInputStream;", "verifyFileVersion", "getFinalKeyDigest", "", "key", "mainSeed", "transformSeed", "transformRounds", "", "createChipper", "Ljavax/crypto/Cipher;", "forEncryption", "ivData", "keyData", "readIntHeaderData", "readLongHeaderData", "readHeaderData", "intellij.platform.credentialStore.impl"})
public final class KdbxHeaderKt {
    private static final UUID AES_CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");
    private static final int FILE_VERSION_CRITICAL_MASK = -65536;
    private static final int SIG1 = -1700603645;
    private static final int SIG2 = -1253311641;
    private static final int FILE_VERSION_32 = 196609;

    private static final boolean readSignature(LittleEndianDataInputStream input) {
        return input.readInt() == -1700603645 && input.readInt() == -1253311641;
    }

    private static final boolean verifyFileVersion(LittleEndianDataInputStream input) {
        return (input.readInt() & 0xFFFF0000) <= 196608;
    }

    private static final byte[] getFinalKeyDigest(byte[] key, byte[] mainSeed, byte[] transformSeed, long transformRounds) {
        AESEngine engine = new AESEngine();
        engine.init(true, (CipherParameters)new KeyParameter(transformSeed));
        byte[] transformedKey = new byte[key.length];
        System.arraycopy(key, 0, transformedKey, 0, transformedKey.length);
        for (long rounds = 0L; rounds < transformRounds; ++rounds) {
            engine.processBlock(transformedKey, 0, transformedKey, 0);
            engine.processBlock(transformedKey, 16, transformedKey, 16);
        }
        MessageDigest md = DigestUtil.sha256();
        byte[] transformedKeyDigest = md.digest(transformedKey);
        md.update(mainSeed);
        byte[] byArray = md.digest(transformedKeyDigest);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    private static final Cipher createChipper(boolean forEncryption, byte[] ivData, byte[] keyData) {
        IvParameterSpec iv = new IvParameterSpec(ivData);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, 0, keyData.length, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(forEncryption ? 1 : 2, (Key)secretKey, iv);
        Intrinsics.checkNotNull((Object)cipher);
        return cipher;
    }

    private static final int readIntHeaderData(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 4) {
            throw new IllegalStateException("Int required but length was " + fieldLength);
        }
        return input.readInt();
    }

    private static final long readLongHeaderData(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 8) {
            throw new IllegalStateException("Long required but length was " + fieldLength);
        }
        return input.readLong();
    }

    private static final byte[] readHeaderData(LittleEndianDataInputStream input) {
        byte[] value = new byte[input.readShort()];
        input.readFully(value);
        return value;
    }

    public static final /* synthetic */ UUID access$getAES_CIPHER$p() {
        return AES_CIPHER;
    }

    public static final /* synthetic */ byte[] access$getFinalKeyDigest(byte[] key, byte[] mainSeed, byte[] transformSeed, long transformRounds) {
        return KdbxHeaderKt.getFinalKeyDigest(key, mainSeed, transformSeed, transformRounds);
    }

    public static final /* synthetic */ Cipher access$createChipper(boolean forEncryption, byte[] ivData, byte[] keyData) {
        return KdbxHeaderKt.createChipper(forEncryption, ivData, keyData);
    }

    public static final /* synthetic */ boolean access$readSignature(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readSignature(input);
    }

    public static final /* synthetic */ boolean access$verifyFileVersion(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.verifyFileVersion(input);
    }

    public static final /* synthetic */ byte[] access$readHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readHeaderData(input);
    }

    public static final /* synthetic */ int access$readIntHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readIntHeaderData(input);
    }

    public static final /* synthetic */ long access$readLongHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readLongHeaderData(input);
    }
}

