/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.MainKey;
import com.intellij.credentialStore.keePass.MainKeyFileStorage;
import com.intellij.openapi.application.PathManager;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0000\u001a$\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"DB_FILE_NAME", "", "getDefaultDbFile", "Ljava/nio/file/Path;", "getDefaultMainPasswordFile", "generateRandomMainKey", "Lcom/intellij/credentialStore/keePass/MainKey;", "mainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Ljava/security/SecureRandom;", "saveDatabase", "", "dbFile", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "mainKey", "mainKeyStorage", "Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;", "copyTo", "from", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "Lcom/intellij/credentialStore/Credentials;", "store", "Lcom/intellij/credentialStore/CredentialStore;", "intellij.platform.credentialStore.impl"})
public final class KeePassCredentialStoreKt {
    @NotNull
    public static final String DB_FILE_NAME = "c.kdbx";

    @NotNull
    public static final Path getDefaultDbFile() {
        Path path = PathManager.getOriginalConfigDir().resolve(DB_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final Path getDefaultMainPasswordFile() {
        Path path = PathManager.getOriginalConfigDir().resolve("c.pwd");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final MainKey generateRandomMainKey(@NotNull EncryptionSpec mainKeyEncryptionSpec, @NotNull SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)mainKeyEncryptionSpec, (String)"mainKeyEncryptionSpec");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
        byte[] bytes = CredentialStoreKt.generateBytes(secureRandom, 512);
        byte[] byArray = Base64.getEncoder().withoutPadding().encode(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return new MainKey(byArray, true, mainKeyEncryptionSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveDatabase(@NotNull Path dbFile, @NotNull KeePassDatabase db, @NotNull MainKey mainKey, @NotNull MainKeyFileStorage mainKeyStorage, @NotNull SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)mainKey, (String)"mainKey");
        Intrinsics.checkNotNullParameter((Object)mainKeyStorage, (String)"mainKeyStorage");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
        byte[] byArray = mainKey.getValue();
        Intrinsics.checkNotNull((Object)byArray);
        KdbxPassword kdbxPassword = new KdbxPassword(byArray);
        mainKeyStorage.save(mainKey);
        Closeable closeable = PathKt.safeOutputStream((Path)dbFile);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            db.save$intellij_platform_credentialStore_impl(kdbxPassword, it, secureRandom);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void copyTo(@NotNull Map<CredentialAttributes, Credentials> from, @NotNull CredentialStore store) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        for (Map.Entry<CredentialAttributes, Credentials> entry : from.entrySet()) {
            CredentialAttributes k = entry.getKey();
            Credentials v = entry.getValue();
            store.set(k, v);
        }
    }
}

