/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreManager;
import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Ephemeral;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0013\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0096\u0002J\u001b\u0010%\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010\"H\u0096\u0002J#\u0010%\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010'\u001a\u00020\tH\u0096\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)2\u0006\u0010#\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000b\u00a8\u0006/"}, d2={"Lcom/intellij/ide/passwordSafe/impl/BasePasswordSafe;", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "<init>", "()V", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "getSettings", "()Lcom/intellij/credentialStore/PasswordSafeSettings;", "value", "", "isRememberPasswordByDefault", "()Z", "setRememberPasswordByDefault", "(Z)V", "_currentProvider", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/credentialStore/CredentialStore;", "currentProviderIfComputed", "getCurrentProviderIfComputed", "()Lcom/intellij/credentialStore/CredentialStore;", "currentProvider", "getCurrentProvider", "setCurrentProvider", "(Lcom/intellij/credentialStore/CredentialStore;)V", "closeCurrentStore", "", "isSave", "isEvenMemoryOnly", "createMainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "memoryHelperProvider", "Lkotlin/Lazy;", "isMemoryOnly", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "credentials", "memoryOnly", "getAsync", "Lcom/intellij/util/Ephemeral;", "(Lcom/intellij/credentialStore/CredentialAttributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isPasswordStoredOnlyInMemory", "computeProvider", "intellij.platform.credentialStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPasswordSafeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordSafeImpl.kt\ncom/intellij/ide/passwordSafe/impl/BasePasswordSafe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
public abstract class BasePasswordSafe
extends PasswordSafe {
    @NotNull
    private final SynchronizedClearableLazy<CredentialStore> _currentProvider = new SynchronizedClearableLazy(() -> BasePasswordSafe._currentProvider$lambda$0(this));
    @NotNull
    private final Lazy<CredentialStore> memoryHelperProvider = LazyKt.lazy(BasePasswordSafe::memoryHelperProvider$lambda$0);

    @NotNull
    protected abstract PasswordSafeSettings getSettings();

    public boolean isRememberPasswordByDefault() {
        return this.getSettings().getState().isRememberPasswordByDefault();
    }

    public void setRememberPasswordByDefault(boolean value) {
        this.getSettings().getState().setRememberPasswordByDefault(value);
    }

    private final CredentialStore getCurrentProviderIfComputed() {
        return this._currentProvider.isInitialized() ? (CredentialStore)this._currentProvider.getValue() : null;
    }

    @NotNull
    public final CredentialStore getCurrentProvider() {
        return (CredentialStore)this._currentProvider.getValue();
    }

    public final void setCurrentProvider(@NotNull CredentialStore value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._currentProvider.setValue((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCurrentStore(boolean isSave, boolean isEvenMemoryOnly) {
        block9: {
            CredentialStore credentialStore = this.getCurrentProviderIfComputed();
            if (credentialStore == null) {
                return;
            }
            CredentialStore store = credentialStore;
            if (!isEvenMemoryOnly && store instanceof InMemoryCredentialStore) {
                return;
            }
            this._currentProvider.drop();
            try {
                if (!isSave || !(store instanceof KeePassCredentialStore)) break block9;
                try {
                    ((KeePassCredentialStore)store).save(this.createMainKeyEncryptionSpec());
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    PasswordSafeImplKt.access$getLOG().warn((Throwable)e);
                }
            }
            finally {
                if (store instanceof Closeable) {
                    ((Closeable)store).close();
                }
            }
        }
    }

    private final EncryptionSpec createMainKeyEncryptionSpec() {
        String pgpKey = this.getSettings().getState().getPgpKeyId();
        return pgpKey == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey);
    }

    public boolean isMemoryOnly() {
        return this.getSettings().getProviderType() == ProviderType.MEMORY_ONLY;
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SlowOperations.assertNonCancelableSlowOperationsAreAllowed();
        Credentials value = this.getCurrentProvider().get(attributes);
        if ((value == null || (charSequence = (CharSequence)value.getPassword()) == null || charSequence.length() == 0) && this.memoryHelperProvider.isInitialized() && (charSequence = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes)) != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            return it;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SlowOperations.assertNonCancelableSlowOperationsAreAllowed();
        this.getCurrentProvider().set(attributes, credentials);
        if (attributes.isPasswordMemoryOnly()) {
            Credentials credentials2 = credentials;
            CharSequence charSequence = (CharSequence)(credentials2 != null ? credentials2.getPassword() : null);
            if (!(charSequence == null || charSequence.length() == 0)) {
                ((CredentialStore)this.memoryHelperProvider.getValue()).set(new CredentialAttributes(attributes.getServiceName(), attributes.getUserName()), credentials);
                return;
            }
        }
        if (!this.memoryHelperProvider.isInitialized()) return;
        ((CredentialStore)this.memoryHelperProvider.getValue()).set(attributes, null);
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials, boolean memoryOnly) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (memoryOnly) {
            ((CredentialStore)this.memoryHelperProvider.getValue()).set(attributes.isPasswordMemoryOnly() ? new CredentialAttributes(attributes.getServiceName(), attributes.getUserName()) : attributes, credentials);
            this.getCurrentProvider().set(attributes, null);
        } else {
            this.set(attributes, credentials);
        }
    }

    @Nullable
    public Object getAsync(@NotNull CredentialAttributes attributes, @NotNull Continuation<? super Ephemeral<Credentials>> $completion) {
        return BasePasswordSafe.getAsync$suspendImpl(this, attributes, $completion);
    }

    static /* synthetic */ Object getAsync$suspendImpl(BasePasswordSafe $this, CredentialAttributes attributes, Continuation<? super Ephemeral<Credentials>> $completion) {
        return $this.getCurrentProvider().getAsync(attributes, $completion);
    }

    @Nullable
    public final Object save(@NotNull Continuation<? super Unit> $completion) {
        CredentialStore credentialStore = this.getCurrentProviderIfComputed();
        KeePassCredentialStore keePassCredentialStore = credentialStore instanceof KeePassCredentialStore ? (KeePassCredentialStore)credentialStore : null;
        if (keePassCredentialStore == null) {
            return Unit.INSTANCE;
        }
        KeePassCredentialStore keePassCredentialStore2 = keePassCredentialStore;
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(keePassCredentialStore2, this, null){
            int label;
            final /* synthetic */ KeePassCredentialStore $keePassCredentialStore;
            final /* synthetic */ BasePasswordSafe this$0;
            {
                this.$keePassCredentialStore = $keePassCredentialStore;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$keePassCredentialStore.save(BasePasswordSafe.access$createMainKeyEncryptionSpec(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes, @NotNull Credentials credentials) {
        boolean bl;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        if (this.isMemoryOnly() || (charSequence = (CharSequence)credentials.getPassword()) == null || charSequence.length() == 0) {
            return true;
        }
        if (!this.memoryHelperProvider.isInitialized()) {
            return false;
        }
        Credentials credentials2 = ((CredentialStore)this.memoryHelperProvider.getValue()).get(attributes);
        if (credentials2 != null) {
            Credentials it = credentials2;
            boolean bl2 = false;
            CharSequence charSequence2 = (CharSequence)it.getPassword();
            bl = !(charSequence2 == null || charSequence2.length() == 0);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected CredentialStore computeProvider(@NotNull PasswordSafeSettings settings) {
        block20: {
            block16: {
                block17: {
                    block15: {
                        block14: {
                            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                            if (settings.getProviderType() == ProviderType.MEMORY_ONLY) break block14;
                            Application application = ApplicationManager.getApplication();
                            boolean bl = application != null ? application.isUnitTestMode() : false;
                            if (!bl) break block15;
                        }
                        return new InMemoryCredentialStore();
                    }
                    if (!CredentialStoreManager.Companion.getInstance().isSupported(settings.getProviderType())) break block16;
                    if (settings.getProviderType() != ProviderType.KEEPASS) break block17;
                    try {
                        Object object;
                        block19: {
                            block18: {
                                object = settings.getKeepassDb();
                                if (object == null) break block18;
                                String it = object;
                                boolean bl = false;
                                Path path = Paths.get(it, new String[0]);
                                object = path;
                                if (path != null) break block19;
                            }
                            object = KeePassCredentialStoreKt.getDefaultDbFile();
                        }
                        Object dbFile = object;
                        return new KeePassCredentialStore((Path)dbFile, KeePassCredentialStoreKt.getDefaultMainPasswordFile());
                    }
                    catch (IncorrectMainPasswordException e) {
                        PasswordSafeImplKt.access$getLOG().warn((Throwable)e);
                        BasePasswordSafe.computeProvider$showError(e.isFileMissed() ? CredentialStoreBundle.INSTANCE.message("notification.title.password.missing", new Object[0]) : CredentialStoreBundle.INSTANCE.message("notification.title.password.incorrect", new Object[0]));
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        PasswordSafeImplKt.access$getLOG().error(e);
                        BasePasswordSafe.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.database.error", new Object[0]));
                    }
                    break block20;
                }
                try {
                    CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                    if (store != null) {
                        return store;
                    }
                    BasePasswordSafe.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.keychain.not.available", new Object[0]));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    PasswordSafeImplKt.access$getLOG().error(e);
                    BasePasswordSafe.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.cannot.use.keychain", new Object[0]));
                }
                break block20;
            }
            PasswordSafeImplKt.access$getLOG().error("Provider " + settings.getProviderType() + " is not supported in this environment");
            Object[] objectArray = new Object[]{settings.getProviderType()};
            BasePasswordSafe.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.cannot.use.provider", objectArray));
        }
        settings.setProviderType(ProviderType.MEMORY_ONLY);
        return new InMemoryCredentialStore();
    }

    private static final CredentialStore _currentProvider$lambda$0(BasePasswordSafe this$0) {
        return this$0.computeProvider(this$0.getSettings());
    }

    private static final InMemoryCredentialStore memoryHelperProvider$lambda$0() {
        return new InMemoryCredentialStore();
    }

    private static final Unit computeProvider$showError$lambda$0(AnActionEvent e, Notification notification) {
        CredentialStoreUiService.Companion.getInstance().openSettings(e.getProject());
        return Unit.INSTANCE;
    }

    private static final void computeProvider$showError$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void computeProvider$showError(@NlsContexts.NotificationTitle String title) {
        CredentialStoreUiService.Companion.getInstance().notify(title, CredentialStoreBundle.INSTANCE.message("notification.content.in.memory.storage", new Object[0]), null, NotificationAction.createExpiring((String)CredentialStoreBundle.INSTANCE.message("notification.content.password.settings.action", new Object[0]), (arg_0, arg_1) -> BasePasswordSafe.computeProvider$showError$lambda$1(BasePasswordSafe::computeProvider$showError$lambda$0, arg_0, arg_1)));
    }

    public static final /* synthetic */ EncryptionSpec access$createMainKeyEncryptionSpec(BasePasswordSafe $this) {
        return $this.createMainKeyEncryptionSpec();
    }
}

