/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearchInsideCollapsedNodes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.util.Collections;
import java.util.ListIterator;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XDebuggerTreeSpeedSearch
extends TreeSpeedSearchInsideCollapsedNodes {
    private static final String CAN_EXPAND_PROPERTY = "debugger.speed.search.tree.option.can.expand";
    private static final String COUNTER_PROPERTY = "debugger.speed.search.tree.option.hint.counter";
    public final int SEARCH_DEPTH = Registry.intValue((String)"debugger.variablesView.rss.depth");

    private XDebuggerTreeSpeedSearch(XDebuggerTree tree, Function<? super TreePath, String> toStringConvertor) {
        super((JTree)((Object)tree), PropertiesComponent.getInstance().getBoolean(CAN_EXPAND_PROPERTY, false), FindBundle.message((String)"find.expand.nodes", (Object[])new Object[0]), toStringConvertor);
        this.setComparator(new SpeedSearchComparator(this, false, false){

            public int matchingDegree(String pattern, String text) {
                return this.matchingFragments(pattern, text) != null ? 1 : 0;
            }

            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.myRecentSearchText = pattern;
                int index = StringUtil.indexOfIgnoreCase((String)text, (String)pattern, (int)0);
                return index >= 0 ? Collections.singleton(TextRange.from((int)index, (int)pattern.length())) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch$1";
                objectArray[2] = "matchingFragments";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Contract(value="_, _ -> new")
    @NotNull
    static XDebuggerTreeSpeedSearch installOn(XDebuggerTree tree, Function<? super TreePath, String> toStringConvertor) {
        XDebuggerTreeSpeedSearch search = new XDebuggerTreeSpeedSearch(tree, toStringConvertor);
        search.setupListeners();
        XDebuggerTreeSpeedSearch xDebuggerTreeSpeedSearch = search;
        if (xDebuggerTreeSpeedSearch == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(0);
        }
        return xDebuggerTreeSpeedSearch;
    }

    public void setCanExpand(boolean canExpand) {
        super.setCanExpand(canExpand);
        PropertiesComponent.getInstance().setValue(CAN_EXPAND_PROPERTY, canExpand);
    }

    @Nullable
    protected Object findNextElement(String s) {
        Object current;
        int selectedIndex = this.getSelectedIndex();
        ListIterator it = this.getElementIterator(selectedIndex + 1);
        if (it.hasPrevious()) {
            current = it.previous();
            it.next();
        } else {
            current = null;
        }
        String _s = s.trim();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (!this.myCanExpand) {
            this.showHint();
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator i = this.getElementIterator(0);
            while (i.hasNext()) {
                Object element = i.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return current != null && this.isMatchingElement(current, _s) ? current : null;
    }

    @Nullable
    protected Object findElement(@NotNull String s) {
        TreePath element;
        int selectedIndex;
        if (s == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(1);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            selectedIndex = 0;
        }
        ListIterator it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element = (TreePath)it.next();
            if (!((JTree)this.myComponent).isVisible(element) || !this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0 || this.myCanExpand) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = (TreePath)it.next();
                if (!((JTree)this.myComponent).isVisible(element) || !this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        if (this.myCanExpand) {
            while (it.hasNext()) {
                element = (TreePath)it.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
            if (selectedIndex > 0) {
                while (it.hasPrevious()) {
                    it.previous();
                }
                while (it.hasNext() && it.nextIndex() != selectedIndex) {
                    element = (TreePath)it.next();
                    if (!this.isMatchingElement(element, _s)) continue;
                    return element;
                }
            }
        }
        return null;
    }

    protected void showHint() {
        XDebuggerTreeSpeedSearch.showHint((JComponent)this.getSearchOptionButton());
    }

    private static void showHint(JComponent component) {
        if (component == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        int counter = propertiesComponent.getInt(COUNTER_PROPERTY, 0);
        if (counter >= 1) {
            return;
        }
        JComponent label = HintUtil.createInformationLabel((SimpleColoredText)new SimpleColoredText(FindBundle.message((String)"find.expand.nodes", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES));
        LightweightHint hint = new LightweightHint(label);
        Point point = new Point(component.getWidth() / 2, 0);
        HintHint hintHint = new HintHint((Component)component, point).setPreferredPosition(Balloon.Position.above).setAwtTooltip(true).setFont(StartupUiUtil.getLabelFont().deriveFont(1)).setBorderColor(HintUtil.getHintBorderColor()).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
        ApplicationManager.getApplication().invokeLater(() -> {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            hint.show(component, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        });
        propertiesComponent.setValue(COUNTER_PROPERTY, counter + 1, 0);
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        XDebuggerTreeNode root = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class);
        int initialLevel = root != null ? root.getPath().getPathCount() : 0;
        JBIterable jBIterable = ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)((JTree)this.myComponent)).expand(n -> ((JTree)this.myComponent).isExpanded((TreePath)n) || this.myCanExpand && n.getPathCount() - initialLevel < this.SEARCH_DEPTH)).traverse().filter(o -> !(o.getLastPathComponent() instanceof LoadingNode) && (!o.equals(root.getPath()) || ((JTree)this.myComponent).isRootVisible()));
        if (jBIterable == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "installOn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

