/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedContentTabWithStats;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.net.URLDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/UrlEncodedTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "tryParse", "intellij.platform.debugger.impl"})
public final class UrlEncodedTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String decoded = this.tryParse(value);
        if (decoded == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new VisualizedContentTabWithStats(decoded){
            final /* synthetic */ String $decoded;
            {
                this.$decoded = $decoded;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.url", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(UrlEncodedTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.URLEncoded;
            }

            public String formatText() {
                return this.$decoded;
            }

            protected LanguageFileType getFileType() {
                return FileTypes.PLAIN_TEXT;
            }
        });
    }

    private final String tryParse(String value) {
        String string;
        if (!StringsKt.contains$default((CharSequence)value, (char)'%', (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            string = URLDecoder.decode(value, Charsets.UTF_8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        String decoded = string;
        if (Intrinsics.areEqual((Object)decoded, (Object)value)) {
            return null;
        }
        return decoded;
    }
}

