/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileSetFactory;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.Unmodifiable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtilCore.class);
    @NonNls
    private static final String MAILTO = "mailto";
    @NonNls
    private static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    public static final String VFS_SEPARATOR = "/";
    private static final String PROTOCOL_DELIMITER = ":";
    private static final NotNullLazyValue<VirtualFileSetFactory> VIRTUAL_FILE_SET_FACTORY = NotNullLazyValue.lazy(VirtualFileSetFactory::getInstance);

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(1);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (((Object)((Object)parent)).equals((Object)ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<? extends VirtualFile> roots) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(2);
        }
        return VfsUtilCore.isUnderFiles(file, roots);
    }

    public static boolean isUnderFiles(@NotNull VirtualFile file, @Nullable Collection<? extends VirtualFile> roots) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(3);
        }
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains((Object)parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull @NonNls String url, @Nullable @NonNls Collection<String> rootUrls) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(4);
        }
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull @NonNls String ancestorUrl, @NotNull @NonNls String fileUrl) {
        if (ancestorUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(5);
        }
        if (fileUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(6);
        }
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, VFS_SEPARATOR});
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(7);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(8);
        }
        return FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
    }

    @Nullable
    @NlsSafe
    public static String getRelativeLocation(@Nullable VirtualFile file, @NotNull VirtualFile root) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(9);
        }
        if (file == null) {
            return null;
        }
        String path = VfsUtilCore.getRelativePath(file, root);
        return path != null ? path : file.getPresentableUrl();
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(10);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(11);
        }
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(12);
        }
        if (ancestor == null) {
            VfsUtilCore.$$$reportNull$$$0(13);
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (((Object)((Object)parent)).equals((Object)ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!((Object)((Object)parent)).equals((Object)ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            VfsUtilCore.$$$reportNull$$$0(14);
        }
        if (dst == null) {
            VfsUtilCore.$$$reportNull$$$0(15);
        }
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor(src, dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal((Object)((Object)src), (Object)((Object)commonAncestor))) {
            while (!Comparing.equal((Object)((Object)src), (Object)((Object)commonAncestor))) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath(dst, commonAncestor, separatorChar));
        if (StringUtil.endsWithChar((CharSequence)buffer, (char)separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(16);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(17);
        }
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(18);
        }
        if (toDir == null) {
            VfsUtilCore.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            VfsUtilCore.$$$reportNull$$$0(20);
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray(), -1L, -1L, requestor);
        newChild.setBOM(file.getBOM());
        VirtualFile virtualFile = newChild;
        if (virtualFile == null) {
            VfsUtilCore.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(byte @NotNull [] buf, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(22);
        }
        if (buf == null) {
            VfsUtilCore.$$$reportNull$$$0(23);
        }
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom;
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(24);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(25);
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        if ((bom = CharsetToolkit.detectBOMFromStream((InputStream)stream)) != null && file.getBOM() == null) {
            file.setBOM(bom);
        }
        InputStream inputStream = stream;
        if (inputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(26);
        }
        return inputStream;
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom;
        if (stream == null) {
            VfsUtilCore.$$$reportNull$$$0(27);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(28);
        }
        if ((bom = file.getBOM()) != null) {
            stream.write(bom);
        }
        OutputStream outputStream = stream;
        if (outputStream == null) {
            VfsUtilCore.$$$reportNull$$$0(29);
        }
        return outputStream;
    }

    public static boolean iterateChildrenRecursively(@NotNull VirtualFile root, @Nullable VirtualFileFilter filter, @NotNull ContentIterator iterator) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(30);
        }
        if (iterator == null) {
            VfsUtilCore.$$$reportNull$$$0(31);
        }
        return VfsUtilCore.iterateChildrenRecursively(root, filter, iterator, new VirtualFileVisitor.Option[0]);
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator, VirtualFileVisitor.Option ... options) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(32);
        }
        if (iterator == null) {
            VfsUtilCore.$$$reportNull$$$0(33);
        }
        if (options == null) {
            VfsUtilCore.$$$reportNull$$$0(34);
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(options){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (filter != null && !filter.accept(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (!iterator.processFile(file)) {
                    VirtualFileVisitor.Result result = 1.skipTo(root);
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal((Object)((Object)result.skipToParent), (Object)((Object)root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(35);
        }
        if (visitor == null) {
            VfsUtilCore.$$$reportNull$$$0(36);
        }
        ProgressManager.checkCanceled();
        boolean pushed = false;
        boolean allowVisitFile = visitor.allowVisitFile(file);
        if (allowVisitFile) {
            VirtualFileVisitor.Result result = visitor.visitFileEx(file);
            if (result.skipChildren) {
                VirtualFileVisitor.Result result2 = result;
                VirtualFileVisitor.Result result3 = result2;
                if (result3 == null) {
                    VfsUtilCore.$$$reportNull$$$0(37);
                }
                return result3;
            }
        }
        Iterable<VirtualFile> children = null;
        try {
            VirtualFile[] childrenArray;
            if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (children = visitor.getChildrenIterable(file)) == null && (childrenArray = file.getChildren(!visitor.childrenMayBeUnsorted())).length > 0) {
                children = Arrays.asList(childrenArray);
            }
        }
        catch (InvalidVirtualFileAccessException e) {
            LOG.info("Ignoring: " + e.getMessage());
            VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
            visitor.restoreValue(pushed);
            VirtualFileVisitor.Result result4 = result;
            if (result4 == null) {
                VfsUtilCore.$$$reportNull$$$0(38);
            }
            return result4;
        }
        if (children != null) {
            visitor.saveValue();
            pushed = true;
            for (VirtualFile child : children) {
                VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                if (result.skipToParent == null || Comparing.equal((Object)((Object)result.skipToParent), (Object)((Object)child))) continue;
                VirtualFileVisitor.Result result5 = result;
                VirtualFileVisitor.Result result6 = result5;
                if (result6 == null) {
                    VfsUtilCore.$$$reportNull$$$0(39);
                }
                return result6;
            }
        }
        if (allowVisitFile) {
            visitor.afterChildrenVisited(file);
        }
        VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
        Object object = result;
        if (object == null) {
            VfsUtilCore.$$$reportNull$$$0(40);
        }
        return object;
        finally {
            visitor.restoreValue(pushed);
        }
    }

    @NotNull
    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor, @NotNull Class<E> eClass) throws E {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(41);
        }
        if (visitor == null) {
            VfsUtilCore.$$$reportNull$$$0(42);
        }
        if (eClass == null) {
            VfsUtilCore.$$$reportNull$$$0(43);
        }
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(44);
        }
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target;
        if (link == null) {
            VfsUtilCore.$$$reportNull$$$0(45);
        }
        return (target = link.getCanonicalFile()) == null || ((Object)((Object)target)).equals((Object)link) || VfsUtilCore.isAncestor(target, link, true);
    }

    public static void saveText(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(46);
        }
        if (text == null) {
            VfsUtilCore.$$$reportNull$$$0(47);
        }
        Charset charset = file.getCharset();
        try (OutputStream stream = file.getOutputStream((Object)file);){
            stream.write(text.getBytes(charset));
        }
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(48);
        }
        return VfsUtilCore.loadText(file, (int)file.getLength());
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(49);
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        String string = new String(FileUtilRt.loadText((Reader)reader, (int)length));
        String string2 = string;
        if (string2 == null) {
            VfsUtilCore.$$$reportNull$$$0(50);
        }
        return string2;
        finally {
            reader.close();
        }
    }

    public static byte @NotNull [] loadBytes(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(51);
        }
        byte[] byArray = VirtualFileUtil.isTooLarge(file) ? VfsUtilCore.loadNBytes(file, FileSizeLimit.getPreviewLimit(file.getExtension())) : file.contentsToByteArray();
        if (byArray == null) {
            VfsUtilCore.$$$reportNull$$$0(52);
        }
        return byArray;
    }

    public static byte @NotNull [] loadNBytes(@NotNull VirtualFile virtualFile, int maxLength) throws IOException {
        byte[] byArray;
        InputStream stream;
        block9: {
            int n;
            if (virtualFile == null) {
                VfsUtilCore.$$$reportNull$$$0(53);
            }
            stream = virtualFile.getInputStream();
            byte[] buffer = new byte[(int)Math.min((long)maxLength, virtualFile.getLength())];
            byte[] bom = virtualFile.getBOM();
            int o = 0;
            if (bom != null) {
                System.arraycopy(bom, 0, buffer, 0, bom.length);
                o = bom.length;
            }
            int nread = o;
            while ((n = stream.read(buffer, nread, buffer.length - nread)) > 0) {
                nread += n;
            }
            byArray = nread == buffer.length ? buffer : Arrays.copyOf(buffer, nread);
            if (byArray != null) break block9;
            VfsUtilCore.$$$reportNull$$$0(54);
        }
        return byArray;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static VirtualFile @NotNull [] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(55);
        }
        VirtualFile[] virtualFileArray = files.isEmpty() ? VirtualFile.EMPTY_ARRAY : files.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            VfsUtilCore.$$$reportNull$$$0(56);
        }
        return virtualFileArray;
    }

    @NotNull
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        String string = URLUtil.urlToPath((String)url);
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(58);
        }
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            VfsUtilCore.$$$reportNull$$$0(59);
        }
        String string = VirtualFileManager.constructUrl("file", FileUtilRt.toSystemIndependentName((String)path));
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static String fileToUrl(@NotNull File file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(61);
        }
        return VfsUtilCore.pathToUrl(file.getPath());
    }

    public static @Unmodifiable List<File> virtualToIoFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(62);
        }
        return ContainerUtil.map(files, file -> VfsUtilCore.virtualToIoFile(file));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(63);
        }
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index;
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(64);
        }
        if ((index = url.indexOf(":/")) < 0 || index + 2 >= url.length()) {
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(65);
            }
            return string;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                String string = prefix + "://" + suffix;
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(66);
                }
                return string;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                String string = prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(67);
                }
                return string;
            }
            String string = prefix + ":///" + suffix;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(68);
            }
            return string;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String string = "file://" + url.substring(index + 4);
                if (string == null) {
                    VfsUtilCore.$$$reportNull$$$0(69);
                }
                return string;
            }
            String string = url;
            if (string == null) {
                VfsUtilCore.$$$reportNull$$$0(70);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(72);
        }
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        if (url == null) {
            VfsUtilCore.$$$reportNull$$$0(73);
        }
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(CoreBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(CoreBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfoRt.isWindows) {
            while (!path.isEmpty() && path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        path = URLUtil.unescapePercentSequences((String)path);
        String string = protocol + "://" + path;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(74);
        }
        return string;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(75);
        }
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path);
            }
            return URLUtil.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        String ideaProtocolMarker;
        int idx;
        if (ideaUrl == null) {
            VfsUtilCore.$$$reportNull$$$0(76);
        }
        if ((idx = ideaUrl.indexOf(ideaProtocolMarker = "://")) >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + ideaProtocolMarker.length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith(VFS_SEPARATOR) ? "" : VFS_SEPARATOR) + urlWithoutProtocol;
        }
        String string = ideaUrl;
        if (string == null) {
            VfsUtilCore.$$$reportNull$$$0(77);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull @NonNls String uri, @Nullable VirtualFile base) {
        if (uri == null) {
            VfsUtilCore.$$$reportNull$$$0(78);
        }
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else {
            uri = StringUtil.trimStart((String)uri, (String)"file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (SystemInfoRt.isUnix && uri.startsWith(VFS_SEPARATOR) || SystemInfoRt.isWindows && (OSAgnosticPathUtil.isAbsoluteDosPath((String)uri) || OSAgnosticPathUtil.isUncPath((String)uri))) {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base != null && !base.isDirectory()) {
                base = base.getParent();
            }
            file = base == null ? StandardFileSystems.local().findFileByPath(uri) : VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + '/' + uri);
        }
        return file;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        if (root == null) {
            VfsUtilCore.$$$reportNull$$$0(79);
        }
        if (processor == null) {
            VfsUtilCore.$$$reportNull$$$0(80);
        }
        final Ref result = new Ref((Object)true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!processor.process((Object)file)) {
                    result.set((Object)Boolean.FALSE);
                    VirtualFileVisitor.Result result2 = 2.skipTo(root);
                    if (result2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile parent1;
        if (file1 == null) {
            VfsUtilCore.$$$reportNull$$$0(81);
        }
        if (file2 == null) {
            VfsUtilCore.$$$reportNull$$$0(82);
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        if (((Object)((Object)file1)).equals((Object)file2)) {
            return file1;
        }
        int depth1 = VfsUtilCore.depth(file1);
        int depth2 = VfsUtilCore.depth(file2);
        VirtualFile parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !((Object)((Object)parent1)).equals((Object)parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int depth(VirtualFile file) {
        int depth = 0;
        while (file != null) {
            ++depth;
            file = file.getParent();
        }
        return depth;
    }

    @ApiStatus.Internal
    public static VirtualFile @NotNull [] getPathComponents(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(83);
        }
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)((Object)componentsList.get(size - i - 1));
        }
        if (components == null) {
            VfsUtilCore.$$$reportNull$$$0(84);
        }
        return components;
    }

    public static int compareByPath(@Nullable VirtualFile v1, @Nullable VirtualFile v2) {
        if (!Objects.equals((Object)v1, (Object)v2)) {
            boolean isOrphan2;
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            boolean isOrphan1 = v1.getParent() == null;
            boolean bl = isOrphan2 = v2.getParent() == null;
            if (isOrphan1 && isOrphan2) {
                return v1.getPath().compareTo(v2.getPath());
            }
            if (isOrphan1) {
                return -1;
            }
            if (isOrphan2) {
                return 1;
            }
            VirtualFile[] parents1 = VfsUtilCore.getPathComponents(v1);
            VirtualFile[] parents2 = VfsUtilCore.getPathComponents(v2);
            for (int i = 0; i < Math.min(parents1.length, parents2.length); ++i) {
                if (((Object)((Object)parents1[i])).equals((Object)parents2[i])) continue;
                return parents1[i].getName().compareTo(parents2[i].getName());
            }
            return Integer.compare(parents1.length, parents2.length);
        }
        return 0;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(85);
        }
        for (VirtualFile virtualFile : files) {
            if (virtualFile.isValid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findContainingDirectory(@NotNull VirtualFile file, @NotNull CharSequence name) {
        VirtualFile parent;
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(86);
        }
        if (name == null) {
            VfsUtilCore.$$$reportNull$$$0(87);
        }
        VirtualFile virtualFile = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            if (StringUtilRt.equal((CharSequence)parent.getNameSequence(), (CharSequence)name, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean pathEqualsTo(@NotNull VirtualFile file, @NotNull @SystemIndependent String path) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(88);
        }
        if (path == null) {
            VfsUtilCore.$$$reportNull$$$0(89);
        }
        path = FileUtil.toCanonicalPath((String)path);
        int li = path.length();
        while (file != null && li != -1) {
            int sepIndex = path.lastIndexOf(47, li - 1);
            CharSequence fileName = file.getNameSequence();
            int fileNameEnd = fileName.length() + (StringUtil.endsWithChar((CharSequence)fileName, (char)'/') ? -1 : 0);
            if (sepIndex == 6 && StringUtil.startsWith((CharSequence)fileName, (CharSequence)"//wsl$") || sepIndex == 15 && StringUtil.startsWith((CharSequence)fileName, (CharSequence)"//wsl.localhost")) {
                sepIndex = -1;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)fileName, (int)0, (int)fileNameEnd, (CharSequence)path, (int)(sepIndex + 1), (int)li, (boolean)file.isCaseSensitive())) {
                return false;
            }
            file = file.getParent();
            li = sepIndex;
        }
        return li == -1 && file == null;
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file) {
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(90);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        while (file != null) {
            result.add(file);
            file = file.getParent();
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            VfsUtilCore.$$$reportNull$$$0(91);
        }
        return arrayList;
    }

    public static boolean isAncestorOrSelf(@NotNull @SystemIndependent String ancestorPath, @NotNull VirtualFile file) {
        if (ancestorPath == null) {
            VfsUtilCore.$$$reportNull$$$0(92);
        }
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(93);
        }
        if ((ancestorPath = FileUtil.toCanonicalPath((String)ancestorPath)).isEmpty()) {
            return true;
        }
        List<VirtualFile> hierarchy = VfsUtilCore.getHierarchy(file);
        int i = 0;
        boolean result = false;
        for (int j = hierarchy.size() - 1; j >= 0; --j) {
            boolean matches;
            VirtualFile part = hierarchy.get(j);
            String name = part.getName();
            boolean bl = matches = part.isCaseSensitive() ? StringUtil.startsWith((CharSequence)ancestorPath, (int)i, (CharSequence)name) : StringUtilRt.startsWithIgnoreCase((String)ancestorPath, (int)i, (String)name);
            if (!matches) break;
            i += name.length();
            if (!name.endsWith(VFS_SEPARATOR)) {
                if (i != ancestorPath.length() && ancestorPath.charAt(i) != '/') break;
                ++i;
            }
            if (i < ancestorPath.length()) continue;
            result = true;
            break;
        }
        return result;
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        if (file == null) {
            VfsUtilCore.$$$reportNull$$$0(94);
        }
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            VfsUtilCore.$$$reportNull$$$0(95);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFileSet createCompactVirtualFileSet() {
        VirtualFileSet virtualFileSet = ((VirtualFileSetFactory)VIRTUAL_FILE_SET_FACTORY.getValue()).createCompactVirtualFileSet();
        if (virtualFileSet == null) {
            VfsUtilCore.$$$reportNull$$$0(96);
        }
        return virtualFileSet;
    }

    @NotNull
    public static VirtualFileSet createCompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            VfsUtilCore.$$$reportNull$$$0(97);
        }
        VirtualFileSet virtualFileSet = ((VirtualFileSetFactory)VIRTUAL_FILE_SET_FACTORY.getValue()).createCompactVirtualFileSet(files);
        if (virtualFileSet == null) {
            VfsUtilCore.$$$reportNull$$$0(98);
        }
        return virtualFileSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 98: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 98: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 58: 
            case 61: 
            case 83: 
            case 86: 
            case 88: 
            case 90: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 63: 
            case 64: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 9: 
            case 30: 
            case 32: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 21: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eClass";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 55: 
            case 62: 
            case 85: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 59: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsUrl";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaUrl";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "inputStreamSkippingBOM";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "outputStreamAddingBOM";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "visitChildrenRecursively";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "loadNBytes";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFileArray";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "toIdeaUrl";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromUrl";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "fixIDEAUrl";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponents";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchy";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompactVirtualFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEqualOrAncestor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeLocation";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRelativePath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 21: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 98: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "byteStreamSkippingBOM";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inputStreamSkippingBOM";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "outputStreamAddingBOM";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "iterateChildrenRecursively";
                break;
            }
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitChildrenRecursively";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenLink";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidLink";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "loadNBytes";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFileArray";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFile";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "fileToUrl";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "virtualToIoFiles";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "toIdeaUrl";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "fixURLforIDEA";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "convertFromUrl";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "convertToURL";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "fixIDEAUrl";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestor";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getPathComponents";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidFiles";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findContainingDirectory";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "pathEqualsTo";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorOrSelf";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getRootFile";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createCompactVirtualFileSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 95: 
            case 96: 
            case 98: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection(@NotNull Collection<? extends VirtualFile> virtualFiles) {
            if (virtualFiles == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(0);
            }
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile @NotNull [] collection) {
            if (collection == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(1);
            }
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
            if (ancestor == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(2);
            }
            if (virtualFile == null) {
                DistinctVFilesRootsCollection.$$$reportNull$$$0(3);
            }
            return VfsUtilCore.isAncestor(ancestor, virtualFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/VfsUtilCore$DistinctVFilesRootsCollection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

