/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.testFramework.TestModeFlagListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TestModeFlags {
    private static final Map<String, Object> ourFlags = new ConcurrentHashMap<String, Object>();
    private static final List<TestModeFlagListener> ourListeners = new CopyOnWriteArrayList<TestModeFlagListener>();

    @TestOnly
    public static <T> T set(@NotNull Key<T> flag, @Nullable T value) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(0);
        }
        Object oldValue = value == null ? ourFlags.remove(flag.toString()) : ourFlags.put(flag.toString(), value);
        for (TestModeFlagListener listener : ourListeners) {
            listener.testModeFlagChanged(flag, value);
        }
        return (T)oldValue;
    }

    @TestOnly
    public static void reset(@NotNull Key<?> flag) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(1);
        }
        TestModeFlags.set(flag, null);
    }

    @TestOnly
    public static <T> void set(@NotNull Key<T> flag, T value, @NotNull Disposable parentDisposable) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            TestModeFlags.$$$reportNull$$$0(3);
        }
        Object oldValue = TestModeFlags.set(flag, value);
        Disposer.register((Disposable)parentDisposable, () -> TestModeFlags.set(flag, oldValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static <T, R, E extends Throwable> R runWithFlag(@NotNull Key<T> flag, T value, @NotNull ThrowableComputable<R, E> runnable) throws E {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(4);
        }
        if (runnable == null) {
            TestModeFlags.$$$reportNull$$$0(5);
        }
        T oldValue = TestModeFlags.set(flag, value);
        try {
            Object object = runnable.compute();
            return (R)object;
        }
        finally {
            TestModeFlags.set(flag, oldValue);
        }
    }

    @TestOnly
    public static <T> void runWithFlag(@NotNull Key<T> flag, T value, @NotNull Runnable runnable) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            TestModeFlags.$$$reportNull$$$0(7);
        }
        TestModeFlags.runWithFlag(flag, value, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T get(@NotNull Key<T> flag) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(8);
        }
        return (T)ourFlags.get(flag.toString());
    }

    public static boolean is(@NotNull Key<Boolean> flag) {
        if (flag == null) {
            TestModeFlags.$$$reportNull$$$0(9);
        }
        return TestModeFlags.get(flag) == Boolean.TRUE;
    }

    public static void addListener(@NotNull TestModeFlagListener listener) {
        if (listener == null) {
            TestModeFlags.$$$reportNull$$$0(10);
        }
        ourListeners.add(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestModeFlags";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithFlag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "is";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

