/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.FixedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "StoreRecentPlacesListener", "RecentPlacesStorage", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nRecentPlacesFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n30#2,2:142\n*S KotlinDebug\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures\n*L\n36#1:142,2\n*E\n"})
public final class RecentPlacesFeatures
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "recent_places";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        Project project = location.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RecentPlacesStorage> serviceClass$iv = RecentPlacesStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RecentPlacesStorage storage = (RecentPlacesStorage)object;
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        boolean inRecentPlaces = storage.contains(string);
        String string2 = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        boolean inChildrenRecentPlaces = storage.childrenContains(string2);
        if (inRecentPlaces && inChildrenRecentPlaces) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"contains", (Object)MLFeatureValue.Companion.binary(true)), TuplesKt.to((Object)"children_contains", (Object)MLFeatureValue.Companion.binary(true))};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = inRecentPlaces ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"contains", (Object)MLFeatureValue.Companion.binary(true))) : (inChildrenRecentPlaces ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"children_contains", (Object)MLFeatureValue.Companion.binary(true))) : MapsKt.emptyMap());
        }
        return map;
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J%\u0010\u0014\u001a\u00020\r\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00052\u0006\u0010\n\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures$RecentPlacesStorage;", "", "<init>", "()V", "recentPlaces", "", "", "childrenRecentPlaces", "contains", "", "value", "childrenContains", "put", "", "putChildren", "values", "", "createFixedSizeSet", "maxSize", "", "addToTop", "T", "(Ljava/util/Set;Ljava/lang/Object;)V", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nRecentPlacesFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures$RecentPlacesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1915#2,2:142\n*S KotlinDebug\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures$RecentPlacesStorage\n*L\n129#1:142,2\n*E\n"})
    private static final class RecentPlacesStorage {
        @NotNull
        private final Set<String> recentPlaces = this.createFixedSizeSet(20);
        @NotNull
        private final Set<String> childrenRecentPlaces = this.createFixedSizeSet(100);

        public final synchronized boolean contains(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.recentPlaces.contains(value);
        }

        public final synchronized boolean childrenContains(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.childrenRecentPlaces.contains(value);
        }

        public final synchronized void put(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.addToTop(this.recentPlaces, value);
        }

        public final synchronized void putChildren(@NotNull List<String> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Iterable $this$forEach$iv = values;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.addToTop(this.childrenRecentPlaces, it);
            }
        }

        private final Set<String> createFixedSizeSet(int maxSize) {
            Set<String> set = Collections.newSetFromMap((Map)new FixedHashMap(maxSize));
            Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
            return set;
        }

        private final <T> void addToTop(Set<T> $this$addToTop, T value) {
            $this$addToTop.remove(value);
            $this$addToTop.add(value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/common/RecentPlacesFeatures$StoreRecentPlacesListener;", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$RecentPlacesListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "recentPlacesStorage", "Lcom/intellij/completion/ml/common/RecentPlacesFeatures$RecentPlacesStorage;", "recentPlaceAdded", "", "changePlace", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "isChanged", "", "recentPlaceRemoved", "getChildrenNames", "", "", "Lcom/intellij/psi/PsiElement;", "tryFindElementAt", "Lcom/intellij/psi/FileViewProvider;", "offset", "", "findDeclaration", "element", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nRecentPlacesFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures$StoreRecentPlacesListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n30#2,2:142\n4253#3,12:144\n1642#4,10:156\n1915#4:166\n1916#4:168\n1652#4:169\n1#5:167\n*S KotlinDebug\n*F\n+ 1 RecentPlacesFeatures.kt\ncom/intellij/completion/ml/common/RecentPlacesFeatures$StoreRecentPlacesListener\n*L\n51#1:142,2\n92#1:144,12\n92#1:156,10\n92#1:166\n92#1:168\n92#1:169\n92#1:167\n*E\n"})
    public static final class StoreRecentPlacesListener
    implements IdeDocumentHistoryImpl.RecentPlacesListener {
        @NotNull
        private final Project project;
        @NotNull
        private final RecentPlacesStorage recentPlacesStorage;

        public StoreRecentPlacesListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<RecentPlacesStorage> serviceClass$iv = RecentPlacesStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.recentPlacesStorage = (RecentPlacesStorage)object;
        }

        public void recentPlaceAdded(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
            Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
            if (ApplicationManager.getApplication().isUnitTestMode() || !changePlace.getFile().isValid() || changePlace.getFile().isDirectory()) {
                return;
            }
            RangeMarker rangeMarker = changePlace.getCaretPosition();
            if (rangeMarker == null) {
                return;
            }
            int offset = rangeMarker.getStartOffset();
            Object[] objectArray = new Object[]{this, changePlace.getFile()};
            ReadAction.nonBlocking(() -> StoreRecentPlacesListener.recentPlaceAdded$lambda$0(this, changePlace, offset)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> StoreRecentPlacesListener.recentPlaceAdded$lambda$2(arg_0 -> StoreRecentPlacesListener.recentPlaceAdded$lambda$1(this, arg_0), arg_0)).coalesceBy(objectArray).expireWith((Disposable)this.project).expireWhen(() -> StoreRecentPlacesListener.recentPlaceAdded$lambda$3(changePlace)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        public void recentPlaceRemoved(@NotNull IdeDocumentHistoryImpl.PlaceInfo changePlace, boolean isChanged) {
            Intrinsics.checkNotNullParameter((Object)changePlace, (String)"changePlace");
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getChildrenNames(PsiElement $this$getChildrenNames) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = $this$getChildrenNames.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiNamedElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiNamedElement it = (PsiNamedElement)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final PsiElement tryFindElementAt(FileViewProvider $this$tryFindElementAt, int offset) {
            try {
                if (!$this$tryFindElementAt.getVirtualFile().isValid()) return null;
                PsiFile psiFile = $this$tryFindElementAt.getPsi($this$tryFindElementAt.getBaseLanguage());
                if (psiFile == null) return null;
                if (!psiFile.isValid()) return null;
                boolean bl = true;
                if (!bl) return null;
                PsiElement psiElement = $this$tryFindElementAt.findElementAt(offset);
                return psiElement;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private final PsiElement findDeclaration(PsiElement element) {
            PsiElement curElement = element;
            while (!(curElement instanceof PsiFile)) {
                if (curElement instanceof PsiNameIdentifierOwner) {
                    return curElement;
                }
                if (curElement.getParent() != null) continue;
                return null;
            }
            return null;
        }

        private static final Pair recentPlaceAdded$lambda$0(StoreRecentPlacesListener this$0, IdeDocumentHistoryImpl.PlaceInfo $changePlace, int $offset) {
            FileViewProvider fileViewProvider = PsiManager.getInstance((Project)this$0.project).findViewProvider($changePlace.getFile());
            if (fileViewProvider == null) {
                return null;
            }
            FileViewProvider provider = fileViewProvider;
            NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(provider.getBaseLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"forLanguage(...)");
            NamesValidator namesValidator2 = namesValidator;
            PsiElement recentPlace = this$0.tryFindElementAt(provider, $offset);
            if (recentPlace == null || !namesValidator2.isIdentifier(recentPlace.getText(), this$0.project)) {
                return null;
            }
            PsiElement declaration = this$0.findDeclaration(recentPlace);
            Object object = declaration;
            if (object == null || (object = this$0.getChildrenNames((PsiElement)object)) == null || (object = CollectionsKt.take((Iterable)((Iterable)object), (int)10)) == null) {
                object = CollectionsKt.emptyList();
            }
            Object childrenPlaces = object;
            return TuplesKt.to((Object)recentPlace.getText(), (Object)childrenPlaces);
        }

        private static final Unit recentPlaceAdded$lambda$1(StoreRecentPlacesListener this$0, Pair place2children) {
            if (place2children != null) {
                this$0.recentPlacesStorage.put((String)place2children.getFirst());
                this$0.recentPlacesStorage.putChildren((List)place2children.getSecond());
            }
            return Unit.INSTANCE;
        }

        private static final void recentPlaceAdded$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final boolean recentPlaceAdded$lambda$3(IdeDocumentHistoryImpl.PlaceInfo $changePlace) {
            EditorWindow window = $changePlace.getWindow();
            return window == null || window.isDisposed();
        }
    }
}

