/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.properties.BasicReference;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J1\u0010\b\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/postgresbase/model/PgBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "ignoreAutoDescribe", "", "property", "Lcom/intellij/database/model/meta/BasicMetaId;", "isReferenceValueDefault", "E", "Lcom/intellij/database/model/basic/BasicElement;", "e", "reference", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicMetaProperty;)Z", "describeRoutine", "", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "intellij.database.dialects.postgresbase"})
public abstract class PgBaseDescriptionService
extends DescriptionService {
    protected boolean ignoreAutoDescribe(@NotNull BasicMetaId property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return Intrinsics.areEqual((Object)property, PgBaseObjectWithOwner.OWNER_REF) || super.ignoreAutoDescribe(property);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <E extends BasicElement> boolean isReferenceValueDefault(@NotNull E e, @NotNull BasicMetaProperty<E, ?> reference) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        if (!(e instanceof PgBaseRoutine)) return super.isReferenceValueDefault(e, reference);
        if (!Intrinsics.areEqual((Object)reference.id, PgBaseRoutine.LANGUAGE_REF)) return super.isReferenceValueDefault(e, reference);
        if (((PgBaseRoutine)e).getLanguageRef() == null) return true;
        BasicReference basicReference = ((PgBaseRoutine)e).getLanguageRef();
        if (!StringsKt.equals((String)"plpgsql", basicReference != null ? basicReference.getName((BasicElement)((PgBaseRoutine)e).getLanguage()) : null, (boolean)true)) return false;
        return true;
    }

    @NotNull
    protected String describeRoutine(@NotNull BasicRoutine r, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(PgBaseRoutine.PG_ROUTINE_KIND);
        PgBaseRoutine pgBaseRoutine = r instanceof PgBaseRoutine ? (PgBaseRoutine)r : null;
        if (pgBaseRoutine == null) {
            return super.describeRoutine(r, context);
        }
        PgBaseRoutine routine = pgBaseRoutine;
        return switch (WhenMappings.$EnumSwitchMapping$0[routine.getPgRoutineKind().ordinal()]) {
            case 1 -> "function";
            case 2 -> "procedure";
            case 3 -> "trigger function";
            case 4 -> "event trigger function";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PgRoutineKind.values().length];
            try {
                nArray[PgRoutineKind.PG_FUNCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PgRoutineKind.PG_PROCEDURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PgRoutineKind.PG_TRIGGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PgRoutineKind.PG_EVENT_TRIGGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

