/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.PropagationMode;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import com.intellij.docker.agent.fix.FixedBindParserBase;
import java.util.Locale;

public class FixedBindParser
extends FixedBindParserBase {
    public static Bind parse(String serialized) {
        String[] parts = FixedBindParser.fixedSplit(serialized);
        try {
            return FixedBindParser.copyPastedParse(parts);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'", e);
        }
    }

    private static Bind copyPastedParse(String[] parts) {
        switch (parts.length) {
            case 2: {
                return new Bind(parts[0], new Volume(parts[1]));
            }
            case 3: {
                String[] flags = parts[2].split(",");
                AccessMode accessMode = AccessMode.DEFAULT;
                SELContext seMode = SELContext.DEFAULT;
                Boolean nocopy = null;
                PropagationMode propagationMode = PropagationMode.DEFAULT_MODE;
                for (String p : flags) {
                    if (p.length() == 2) {
                        accessMode = AccessMode.valueOf((String)p.toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    if ("nocopy".equals(p)) {
                        nocopy = true;
                        continue;
                    }
                    if (PropagationMode.SHARED.toString().equals(p)) {
                        propagationMode = PropagationMode.SHARED;
                        continue;
                    }
                    if (PropagationMode.SLAVE.toString().equals(p)) {
                        propagationMode = PropagationMode.SLAVE;
                        continue;
                    }
                    if (PropagationMode.PRIVATE.toString().equals(p)) {
                        propagationMode = PropagationMode.PRIVATE;
                        continue;
                    }
                    seMode = SELContext.fromString((String)p);
                }
                return new Bind(parts[0], new Volume(parts[1]), accessMode, seMode, nocopy, propagationMode);
            }
        }
        throw new IllegalArgumentException();
    }
}

