/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.ServiceVolume;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeVolumesFromV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeExtendsV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeVolumesFromV2;
import com.intellij.docker.agent.compose.parser.PureDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeMappingsCollector
implements DockerComposeConfiguration.Visitor<Boolean> {
    private static final Logger LOG = Logger.getInstance(DockerComposeMappingsCollector.class);
    private final Map<String, PathMappingSettings> myServiceMappings;
    private final Map<String, List<String>> myDependencies;
    @NotNull
    private String myDockerComposeBaseDirectory;
    @Nullable
    private Deque<String> myAdditionalFiles;

    public DockerComposeMappingsCollector(@NotNull String dockerComposeBaseFile) {
        if (dockerComposeBaseFile == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(0);
        }
        this.myServiceMappings = new HashMap<String, PathMappingSettings>();
        this.myDependencies = new HashMap<String, List<String>>();
        this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)dockerComposeBaseFile));
        this.myAdditionalFiles = null;
    }

    @Override
    public Boolean visit(@NotNull DockerComposeConfigurationV1 configuration) {
        if (configuration == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, DockerComposeServiceV1> entry : configuration.getServices().entrySet()) {
            List dependencies;
            String serviceName = entry.getKey();
            DockerComposeServiceV1 service = entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, service);
            List<DockerComposeVolumesFromV1> volumesFrom2 = service.getVolumesFrom();
            if (volumesFrom2 == null || (dependencies = volumesFrom2.stream().filter(from -> from != null).map(from -> from.getName()).collect(Collectors.toList())).isEmpty()) continue;
            this.myDependencies.put(serviceName, dependencies);
        }
        return true;
    }

    @Override
    public Boolean visit(@NotNull DockerComposeConfigurationV2 configuration) {
        if (configuration == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(2);
        }
        for (Map.Entry<String, DockerComposeServiceV2> entry : configuration.getServices().entrySet()) {
            DockerComposeExtendsV2 parent;
            List dependencies;
            String serviceName = entry.getKey();
            DockerComposeServiceV2 service = entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, service);
            List<DockerComposeVolumesFromV2> volumesFrom2 = service.getVolumesFrom();
            if (volumesFrom2 != null && !(dependencies = volumesFrom2.stream().filter(from -> from != null && from.getType() == DockerComposeVolumesFromV2.Type.SERVICE).map(from -> from.getName()).collect(Collectors.toList())).isEmpty()) {
                this.myDependencies.put(serviceName, dependencies);
            }
            if ((parent = service.getExtends()) == null) continue;
            String parentFile = parent.getFile();
            String parentService = parent.getService();
            if (!StringUtil.isNotEmpty((String)parentFile) || !StringUtil.isNotEmpty((String)parentService)) continue;
            String absolute = PathUtil.toSystemDependentName((String)(FileUtil.isAbsolutePlatformIndependent((String)parentFile) ? parentFile : this.myDockerComposeBaseDirectory + "/" + parentFile));
            this.addAdditionalFile(FileUtil.toCanonicalPath((String)absolute));
            if (this.myDependencies.containsKey(serviceName)) {
                this.myDependencies.get(serviceName).add(parentService);
                continue;
            }
            this.myDependencies.put(serviceName, (List<String>)new SmartList((Object)parentService));
        }
        return true;
    }

    private void addAdditionalFile(@NotNull String configurationFile) {
        if (configurationFile == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(3);
        }
        if (this.myAdditionalFiles == null) {
            this.myAdditionalFiles = new ArrayDeque<String>(5);
        }
        this.myAdditionalFiles.addLast(configurationFile);
    }

    private void collectVolumes(@NotNull String serviceName, @NotNull DockerComposeServiceBase service) {
        List<ServiceVolume> volumes;
        if (serviceName == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(4);
        }
        if (service == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(5);
        }
        if ((volumes = service.getVolumes()) == null || volumes.isEmpty()) {
            return;
        }
        PathMappingSettings mappings2 = this.myServiceMappings.containsKey(serviceName) ? this.myServiceMappings.get(serviceName) : new PathMappingSettings();
        for (ServiceVolume volume2 : volumes) {
            boolean isAbsolutePath;
            if (!volume2.isBind()) continue;
            String sourcePath = volume2.getSource();
            String targetPath = volume2.getTarget();
            if (sourcePath == null || targetPath == null || !(isAbsolutePath = FileUtil.isAbsolutePlatformIndependent((String)sourcePath)) && !StringUtil.startsWith((CharSequence)sourcePath, (CharSequence)".")) continue;
            String unifiedLocal = PathUtil.toSystemIndependentName((String)sourcePath);
            String absolute = isAbsolutePath ? unifiedLocal : this.myDockerComposeBaseDirectory + "/" + unifiedLocal;
            mappings2.addMapping(FileUtil.toCanonicalPath((String)absolute, (char)'/'), targetPath);
        }
        if (!mappings2.isEmpty()) {
            this.myServiceMappings.put(serviceName, mappings2);
        }
    }

    @NotNull
    public PathMappingSettings collect(@NotNull String serviceName, @NotNull List<String> configurationFiles) {
        if (serviceName == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(6);
        }
        if (configurationFiles == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(7);
        }
        HashSet<String> visitedFiles = new HashSet<String>();
        for (String dockerComposeFile : configurationFiles) {
            if (visitedFiles.contains(dockerComposeFile)) continue;
            visitedFiles.add(dockerComposeFile);
            this.parse(dockerComposeFile);
        }
        while (this.myAdditionalFiles != null && !this.myAdditionalFiles.isEmpty()) {
            String configFile = this.myAdditionalFiles.removeFirst();
            if (visitedFiles.contains(configFile)) continue;
            visitedFiles.add(configFile);
            this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)configFile));
            this.parse(configFile);
        }
        PathMappingSettings result2 = new PathMappingSettings();
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<String> toVisit = new ArrayDeque<String>(this.myServiceMappings.size() / 2);
        toVisit.addLast(serviceName);
        while (!toVisit.isEmpty()) {
            String next = (String)toVisit.removeFirst();
            if (visited.contains(next)) continue;
            visited.add(next);
            if (this.myServiceMappings.containsKey(next)) {
                result2.addAll(this.myServiceMappings.get(next));
            }
            if (!this.myDependencies.containsKey(next)) continue;
            for (String dependency : this.myDependencies.get(next)) {
                toVisit.addLast(dependency);
            }
        }
        PathMappingSettings pathMappingSettings = result2;
        if (pathMappingSettings == null) {
            DockerComposeMappingsCollector.$$$reportNull$$$0(8);
        }
        return pathMappingSettings;
    }

    private void parse(@NotNull String configFile) {
        block4: {
            if (configFile == null) {
                DockerComposeMappingsCollector.$$$reportNull$$$0(9);
            }
            try {
                if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    DockerComposeConfigurationParserUtil.saveDockerComposeFiles(Collections.singletonList(configFile));
                }
                new PureDockerComposeConfigurationParser().parseBean(configFile).accept(this);
            }
            catch (IOException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break block4;
                LOG.warn("Cannot read docker-compose file: " + configFile, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeBaseFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerComposeMappingsCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerComposeMappingsCollector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectVolumes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

