/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.cache;

import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.cache.CacheHit;
import com.intellij.platform.workspace.storage.impl.cache.CacheHitInSynchronized;
import com.intellij.platform.workspace.storage.impl.cache.CacheHitNotAffectedByChanges;
import com.intellij.platform.workspace.storage.impl.cache.CacheProcessingStatus;
import com.intellij.platform.workspace.storage.impl.cache.CacheResetTracker;
import com.intellij.platform.workspace.storage.impl.cache.CachedValue;
import com.intellij.platform.workspace.storage.impl.cache.CellUpdateInfo;
import com.intellij.platform.workspace.storage.impl.cache.EntityStorageChange;
import com.intellij.platform.workspace.storage.impl.cache.IncrementalUpdate;
import com.intellij.platform.workspace.storage.impl.cache.Initialization;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCache;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheKt;
import com.intellij.platform.workspace.storage.impl.cache.UpdateType;
import com.intellij.platform.workspace.storage.impl.query.Cell;
import com.intellij.platform.workspace.storage.impl.query.CellChain;
import com.intellij.platform.workspace.storage.impl.query.CellId;
import com.intellij.platform.workspace.storage.impl.query.Diff;
import com.intellij.platform.workspace.storage.impl.query.DiffCollectorCell;
import com.intellij.platform.workspace.storage.impl.query.DiffImpl;
import com.intellij.platform.workspace.storage.impl.query.MatchSet;
import com.intellij.platform.workspace.storage.impl.query.QueryId;
import com.intellij.platform.workspace.storage.impl.trace.ReadTraceIndex;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.query.APIKt;
import com.intellij.platform.workspace.storage.query.CollectionQuery;
import com.intellij.platform.workspace.storage.query.QueriesKt;
import com.intellij.platform.workspace.storage.query.StorageQuery;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\bH\u0002J*\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&*\b\u0012\u0004\u0012\u00020\f0'H\u0002J4\u0010(\u001a\b\u0012\u0004\u0012\u0002H*0)\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016J:\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0/0)\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*002\u0006\u0010-\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016J8\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003020)\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\u001f\u00103\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0001\u00a2\u0006\u0002\b4J\u0019\u00105\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0001\u00a2\u0006\u0002\b6J\u001f\u00107\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007H\u0001\u00a2\u0006\u0002\b8J\u001e\u00109\u001a\b\u0012\u0004\u0012\u0002H:0'\"\u0004\b\u0000\u0010:*\b\u0012\u0004\u0012\u0002H:0'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lcom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl;", "Lcom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCache;", "<init>", "()V", "lock", "", "queryIdToChain", "Ljava/util/HashMap;", "Lcom/intellij/platform/workspace/storage/impl/query/QueryId;", "Lcom/intellij/platform/workspace/storage/impl/query/CellChain;", "queryIdToTraceIndex", "Lcom/intellij/platform/workspace/storage/impl/trace/ReadTraceIndex;", "Lcom/intellij/platform/workspace/storage/impl/cache/CellUpdateInfo;", "changeQueue", "", "", "Lcom/intellij/platform/workspace/storage/impl/cache/EntityStorageChange;", "pullingCache", "", "shuffleEntities", "", "getShuffleEntities$intellij_platform_workspace_storage", "()J", "setShuffleEntities$intellij_platform_workspace_storage", "(J)V", "pullCache", "", "newSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "from", "changes", "removeCache", "queryId", "updateCellIndex", "chainId", "Lcom/intellij/platform/workspace/storage/instrumentation/ImmutableEntityStorageInstrumentation;", "prevStorage", "firstDiffThenRecalculate", "", "", "cached", "Lcom/intellij/platform/workspace/storage/impl/cache/CachedValue;", "T", "query", "Lcom/intellij/platform/workspace/storage/query/StorageQuery;", "snapshot", "diff", "Lcom/intellij/platform/workspace/storage/impl/query/Diff;", "Lcom/intellij/platform/workspace/storage/query/CollectionQuery;", "getUpdatedLastCell", "Lcom/intellij/platform/workspace/storage/impl/query/Cell;", "getChangeQueue", "getChangeQueue$intellij_platform_workspace_storage", "getQueryIdToChain", "getQueryIdToChain$intellij_platform_workspace_storage", "getQueryIdToTraceIndex", "getQueryIdToTraceIndex$intellij_platform_workspace_storage", "maybeShuffled", "E", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nTracedSnapshotCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracedSnapshotCacheImpl.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n221#2,2:244\n466#3:246\n415#3:247\n383#3,7:253\n383#3,7:278\n1266#4,4:248\n1915#4:252\n1916#4:261\n1915#4,2:262\n1915#4:264\n1915#4,2:265\n1916#4:267\n3347#4,10:268\n1915#4,2:285\n1#5:260\n*S KotlinDebug\n*F\n+ 1 TracedSnapshotCacheImpl.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl\n*L\n95#1:244,2\n101#1:246\n101#1:247\n106#1:253,7\n216#1:278,7\n101#1:248,4\n105#1:252\n105#1:261\n119#1:262,2\n142#1:264\n147#1:265,2\n142#1:267\n156#1:268,10\n217#1:285,2\n*E\n"})
public final class TracedSnapshotCacheImpl
implements TracedSnapshotCache {
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final HashMap<QueryId, CellChain> queryIdToChain = new HashMap();
    @NotNull
    private final HashMap<QueryId, ReadTraceIndex<CellUpdateInfo>> queryIdToTraceIndex = new HashMap();
    @NotNull
    private final Map<QueryId, List<EntityStorageChange>> changeQueue = new HashMap();
    private boolean pullingCache;
    private long shuffleEntities = -1L;

    public final long getShuffleEntities$intellij_platform_workspace_storage() {
        return this.shuffleEntities;
    }

    public final void setShuffleEntities$intellij_platform_workspace_storage(long l) {
        this.shuffleEntities = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void pullCache(@NotNull ImmutableEntityStorage newSnapshot, @NotNull TracedSnapshotCache from, @NotNull EntityStorageChange changes) {
        Intrinsics.checkNotNullParameter((Object)newSnapshot, (String)"newSnapshot");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        try {
            this.pullingCache = true;
            if (!(from instanceof TracedSnapshotCacheImpl)) {
                throw new IllegalStateException("Check failed.");
            }
            Object object = ((TracedSnapshotCacheImpl)from).lock;
            synchronized (object) {
                EntityStorageChange it;
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                boolean bl = false;
                Map<QueryId, List<EntityStorageChange>> $this$forEach$iv = (Map<QueryId, List<EntityStorageChange>>)((TracedSnapshotCacheImpl)from).queryIdToTraceIndex;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    QueryId chainId = (QueryId)entry.getKey();
                    ReadTraceIndex index = (ReadTraceIndex)entry.getValue();
                    ReadTraceIndex newIndex = new ReadTraceIndex();
                    newIndex.pull(index);
                    ((Map)this.queryIdToTraceIndex).put(chainId, newIndex);
                }
                this.queryIdToChain.putAll((Map<QueryId, CellChain>)((TracedSnapshotCacheImpl)from).queryIdToChain);
                $this$forEach$iv = ((TracedSnapshotCacheImpl)from).changeQueue;
                Map<QueryId, List<EntityStorageChange>> map2 = this.changeQueue;
                boolean $i$f$mapValues = false;
                iterator = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable bl2 = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    ArrayList arrayList = new ArrayList((Collection)it.getValue());
                    map4.put(k, arrayList);
                }
                map2.putAll(destination$iv$iv$iv);
                this.shuffleEntities = ((TracedSnapshotCacheImpl)from).shuffleEntities;
                ArrayList cachesToRemove = new ArrayList();
                Set<QueryId> set = this.queryIdToChain.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable $this$forEach$iv2 = set;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Object object2;
                    void $this$getOrPut$iv;
                    QueryId chainId = (QueryId)element$iv;
                    boolean bl5 = false;
                    Map<QueryId, List<EntityStorageChange>> $i$f$associateByTo2 = this.changeQueue;
                    QueryId key$iv = chainId;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    List changesQueue = (List)object2;
                    Iterable iterable = changesQueue;
                    int n = 0;
                    for (Map map3 : iterable) {
                        it = (EntityStorageChange)((Object)map3);
                        int n2 = n;
                        boolean bl7 = false;
                        int n3 = it.getSize();
                        n = n2 + n3;
                    }
                    int expectedNewChangelogSize = n + changes.getSize();
                    if (expectedNewChangelogSize > TracedSnapshotCache.Companion.getLOG_QUEUE_MAX_SIZE()) {
                        if (CacheResetTracker.INSTANCE.getEnabled()) {
                            CacheResetTracker.INSTANCE.setCacheReset(true);
                        }
                        ((Collection)cachesToRemove).add(chainId);
                        continue;
                    }
                    changesQueue.add(changes);
                }
                $this$forEach$iv2 = cachesToRemove;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    QueryId it2 = (QueryId)element$iv;
                    boolean bl8 = false;
                    this.removeCache(it2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        finally {
            this.pullingCache = false;
        }
    }

    private final void removeCache(QueryId queryId) {
        this.queryIdToChain.remove(queryId);
        this.queryIdToTraceIndex.remove(queryId);
        this.changeQueue.remove(queryId);
    }

    private final boolean updateCellIndex(QueryId chainId, EntityStorageChange changes, ImmutableEntityStorageInstrumentation newSnapshot, ImmutableEntityStorageInstrumentation prevStorage) {
        ReadTraceIndex cellIndex = (ReadTraceIndex)MapsKt.getValue((Map)this.queryIdToTraceIndex, (Object)chainId);
        LongOpenHashSet newTraces = TracedSnapshotCacheKt.createTraces(changes, newSnapshot);
        HashMap<CellId, MatchSet> updatedCells = new HashMap<CellId, MatchSet>();
        boolean cellsUpdated = false;
        Iterable $this$forEach$iv = this.firstDiffThenRecalculate(this.maybeShuffled(cellIndex.get(newTraces)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CellChain cells;
            CellUpdateInfo updateRequest = (CellUpdateInfo)element$iv;
            boolean bl = false;
            cellsUpdated = true;
            if (this.queryIdToChain.get(updateRequest.getChainId()) == null) {
                throw new IllegalStateException("Unindexed cell".toString());
            }
            Pair<CellChain, List<Pair<LongOpenHashSet, CellUpdateInfo>>> pair = cells.changeInput(newSnapshot, prevStorage, updateRequest, changes, updateRequest.getCellId(), updatedCells);
            CellChain newChain = (CellChain)pair.component1();
            List tracesAndModifiedCells = (List)pair.component2();
            Iterable $this$forEach$iv2 = tracesAndModifiedCells;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair2 = (Pair)element$iv2;
                boolean bl2 = false;
                LongOpenHashSet traces = (LongOpenHashSet)pair2.component1();
                CellUpdateInfo updateRequest2 = (CellUpdateInfo)pair2.component2();
                cellIndex.set(traces, updateRequest2);
            }
            ((Map)this.queryIdToChain).put(newChain.getId(), newChain);
        }
        return cellsUpdated;
    }

    private final List<CellUpdateInfo> firstDiffThenRecalculate(Collection<CellUpdateInfo> $this$firstDiffThenRecalculate) {
        Iterable $this$partition$iv = $this$firstDiffThenRecalculate;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            CellUpdateInfo it = (CellUpdateInfo)element$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getUpdateType(), (Object)UpdateType.DIFF.INSTANCE) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List diff = (List)pair.component1();
        List recalculate = (List)pair.component2();
        return CollectionsKt.plus((Collection)diff, (Iterable)recalculate);
    }

    @Override
    @NotNull
    public <T> CachedValue<T> cached(@NotNull StorageQuery<T> query, @NotNull ImmutableEntityStorageInstrumentation snapshot, @Nullable ImmutableEntityStorageInstrumentation prevStorage) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (!(!this.pullingCache)) {
            boolean bl = false;
            String string = "It's not allowed to request query when the cache is pulled from other snapshot";
            throw new IllegalStateException(string.toString());
        }
        CachedValue<Cell<?>> lastCell = this.getUpdatedLastCell(query, snapshot, prevStorage);
        return new CachedValue(lastCell.getCacheProcessStatus(), lastCell.getValue().data());
    }

    @Override
    @NotNull
    public <T> CachedValue<Diff<T>> diff(@NotNull CollectionQuery<T> query, @NotNull ImmutableEntityStorageInstrumentation snapshot, @Nullable ImmutableEntityStorageInstrumentation prevStorage) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (!(!(query instanceof CollectionQuery.TrackDiff))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CollectionQuery<T> queryWithDiffTracker = APIKt.trackDiff(query);
        CachedValue<Cell<?>> lastCell = this.getUpdatedLastCell((StorageQuery)queryWithDiffTracker, snapshot, prevStorage);
        if (!(lastCell.getValue() instanceof DiffCollectorCell)) {
            throw new IllegalStateException("Check failed.");
        }
        List list = ((DiffCollectorCell)lastCell.getValue()).getAddedData();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl.diff>");
        List list2 = ((DiffCollectorCell)lastCell.getValue()).getRemovedData();
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl.diff>");
        DiffImpl diff = new DiffImpl(list, list2);
        return new CachedValue<Diff<T>>(lastCell.getCacheProcessStatus(), diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T> CachedValue<Cell<?>> getUpdatedLastCell(StorageQuery<T> query, ImmutableEntityStorageInstrumentation snapshot, ImmutableEntityStorageInstrumentation prevStorage) {
        QueryId queryId = query.getQueryId();
        List<EntityStorageChange> changes = this.changeQueue.get(queryId);
        CellChain cellChain = this.queryIdToChain.get(queryId);
        if (cellChain != null && (changes == null || changes.size() == 0)) {
            return new CachedValue(CacheHit.INSTANCE, cellChain.last());
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            void $this$getOrPut$iv;
            block10: {
                List<EntityStorageChange> doubleCheckChanges;
                block9: {
                    boolean bl = false;
                    doubleCheckChanges = this.changeQueue.get(queryId);
                    CellChain doubleCheckChain = this.queryIdToChain.get(queryId);
                    if (doubleCheckChain == null || doubleCheckChanges != null && doubleCheckChanges.size() != 0) break block9;
                    CachedValue cachedValue = new CachedValue(CacheHitInSynchronized.INSTANCE, doubleCheckChain.last());
                    return cachedValue;
                }
                if (doubleCheckChanges == null || doubleCheckChanges.size() <= 0) break block10;
                EntityStorageChange collapsedChangelog = TracedSnapshotCacheKt.collapse(doubleCheckChanges);
                boolean recalculated = this.updateCellIndex(queryId, collapsedChangelog, snapshot, prevStorage);
                this.changeQueue.remove(queryId);
                CacheProcessingStatus status = recalculated ? (CacheProcessingStatus)IncrementalUpdate.INSTANCE : (CacheProcessingStatus)CacheHitNotAffectedByChanges.INSTANCE;
                CellChain cellChain2 = this.queryIdToChain.get(queryId);
                Intrinsics.checkNotNull((Object)cellChain2);
                CachedValue cachedValue = new CachedValue(status, cellChain2.last());
                return cachedValue;
            }
            CellChain emptyCellChain = QueriesKt.compile$default(query, null, 1, null);
            Pair<CellChain, List<Pair<LongOpenHashSet, CellUpdateInfo>>> chainWithTraces = emptyCellChain.snapshotInput(snapshot);
            CellChain newChain = (CellChain)chainWithTraces.component1();
            List traces = (List)chainWithTraces.component2();
            Map map2 = this.queryIdToTraceIndex;
            QueryId key$iv = newChain.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ReadTraceIndex answer$iv = new ReadTraceIndex();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            map2 = object2;
            ReadTraceIndex index = (ReadTraceIndex)((Object)map2);
            boolean bl = false;
            Iterable $this$forEach$iv = traces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                LongOpenHashSet trace = (LongOpenHashSet)pair.component1();
                CellUpdateInfo updateRequest = (CellUpdateInfo)pair.component2();
                index.set(trace, updateRequest);
            }
            ((Map)this.queryIdToChain).put(newChain.getId(), newChain);
            CachedValue cachedValue = new CachedValue(Initialization.INSTANCE, newChain.last());
            return cachedValue;
        }
    }

    @TestOnly
    @NotNull
    public final Map<QueryId, List<EntityStorageChange>> getChangeQueue$intellij_platform_workspace_storage() {
        return this.changeQueue;
    }

    @TestOnly
    @NotNull
    public final HashMap<QueryId, CellChain> getQueryIdToChain$intellij_platform_workspace_storage() {
        return this.queryIdToChain;
    }

    @TestOnly
    @NotNull
    public final HashMap<QueryId, ReadTraceIndex<CellUpdateInfo>> getQueryIdToTraceIndex$intellij_platform_workspace_storage() {
        return this.queryIdToTraceIndex;
    }

    private final <E> Collection<E> maybeShuffled(Collection<? extends E> $this$maybeShuffled) {
        if (this.shuffleEntities != -1L && $this$maybeShuffled.size() > 1) {
            return CollectionsKt.shuffled((Iterable)$this$maybeShuffled, (Random)new Random(this.shuffleEntities));
        }
        return $this$maybeShuffled;
    }
}

