/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.util.EmptyRunnable;
import java.beans.Introspector;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
@TestOnly
public final class GCUtil {
    @TestOnly
    public static void tryGcSoftlyReachableObjects() {
        GCUtil.tryGcSoftlyReachableObjects(() -> false);
    }

    @TestOnly
    public static void tryGcSoftlyReachableObjects(@NotNull BooleanSupplier stop) {
        if (stop == null) {
            GCUtil.$$$reportNull$$$0(0);
        }
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        System.gc();
        StringBuilder log = new StringBuilder();
        if (!GCUtil.allocateTonsOfMemory(log, EmptyRunnable.getInstance(), () -> ref.isEnqueued() || ref.get() == null || stop.getAsBoolean())) {
            System.out.println("GCUtil.tryGcSoftlyReachableObjects: giving up. Log:\n" + log);
        }
    }

    public static boolean allocateTonsOfMemory(@NotNull StringBuilder log, @NotNull Runnable runWhileWaiting, @NotNull BooleanSupplier until) {
        if (log == null) {
            GCUtil.$$$reportNull$$$0(1);
        }
        if (runWhileWaiting == null) {
            GCUtil.$$$reportNull$$$0(2);
        }
        if (until == null) {
            GCUtil.$$$reportNull$$$0(3);
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        log.append("Free memory: " + freeMemory + "\n");
        int liveChunks = 0;
        ReferenceQueue queue = new ReferenceQueue();
        ArrayList<SoftReference<byte[]>> list = new ArrayList<SoftReference<byte[]>>();
        try {
            for (int i = 0; i < 1000 && !until.getAsBoolean(); ++i) {
                runWhileWaiting.run();
                while (queue.poll() != null) {
                    --liveChunks;
                }
                int bytes = Math.min((int)(Runtime.getRuntime().totalMemory() / 20L), 0x3FFFFFFF);
                log.append("Iteration " + i + ", allocating new byte[" + bytes + "], live chunks: " + liveChunks + ", free memory: " + Runtime.getRuntime().freeMemory() + "\n");
                list.add(new SoftReference<byte[]>(new byte[bytes], queue));
                ++liveChunks;
                if (i <= 0 || i % 100 != 0 || until.getAsBoolean()) continue;
                log.append("  Calling System.gc()\n");
                System.gc();
            }
        }
        catch (OutOfMemoryError e) {
            int size = list.size();
            list.clear();
            e.printStackTrace();
            System.err.println("Log: " + log + "freeMemory() now: " + Runtime.getRuntime().freeMemory() + "; list.size(): " + size);
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw e;
        }
        finally {
            for (Reference reference : list) {
                reference.clear();
            }
        }
        return until.getAsBoolean();
    }

    public static void clearBeanInfoCache() {
        Introspector.flushCaches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhileWaiting";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "until";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ref/GCUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGcSoftlyReachableObjects";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allocateTonsOfMemory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

