/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J4\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020&2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0010H\u0016J\u0010\u0010*\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0010H\u0014J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0016J$\u0010,\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0014J\u0018\u00100\u001a\u00020&2\u0006\u0010-\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u00101\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u00102\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u00103\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0010H\u0002J\u0010\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0010H\u0014J\u0010\u00104\u001a\u00020&2\u0006\u00106\u001a\u00020\u0014H\u0014J\u0010\u00107\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0010H\u0016J\n\u00108\u001a\u00020\u0010H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u00069"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "Lcom/intellij/database/script/generator/NamingService;", "dbms", "Lcom/intellij/database/Dbms;", "plainNamePattern", "Ljava/util/regex/Pattern;", "casing", "Lcom/intellij/database/util/Casing;", "<init>", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Lcom/intellij/database/util/Casing;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getCasing", "()Lcom/intellij/database/util/Casing;", "reservedWords", "", "", "getReservedWords", "()Ljava/util/Set;", "openingQuote", "", "getOpeningQuote", "()C", "closingQuote", "getClosingQuote", "openingQuotes", "getOpeningQuotes", "()Ljava/lang/String;", "closingQuotes", "getClosingQuotes", "getDefaultCasing", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "Lcom/intellij/database/model/DasObject;", "catToScript", "catName", "plain", "", "forceQuoting", "isQuoted", "scrName", "isQuotable", "unquoteIdentifier", "enquote", "name", "op", "cl", "skipQuoting", "isPlain", "isPure", "isIdentifier", "matchesCasing", "identifier", "c", "canScript", "toString", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractNamingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNamingService.kt\ncom/intellij/database/dialects/base/generator/AbstractNamingService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n990#2:114\n1065#2,3:115\n1088#2,2:120\n1915#3,2:118\n*S KotlinDebug\n*F\n+ 1 AbstractNamingService.kt\ncom/intellij/database/dialects/base/generator/AbstractNamingService\n*L\n75#1:114\n75#1:115,3\n98#1:120,2\n75#1:118,2\n*E\n"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Pattern plainNamePattern;
    @NotNull
    private final Casing casing;

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern plainNamePattern, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)plainNamePattern, (String)"plainNamePattern");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        this.dbms = dbms;
        this.plainNamePattern = plainNamePattern;
        this.casing = casing;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final Casing getCasing() {
        return this.casing;
    }

    private final Set<String> getReservedWords() {
        Set set;
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN)) {
            set = SetsKt.emptySet();
        } else {
            Object object = SqlLanguageDialect.EP.forDbms(this.dbms);
            Intrinsics.checkNotNull((Object)object);
            Set set2 = ((SqlLanguageDialect)object).getReservedKeywords();
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getReservedKeywords(...)");
        }
        return set;
    }

    public char getOpeningQuote() {
        return this.getOpeningQuotes().charAt(0);
    }

    public char getClosingQuote() {
        return this.getClosingQuotes().charAt(0);
    }

    @NotNull
    public String getOpeningQuotes() {
        return "\"";
    }

    @NotNull
    public String getClosingQuotes() {
        return "\"";
    }

    @NotNull
    public Casing getDefaultCasing() {
        return this.casing;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getDefaultCasing();
    }

    @NotNull
    public String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain, @Nullable String openingQuotes, boolean forceQuoting) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        if (!forceQuoting && this.skipQuoting(catName, plain)) {
            return catName;
        }
        return this.enquote(catName, kind, openingQuotes);
    }

    public boolean isQuoted(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (scrName.length() < 2) {
            return false;
        }
        int opIdx = StringsKt.indexOf$default((CharSequence)this.getOpeningQuotes(), (char)StringsKt.first((CharSequence)scrName), (int)0, (boolean)false, (int)6, null);
        if (opIdx == -1) {
            return false;
        }
        return StringsKt.last((CharSequence)scrName) == this.getClosingQuotes().charAt(opIdx);
    }

    protected boolean isQuotable(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        return true;
    }

    @NotNull
    public String unquoteIdentifier(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (!this.isQuoted(scrName)) {
            return scrName;
        }
        char quote = StringsKt.last((CharSequence)scrName);
        String string = scrName.substring(1, scrName.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.replace$default((String)string, (String)("" + quote + quote), (String)String.valueOf(quote), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String enquote(@NotNull String scrName, @Nullable ObjectKind kind, @Nullable String openingQuotes) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (!this.isQuotable(scrName)) {
            return scrName;
        }
        String oq = this.getOpeningQuotes();
        String cq = this.getClosingQuotes();
        int any = 0;
        any = -1;
        String string = openingQuotes;
        if (string != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.indexOf$default((CharSequence)oq, (char)it, (int)0, (boolean)false, (int)6, null));
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = (Iterable)new IntRange(0, StringsKt.getLastIndex((CharSequence)oq));
        }
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i = ((Number)element$iv).intValue();
            boolean bl = false;
            if (i == -1) continue;
            if (any == -1) {
                any = i;
            }
            if (StringsKt.contains$default((CharSequence)scrName, (char)cq.charAt(i), (boolean)false, (int)2, null)) continue;
            return this.enquote(scrName, oq.charAt(i), cq.charAt(i));
        }
        if (any == -1) {
            any = 0;
        }
        return this.enquote(scrName, oq.charAt(any), cq.charAt(any));
    }

    @NotNull
    protected String enquote(@NotNull String name, char op, char cl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        char c = op;
        String string = StringsKt.replace$default((String)name, (String)String.valueOf(cl), (String)("" + cl + cl), (boolean)false, (int)4, null);
        return c + string + cl;
    }

    private final boolean skipQuoting(String name, boolean plain) {
        return (plain || this.casing.plain == this.casing.quoted ? this.isPlain(name) : this.isPure(name)) && !this.getReservedWords().contains(name);
    }

    public boolean isPlain(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.isIdentifier(name);
    }

    public boolean isPure(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.isIdentifier(name) && this.matchesCasing(name);
    }

    private final boolean isIdentifier(String name) {
        CharSequence charSequence = name;
        return new Regex(this.plainNamePattern).matches(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean matchesCasing(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (this.casing.plain != Case.UPPER) {
            if (this.casing.plain != Case.LOWER) return true;
        }
        if (this.casing.plain == this.casing.quoted) return true;
        CharSequence $this$all$iv = identifier;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (!this.matchesCasing(it)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean matchesCasing(char c) {
        Case case_ = this.casing.plain;
        return switch (case_ == null ? -1 : WhenMappings.$EnumSwitchMapping$0[case_.ordinal()]) {
            case 1 -> {
                if (!Character.isLowerCase(c)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!Character.isUpperCase(c)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public boolean canScript(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.isPlain(name) && !this.getReservedWords().contains(name);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ":\n\tdbms: " + this.dbms + "\n\tcasing: " + this.casing + "\n\tplain pattern: " + this.plainNamePattern + "\n";
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Case.values().length];
            try {
                nArray[Case.UPPER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Case.LOWER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

