/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.bun.runConfiguration.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfiguration;
import com.intellij.javascript.bun.runConfiguration.run.BunRunConfigurationType;
import com.intellij.javascript.bun.settings.BunRuntimeType;
import com.intellij.javascript.runtime.settings.JSRuntimeConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0014J\f\u0010\u000f\u001a\u00020\b*\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/javascript/bun/runConfiguration/run/BunRunConfigurationType;", "setupConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isAcceptable", "isConfigurationFromContext", "toNioPath", "Ljava/nio/file/Path;", "intellij.javascript.bun"})
@SourceDebugExtension(value={"SMAP\nBunRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BunRunConfigurationProducer.kt\ncom/intellij/javascript/bun/runConfiguration/run/BunRunConfigurationProducer\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n*L\n1#1,65:1\n26#2:66\n*S KotlinDebug\n*F\n+ 1 BunRunConfigurationProducer.kt\ncom/intellij/javascript/bun/runConfiguration/run/BunRunConfigurationProducer\n*L\n17#1:66\n*E\n"})
public final class BunRunConfigurationProducer
extends LazyRunConfigurationProducer<BunRunConfiguration> {
    @NotNull
    public BunRunConfigurationType getConfigurationFactory() {
        boolean $i$f$runConfigurationType = false;
        return (BunRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(BunRunConfigurationType.class);
    }

    protected boolean setupConfigurationFromContext(@NotNull BunRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        if (!this.isAcceptable(context)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)sourceElement.get();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return false;
        }
        PsiElement psiFile = psiElement;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile workingDirectory = virtualFile3;
        if (!Intrinsics.areEqual((Object)JSRuntimeConfiguration.Companion.getInstance(project2).getRuntimeType(), (Object)BunRuntimeType.INSTANCE)) {
            return false;
        }
        configuration.setWorkingDirectory(workingDirectory.getPath());
        configuration.setFilePath(virtualFile2.getPath());
        configuration.setGeneratedName();
        sourceElement.set((Object)psiFile);
        return true;
    }

    private final boolean isAcceptable(ConfigurationContext $this$isAcceptable) {
        RunConfiguration runConfiguration = $this$isAcceptable.getOriginalConfiguration(null);
        return runConfiguration == null ? true : runConfiguration instanceof NodeJsRunConfiguration;
    }

    public boolean isConfigurationFromContext(@NotNull BunRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isAcceptable(context)) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        VirtualFile virtualFile = location2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return Intrinsics.areEqual((Object)file.toNioPath(), (Object)this.toNioPath(configuration));
    }

    private final Path toNioPath(BunRunConfiguration $this$toNioPath) {
        String string = $this$toNioPath.getFilePath();
        if (string == null) {
            return null;
        }
        String filePath = string;
        if (OSAgnosticPathUtil.isAbsolute((String)filePath)) {
            return NioFiles.toPath((String)filePath);
        }
        String workingDirectory = $this$toNioPath.getWorkingDirectory();
        if (workingDirectory != null && ((CharSequence)workingDirectory).length() > 0) {
            Path path = NioFiles.toPath((String)workingDirectory);
            return path != null ? path.resolve(filePath) : null;
        }
        return null;
    }
}

