/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.bun.settings;

import com.intellij.javascript.bun.BunBundle;
import com.intellij.javascript.bun.settings.BunSettingsService;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.PathUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/bun/settings/BunSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$Beta;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "pathToBunRuntime", "getPathToBunRuntime", "()Ljava/lang/String;", "setPathToBunRuntime", "(Ljava/lang/String;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validateBunPath", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "textField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "Companion", "intellij.javascript.bun"})
@SourceDebugExtension(value={"SMAP\nBunSettingsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BunSettingsConfigurable.kt\ncom/intellij/javascript/bun/settings/BunSettingsConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class BunSettingsConfigurable
extends BoundSearchableConfigurable
implements Configurable.Beta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String ID = "settings.bun";

    public BunSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = BunBundle.message("settings.bun.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = BunBundle.message("settings.bun.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string, string2, ID);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final String getPathToBunRuntime() {
        String string = ((BunSettingsService.BunSettingsState)BunSettingsService.Companion.getService(this.project).getState()).getBunPath();
        if (string == null) {
            string = "";
        }
        String string2 = PathUtil.toSystemDependentName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    private final void setPathToBunRuntime(String value) {
        ((BunSettingsService.BunSettingsState)BunSettingsService.Companion.getService(this.project).getState()).setBunPath(PathUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)value)).toString()));
    }

    @NotNull
    public DialogPanel createPanel() {
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.singleFile().withTitle(BunBundle.message("settings.bun.select.runtime", new Object[0])).withFileFilter(arg_0 -> BunSettingsConfigurable.createPanel$lambda$1(BunSettingsConfigurable::createPanel$lambda$0, arg_0));
        return BuilderKt.panel(arg_0 -> BunSettingsConfigurable.createPanel$lambda$2(chooserDescriptor, this, arg_0));
    }

    private final ValidationInfo validateBunPath(ValidationInfoBuilder $this$validateBunPath, TextFieldWithBrowseButton textField) {
        ValidationInfo validationInfo;
        Object object;
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        Object object2 = $this$validateBunPath;
        try {
            ValidationInfoBuilder $this$validateBunPath_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Path.of(text, new String[0]));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Path file = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (((CharSequence)text).length() == 0) {
            validationInfo = null;
        } else {
            boolean bl;
            Path path = file;
            if (path != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl = false;
            }
            if (!bl) {
                String string2 = BunBundle.message("settings.bun.file.not.exists.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                validationInfo = $this$validateBunPath.error(string2);
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    String string3 = BunBundle.message("settings.bun.file.is.directory.error", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    validationInfo = $this$validateBunPath.error(string3);
                } else {
                    validationInfo = null;
                }
            }
        }
        return validationInfo;
    }

    private static final ValidationInfo createPanel$lambda$2$0$0(BunSettingsConfigurable this$0, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateBunPath($this$validationOnInput, it);
    }

    private static final ValidationInfo createPanel$lambda$2$0$1(BunSettingsConfigurable this$0, ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateBunPath($this$validationOnApply, it);
    }

    private static final Unit createPanel$lambda$2$0(FileChooserDescriptor $chooserDescriptor, BunSettingsConfigurable this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Intrinsics.checkNotNull((Object)$chooserDescriptor);
        Cell $this$createPanel_u24lambda_u242_u240_u242 = cell = TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)$chooserDescriptor, (Project)this$0.project, null, (int)4, null).align(Align.FILL), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return BunSettingsConfigurable.access$getPathToBunRuntime((BunSettingsConfigurable)((Object)this.receiver));
            }

            public void set(Object value) {
                BunSettingsConfigurable.access$setPathToBunRuntime((BunSettingsConfigurable)((Object)this.receiver), (String)value);
            }
        })).validationOnInput((arg_0, arg_1) -> BunSettingsConfigurable.createPanel$lambda$2$0$0(this$0, arg_0, arg_1)).validationOnApply((arg_0, arg_1) -> BunSettingsConfigurable.createPanel$lambda$2$0$1(this$0, arg_0, arg_1));
        boolean bl = false;
        UiUtils.getEmptyText((TextFieldWithBrowseButton)((TextFieldWithBrowseButton)$this$createPanel_u24lambda_u242_u240_u242.getComponent())).setText("bun");
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0(VirtualFile it) {
        return Intrinsics.areEqual((Object)it.getExtension(), (Object)".exe") || it.getExtension() == null;
    }

    private static final boolean createPanel$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createPanel$lambda$2(FileChooserDescriptor $chooserDescriptor, BunSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = BunBundle.message("settings.bun.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> BunSettingsConfigurable.createPanel$lambda$2$0($chooserDescriptor, this$0, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getPathToBunRuntime(BunSettingsConfigurable $this) {
        return $this.getPathToBunRuntime();
    }

    public static final /* synthetic */ void access$setPathToBunRuntime(BunSettingsConfigurable $this, String value) {
        $this.setPathToBunRuntime(value);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/bun/settings/BunSettingsConfigurable$Companion;", "", "<init>", "()V", "ID", "", "intellij.javascript.bun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

