/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.highlighter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.jetbrains.plugins.jade.highlighter.JadeHighlighter;
import com.jetbrains.plugins.jade.highlighter.JadeSyntaxHighlighter;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeLanguageDialect;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddingUtil;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JadeEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public JadeEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            JadeEditorHighlighter.$$$reportNull$$$0(0);
        }
        super((SyntaxHighlighter)new JadeSyntaxHighlighter(project != null ? CodeStyle.getSettings((Project)project) : CodeStyle.getDefaultSettings()), colors);
        this.registerHTMLLayer(project, virtualFile);
        this.registerCSSLayer(project, virtualFile);
        this.registerJSLayers(project, virtualFile);
        this.registerEmbeddedTokenTypeProviderLayers(project, virtualFile);
    }

    private void registerEmbeddedTokenTypeProviderLayers(Project project, VirtualFile virtualFile) {
        for (EmbeddedTokenTypesProvider provider : EmbeddedTokenTypesProvider.getProviders()) {
            IElementType embeddedTokenType = provider.getElementType();
            Language language = embeddedTokenType.getLanguage();
            this.registerLayer(project, virtualFile, language, embeddedTokenType);
            this.registerLayer(project, virtualFile, language, JadeEmbeddingUtil.getEmbeddedTokenWrapperType(embeddedTokenType));
        }
    }

    private void registerJSLayers(Project project, VirtualFile virtualFile) {
        SyntaxHighlighter jsHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)JavaScriptInJadeLanguageDialect.INSTANCE, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor jsLayer = new LayerDescriptor(jsHighlighter, "\n", JadeHighlighter.JS_BLOCK);
        for (IElementType tokenType : JadeTokenTypes.JS_TOKENS.getTypes()) {
            this.registerLayer(tokenType, jsLayer);
        }
    }

    private void registerCSSLayer(Project project, VirtualFile virtualFile) {
        this.registerLayer(project, virtualFile, (Language)CSSLanguage.INSTANCE, JadeTokenTypes.STYLE_BLOCK);
        this.registerLayer(project, virtualFile, (Language)CSSLanguage.INSTANCE, JadeEmbeddingUtil.getEmbeddedTokenWrapperType(JadeTokenTypes.STYLE_BLOCK));
    }

    private void registerHTMLLayer(Project project, VirtualFile virtualFile) {
        this.registerLayer(project, virtualFile, (Language)HTMLLanguage.INSTANCE, XmlElementType.HTML_EMBEDDED_CONTENT);
    }

    private void registerLayer(Project project, VirtualFile virtualFile, Language language, IElementType tokenType) {
        SyntaxHighlighter cssHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor cssLayer = new LayerDescriptor(cssHighlighter, "\n");
        this.registerLayer(tokenType, cssLayer);
    }

    @NotNull
    public Lexer getLexer() {
        Lexer lexer = super.getLexer();
        if (lexer == null) {
            JadeEditorHighlighter.$$$reportNull$$$0(1);
        }
        return lexer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/highlighter/JadeEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/highlighter/JadeEditorHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

