/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeParser;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;

class JavaScriptInJadeExpressionParser
extends ES6ExpressionParser<JavaScriptInJadeParser> {
    protected JavaScriptInJadeExpressionParser(JavaScriptInJadeParser parser) {
        super((JavaScriptParser)parser);
    }

    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JadeTokenTypes.INTERPOLATED_STRING_START) {
            this.parseInterpolatedString();
            return true;
        }
        if (firstToken == JSTokenTypes.IDENTIFIER && "attributes".equals(this.builder.getTokenText())) {
            return ((JavaScriptInJadeParser)this.parser).getStatementParser().markVariable(false);
        }
        return super.parsePrimaryExpression();
    }

    private void parseInterpolatedString() {
        IElementType tokenType;
        LOG.assertTrue(this.builder.getTokenType() == JadeTokenTypes.INTERPOLATED_STRING_START);
        PsiBuilder.Marker string = this.builder.mark();
        this.builder.advanceLexer();
        while ((tokenType = this.builder.getTokenType()) != null) {
            boolean parseSuccessful;
            if (tokenType == JadeTokenTypes.INTERPOLATED_STRING_END) {
                this.builder.advanceLexer();
                break;
            }
            if (JavaScriptInJadeExpressionParser.isTokenInterpolatedStringPart(tokenType)) {
                this.builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker expression = this.builder.mark();
            boolean bl = parseSuccessful = !this.parseExpressionOptional();
            if (parseSuccessful) {
                this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                this.builder.advanceLexer();
            }
            expression.done(JadeTokenTypes.INTERPOLATED_EXPRESSION);
        }
        string.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
    }

    private static boolean isTokenInterpolatedStringPart(IElementType token) {
        return token == JadeTokenTypes.INTERPOLATED_STRING_START || token == JadeTokenTypes.INTERPOLATED_STRING_END || token == JadeTokenTypes.INTERPOLATED_STRING_PART;
    }
}

