/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddingUtil;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JadeEmbeddingLanguagesLexerDecorator
extends DelegateLexer {
    @Nullable
    private IElementType myFilterCodeReplacementElementType;
    @Nullable
    private IElementType myScriptBlockReplacementElementType;
    private boolean myIsLastTagNameWasScript;
    @NotNull
    private AttrLexState myAttrLexState;

    JadeEmbeddingLanguagesLexerDecorator(@NotNull Lexer delegate) {
        if (delegate == null) {
            JadeEmbeddingLanguagesLexerDecorator.$$$reportNull$$$0(0);
        }
        super(delegate);
        this.myFilterCodeReplacementElementType = null;
        this.myScriptBlockReplacementElementType = null;
        this.myAttrLexState = AttrLexState.NOTHING;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JadeEmbeddingLanguagesLexerDecorator.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.processTokenAndChangeState(this.getTokenType());
    }

    public void advance() {
        super.advance();
        this.processTokenAndChangeState(this.getTokenType());
    }

    private void processTokenAndChangeState(IElementType tokenType) {
        if (tokenType == JadeTokenTypes.FILTER_NAME) {
            this.myFilterCodeReplacementElementType = JadeEmbeddingUtil.getElementToEmbedForFilterName(this.getTokenText());
        } else if (tokenType == JadeTokenTypes.TAG_NAME) {
            this.myIsLastTagNameWasScript = "script".equals(this.getTokenText());
        } else if (this.myIsLastTagNameWasScript) {
            if (tokenType == JadeTokenTypes.ATTRIBUTE_NAME) {
                this.myAttrLexState = "type".equals(this.getTokenText()) ? AttrLexState.SEEN_NAME : AttrLexState.NOTHING;
            } else if (this.myAttrLexState == AttrLexState.SEEN_NAME && (tokenType == JadeTokenTypes.EQ || tokenType == JadeTokenTypes.NEQ)) {
                this.myAttrLexState = AttrLexState.SEEN_NAME_AND_EQ;
            } else if (this.myAttrLexState == AttrLexState.SEEN_NAME_AND_EQ && tokenType == JadeTokenTypes.JS_EXPR) {
                this.myAttrLexState = AttrLexState.NOTHING;
                this.myScriptBlockReplacementElementType = JadeEmbeddingUtil.getElementToEmbedForATag("script", Collections.singletonMap("type", this.getTokenText()));
            } else {
                this.myAttrLexState = AttrLexState.NOTHING;
            }
        }
    }

    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        boolean isEmbeddedCode = false;
        IElementType result = type;
        if (type == JadeTokenTypes.FILTER_CODE && this.myFilterCodeReplacementElementType != null) {
            result = this.myFilterCodeReplacementElementType;
            isEmbeddedCode = true;
        } else if (type == JadeTokenTypes.JS_CODE_BLOCK && this.myScriptBlockReplacementElementType != null) {
            result = this.myScriptBlockReplacementElementType;
            isEmbeddedCode = true;
        }
        if (isEmbeddedCode && result != JadeTokenTypes.JS_CODE_BLOCK || result == JadeTokenTypes.STYLE_BLOCK) {
            result = JadeEmbeddingUtil.getEmbeddedTokenWrapperType(result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingLanguagesLexerDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum AttrLexState {
        NOTHING,
        SEEN_NAME,
        SEEN_NAME_AND_EQ;

    }
}

