/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.view.impl.TerminalEventDispatcher;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalKeyListener;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalState;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\r"}, d2={"setupKeyEventHandling", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "eventsHandler", "Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;", "disposable", "Lcom/intellij/openapi/Disposable;", "setupMouseListener", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "intellij.terminal.frontend"})
public final class TerminalEventDispatcherKt {
    public static final void setupKeyEventHandling(@NotNull EditorEx editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        TerminalEventDispatcher eventDispatcher2 = new TerminalEventDispatcher(editor, settings, eventsHandler, disposable);
        editor.addFocusListener(new FocusChangeListener(eventDispatcher2){
            final /* synthetic */ TerminalEventDispatcher $eventDispatcher;
            {
                this.$eventDispatcher = $eventDispatcher;
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$eventDispatcher.registerIfNeeded();
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$eventDispatcher.unregisterIfRegistered();
            }
        }, disposable);
        if (editor.getContentComponent().hasFocus()) {
            eventDispatcher2.registerIfNeeded();
        }
        editor.getContentComponent().addKeyListener(new TerminalKeyListener(settings, eventsHandler));
    }

    public static final void setupMouseListener(@NotNull EditorEx editor, @NotNull TerminalSessionModel sessionModel, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        editor.addEditorMouseListener(new EditorMouseListener(settings, eventsHandler, sessionModel){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalSessionModel $sessionModel;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$sessionModel = $sessionModel;
            }

            public void mousePressed(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$sessionModel, mouseEvent)) {
                        VisualPosition visualPosition = event.getVisualPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
                        VisualPosition p = visualPosition;
                        int n = p.column;
                        int n2 = p.line;
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mousePressed(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseReleased(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$sessionModel, mouseEvent)) {
                        VisualPosition visualPosition = event.getVisualPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
                        VisualPosition p = visualPosition;
                        int n = p.column;
                        int n2 = p.line;
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseReleased(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(settings, eventsHandler, sessionModel){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalSessionModel $sessionModel;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$sessionModel = $sessionModel;
            }

            public void mouseMoved(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$sessionModel, mouseEvent)) {
                        VisualPosition visualPosition = event.getVisualPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
                        VisualPosition p = visualPosition;
                        int n = p.column;
                        int n2 = p.line;
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseMoved(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseDragged(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$sessionModel, mouseEvent)) {
                        VisualPosition visualPosition = event.getVisualPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
                        VisualPosition p = visualPosition;
                        int n = p.column;
                        int n2 = p.line;
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseDragged(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        MouseWheelListener mouseWheelListener = arg_0 -> TerminalEventDispatcherKt.setupMouseListener$lambda$0(editor, eventsHandler, arg_0);
        editor.getScrollPane().addMouseWheelListener(mouseWheelListener);
        Disposer.register((Disposable)disposable, () -> TerminalEventDispatcherKt.setupMouseListener$lambda$1(editor, mouseWheelListener));
    }

    private static final boolean setupMouseListener$isRemoteMouseAction(TerminalSessionModel $sessionModel, MouseEvent e) {
        return ((TerminalState)$sessionModel.getTerminalState().getValue()).getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !e.isShiftDown();
    }

    private static final void setupMouseListener$lambda$0(EditorEx $editor, TerminalEventsHandler $eventsHandler, MouseWheelEvent event) {
        VisualPosition visualPosition = $editor.xyToVisualPosition(event.getPoint());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"xyToVisualPosition(...)");
        VisualPosition p = visualPosition;
        int n = p.column;
        int n2 = p.line;
        Intrinsics.checkNotNull((Object)event);
        $eventsHandler.mouseWheelMoved(n, n2, event);
    }

    private static final void setupMouseListener$lambda$1(EditorEx $editor, MouseWheelListener $mouseWheelListener) {
        $editor.getScrollPane().removeMouseWheelListener($mouseWheelListener);
    }

    public static final /* synthetic */ boolean access$setupMouseListener$isRemoteMouseAction(TerminalSessionModel $sessionModel, MouseEvent e) {
        return TerminalEventDispatcherKt.setupMouseListener$isRemoteMouseAction($sessionModel, e);
    }
}

