/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"syncEditorCaretWithModel", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "intellij.terminal.frontend"})
public final class TerminalEventsHandlerImplKt {
    public static final void syncEditorCaretWithModel(@NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        int expectedCaretOffset = TerminalViewImplKt.toRelative(outputModel.getCursorOffset(), outputModel);
        Function0 moveCaretAction = () -> TerminalEventsHandlerImplKt.syncEditorCaretWithModel$lambda$0(editor, expectedCaretOffset);
        if (editor.getCaretModel().getOffset() != expectedCaretOffset) {
            LookupEx lookup = LookupManager.getActiveLookup((Editor)((Editor)editor));
            if (lookup != null) {
                lookup.performGuardedChange(() -> TerminalEventsHandlerImplKt.syncEditorCaretWithModel$lambda$1(moveCaretAction));
            } else {
                moveCaretAction.invoke();
            }
        }
    }

    private static final Unit syncEditorCaretWithModel$lambda$0(EditorEx $editor, int $expectedCaretOffset) {
        $editor.getCaretModel().moveToOffset($expectedCaretOffset);
        return Unit.INSTANCE;
    }

    private static final void syncEditorCaretWithModel$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

