/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalNewUserTracker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalEscapeBehaviorChangeNotification;", "", "<init>", "()V", "showNotificationIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "doShowNotification", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalEscapeBehaviorChangeNotification {
    @NotNull
    public static final TerminalEscapeBehaviorChangeNotification INSTANCE = new TerminalEscapeBehaviorChangeNotification();

    private TerminalEscapeBehaviorChangeNotification() {
    }

    @JvmStatic
    public static final void showNotificationIfNeeded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunOnceUtil.runOnceForApp((String)"terminal.escape.behavior.change.notification", () -> TerminalEscapeBehaviorChangeNotification.showNotificationIfNeeded$lambda$0(project));
    }

    private final void doShowNotification(Project project) {
        NotificationAction notificationAction = NotificationAction.createSimple((String)TerminalBundle.message("escape.behavior.change.notification.action", new Object[0]), () -> TerminalEscapeBehaviorChangeNotification.doShowNotification$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
        NotificationAction configureAction = notificationAction;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("terminal");
        String string = TerminalBundle.message("escape.behavior.change.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = TerminalBundle.message("escape.behavior.change.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)configureAction).notify(project);
    }

    private static final void showNotificationIfNeeded$lambda$0(Project $project) {
        AnAction moveFocusToEditorAction = ActionManager.getInstance().getAction("Terminal.SwitchFocusToEditor");
        if (!TerminalNewUserTracker.Companion.isNewUserForRelease() && !moveFocusToEditorAction.getShortcutSet().hasShortcuts()) {
            INSTANCE.doShowNotification($project);
        }
    }

    private static final void doShowNotification$lambda$0(Project $project) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "terminal", TerminalBundle.message("settings.move.focus.to.editor.with", new Object[0]));
    }
}

