/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.BuildNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalFirstIdeSessionMoment;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalNewUserTracker;", "Lcom/intellij/ide/AppLifecycleListener;", "<init>", "()V", "appStarted", "", "Companion", "intellij.terminal"})
public final class TerminalNewUserTracker
implements AppLifecycleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TerminalNewUserTracker() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment() || AppMode.isRemoteDevHost()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void appStarted() {
        TerminalUsageLocalStorage storage2 = TerminalUsageLocalStorage.Companion.getInstance();
        if (InitialConfigImportState.isNewUser()) {
            BuildNumber buildNumber = BuildNumber.currentVersion();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"currentVersion(...)");
            TerminalFirstIdeSessionMoment.Version moment = new TerminalFirstIdeSessionMoment.Version(buildNumber);
            storage2.recordFirstIdeSessionMoment(moment);
        } else if (storage2.getState().getFirstIdeSessionMoment() == null) {
            storage2.recordFirstIdeSessionMoment(TerminalFirstIdeSessionMoment.BeforeTrackingStarted.INSTANCE);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalNewUserTracker$Companion;", "", "<init>", "()V", "isNewUserForRelease", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isNewUserForRelease() {
            TerminalFirstIdeSessionMoment terminalFirstIdeSessionMoment = TerminalUsageLocalStorage.Companion.getInstance().getState().getFirstIdeSessionMoment();
            if (terminalFirstIdeSessionMoment == null) {
                return false;
            }
            TerminalFirstIdeSessionMoment moment = terminalFirstIdeSessionMoment;
            return moment instanceof TerminalFirstIdeSessionMoment.Version && ((TerminalFirstIdeSessionMoment.Version)moment).getBuild().getBaselineVersion() == BuildNumber.currentVersion().getBaselineVersion();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

