/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.wsl.WSLDistribution;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.commit.signing.GpgAgentPathsLocator;
import git4idea.commit.signing.GpgAgentPathsLocatorKt;
import git4idea.config.GitExecutable;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/commit/signing/WslGpgAgentPathsLocator;", "Lgit4idea/commit/signing/GpgAgentPathsLocator;", "executable", "Lgit4idea/config/GitExecutable$Wsl;", "<init>", "(Lgit4idea/config/GitExecutable$Wsl;)V", "resolvePaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "getPathInWslUserHome", "", "getWindowsAccessibleGpgHome", "Ljava/nio/file/Path;", "intellij.vcs.git"})
final class WslGpgAgentPathsLocator
implements GpgAgentPathsLocator {
    @NotNull
    private final GitExecutable.Wsl executable;

    public WslGpgAgentPathsLocator(@NotNull GitExecutable.Wsl executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        this.executable = executable;
    }

    @Override
    @Nullable
    public GpgAgentPaths resolvePaths() {
        try {
            Path path = this.getWindowsAccessibleGpgHome(this.executable);
            if (path == null) {
                return null;
            }
            Path gpgAgentHome = path;
            String string = this.getPathInWslUserHome(this.executable);
            if (string == null) {
                return null;
            }
            String wslUserHome = string;
            String pathToPinentryAppInWsl = wslUserHome + "/.gnupg/pinentry-ide.sh";
            return GpgAgentPaths.Companion.create(gpgAgentHome, pathToPinentryAppInWsl);
        }
        catch (InvalidPathException e) {
            GpgAgentPathsLocatorKt.access$getLOG$p().warn("Cannot resolve path", (Throwable)e);
            return null;
        }
    }

    private final String getPathInWslUserHome(GitExecutable.Wsl executable) {
        String wslUserHomePath;
        WSLDistribution wslDistribution = executable.getDistribution();
        String string = wslDistribution.getUserHome();
        if (string != null) {
            char[] cArray = new char[]{'/'};
            v1 = StringsKt.trimEnd((String)string, (char[])cArray);
        } else {
            v1 = wslUserHomePath = null;
        }
        if (wslUserHomePath == null) {
            return null;
        }
        GpgAgentPathsLocatorKt.access$getLOG$p().debug("User home path in WSL = " + wslUserHomePath);
        return wslUserHomePath;
    }

    private final Path getWindowsAccessibleGpgHome(GitExecutable.Wsl executable) {
        WSLDistribution wslDistribution = executable.getDistribution();
        String wslUserHomePath = this.getPathInWslUserHome(executable);
        if (wslUserHomePath != null) {
            String[] stringArray = new String[]{".gnupg"};
            return Path.of(wslDistribution.getWindowsPath(wslUserHomePath), stringArray);
        }
        GpgAgentPathsLocatorKt.access$getLOG$p().warn("Cannot resolve wsl user home path");
        return null;
    }
}

